set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8515975';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-11-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      '3202204',
      1,
      1.083419,
      2,
      0,
      '3111',
      2.122634,
      NULL,
      0,
      14.453576,
      ' 5- 5-1998',
      11.878056,
      NULL,
      0.405553,
      NULL,
      0.227711,
      ' 9- 8-1981',
      86,
      3,
      300,
      3.443057,
      4.711075,
      NULL,
      NULL,
      ' 4-10-1986',
      2.708325,
      NULL,
      1.518676,
      1,
      NULL,
      1,
      5.607003,
      0,
      0,
      86,
      8,
      15.560394,
      7.285833,
      2.971560,
      21,
      5,
      10.667164,
      3,
      NULL,
      3.052498,
      3.861503,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.491929,
      2.175117,
      5.359365,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.186479,
      1.587975,
      2,
      NULL,
      2,
      3.273688,
      1.267816,
      2,
      1,
      3.631827,
      2,
      2.635412,
      1,
      1.934787,
      2.066002,
      1,
      1.336461,
      1.201944,
      NULL,
      12.465140,
      0.879805,
      1.832146,
      2.988629,
      1,
      1.801453,
      4,
      1,
      1,
      1.723294,
      0,
      1,
      0.070649,
      NULL,
      0,
      5.161483,
      8.199477,
      3.747213,
      NULL,
      NULL,
      2.602827,
      7.886073,
      3.727064,
      3,
      2.082342,
      46,
      2.957470,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.038913,
      NULL,
      39,
      18.265837,
      0,
      NULL,
      22.811445,
      17.117099,
      3.474455,
      1.287786,
      NULL,
      12.395101,
      3,
      3,
      18.260068,
      2.376067,
      2,
      NULL,
      3.673168,
      1.558060,
      NULL,
      1.685463,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.224932,
      NULL,
      0.970071,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.117285,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      1,
      0,
      1.425159,
      NULL,
      NULL,
      NULL,
      0.694040,
      11.084071,
      2.485163,
      8.302916,
      1.637933,
      NULL,
      NULL,
      NULL,
      1,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      1.745265,
      0.720694,
      0,
      NULL,
      0.858106,
      1.348564,
      NULL,
      0,
      NULL,
      NULL,
      1.748400,
      NULL,
      0,
      0,
      1.388868,
      1.271250,
      NULL,
      NULL,
      3.239945,
      3,
      4,
      12.556334,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      16,
      12.076951,
      10.110745,
      1,
      NULL,
      NULL,
      NULL,
      2.178439,
      1.673178,
      3.774325,
      0,
      NULL,
      0,
      NULL,
      NULL,
      6.485413,
      5.673444,
      NULL,
      1.351858,
      2.823873,
      8,
      3,
      1.582624,
      5.438702,
      5.523757,
      3.577477,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.805519,
      NULL,
      2,
      3.107117,
      2.900124,
      1.352820,
      8,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.357534,
      19.230998,
      7.458075,
      2.604328,
      3.581139,
      NULL,
      0.160181,
      2,
      0,
      9,
      5,
      2,
      0,
      3,
      NULL,
      3.229402,
      3.451182,
      NULL,
      NULL,
      3.685765,
      3,
      1.893079,
      0.032928,
      1,
      NULL,
      0.255421,
      3.501282,
      0,
      7,
      NULL,
      0.666149,
      3.231522,
      NULL,
      0.871535,
      1.945188,
      NULL,
      NULL,
      NULL,
      3.861133,
      NULL,
      NULL,
      1.711702,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.001942,
      NULL,
      NULL,
      4.491766,
      NULL,
      NULL,
      15,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13.054525,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.963753,
      2,
      2,
      1,
      1.269575,
      1.231953,
      NULL,
      NULL,
      NULL,
      2.901018,
      3.860489,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.221802,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12.895217,
      18.744612,
      NULL,
      NULL,
      8.305848,
      5,
      NULL,
      NULL,
      17,
      NULL,
      NULL,
      NULL,
      10.729854,
      NULL,
      NULL,
      NULL,
      18,
      15,
      NULL,
      NULL,
      4,
      9,
      NULL,
      NULL,
      2,
      19.966329,
      NULL,
      NULL,
      0.228273,
      NULL,
      NULL,
      NULL,
      0.938422,
      2,
      6.841656,
      2,
      0.548035,
      1867.345039,
      550,
      1,
      1372,
      1346.985071,
      NULL,
      NULL,
      NULL,
      1.216053,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.777785,
      NULL,
      0,
      12966.365756,
      NULL,
      1,
      1,
      0.449410,
      0.131218,
      1.257061,
      1,
      NULL,
      1.529614,
      0.352894,
      1,
      1,
      0,
      1.762964,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.186410,
      2,
      2.311198,
      7.837763,
      1.621983,
      2,
      NULL,
      0.588193,
      5,
      1.027009,
      0.900993,
      2.691533,
      1.277541,
      0.294921,
      0.635434,
      4.034583,
      8,
      9.188591,
      NULL,
      14,
      1.294007,
      1.805099,
      0,
      1,
      1,
      1,
      2,
      NULL,
      17.329566,
      1,
      NULL,
      3,
      0.906543,
      15.673630,
      7,
      2,
      13.950881,
      NULL,
      5,
      NULL,
      15,
      3.572658,
      15,
      16,
      7.175667,
      NULL,
      1.534954,
      1.094122,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.699323,
      2.368535,
      1.425006,
      0,
      3.376021,
      2,
      3.201294,
      NULL,
      2,
      3,
      1,
      3.849240,
      2.667437,
      NULL,
      8,
      3.004716,
      0.571675,
      0,
      0,
      1.420792,
      2.830501,
      0,
      2.367936,
      21,
      1,
      NULL,
      1,
      NULL,
      2,
      3,
      1,
      0,
      1.474875,
      6,
      4.016052,
      3,
      1,
      NULL,
      69,
      25,
      10.305371,
      0,
      NULL,
      '12021',
      '12341',
      NULL,
      1.907103,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


