set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0108712';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-3-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1.125218,
      2,
      0.177397,
      5,
      4,
      2.627673,
      0.900696,
      1,
      '420',
      '24314411',
      80.109648,
      68,
      NULL,
      2.724380,
      NULL,
      2,
      3,
      '3240',
      0.155219,
      1.993516,
      NULL,
      NULL,
      ' 3-26-1987',
      33,
      68.796909,
      NULL,
      1.725046,
      5.162498,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      ' 0-19-1982',
      1,
      3,
      0.821902,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      15.318144,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      4.764613,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      1,
      1,
      1,
      0.591875,
      0,
      NULL,
      0.517584,
      3.804659,
      4.915882,
      2,
      3,
      1,
      NULL,
      1.549859,
      NULL,
      0,
      1.685467,
      1.855051,
      NULL,
      0.007265,
      NULL,
      1,
      1.077373,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.838899,
      1.716942,
      0.817117,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.616423,
      4,
      1.421114,
      1.350536,
      0.785405,
      1,
      1.734136,
      0.922471,
      4.397651,
      0.474102,
      1.456538,
      1.838329,
      0,
      1.162382,
      NULL,
      0.317697,
      1,
      NULL,
      0,
      1,
      1,
      0,
      0,
      NULL,
      1,
      0,
      1.745757,
      1.421780,
      0.837795,
      NULL,
      1,
      8.204984,
      NULL,
      7.807972,
      5.852461,
      3,
      7.227035,
      2.313599,
      2,
      0.218026,
      NULL,
      0.960948,
      0.109074,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.237914,
      0.888965,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.149072,
      0.041415,
      1,
      0,
      1,
      0.037971,
      1,
      1.753168,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.035234,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.679789,
      0.102670,
      NULL,
      NULL,
      NULL,
      2,
      0.464985,
      6.671589,
      2.801767,
      1.553576,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      6.210261,
      1.608740,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.615660,
      NULL,
      0,
      0.121527,
      NULL,
      1.757664,
      NULL,
      3.908670,
      6.833331,
      NULL,
      NULL,
      10.539921,
      5,
      NULL,
      3.687170,
      1,
      2,
      1.371435,
      1,
      0.674843,
      NULL,
      0,
      3,
      3,
      2,
      0.235202,
      NULL,
      0.900362,
      2,
      2.265779,
      4,
      0.736811,
      1,
      NULL,
      1.369010,
      1.921434,
      0.041523,
      1,
      0.373230,
      5,
      0,
      NULL,
      2.725024,
      0.506061,
      0.804928,
      NULL,
      8.052217,
      1,
      4,
      3,
      0.437611,
      NULL,
      2,
      1.503893,
      1.425156,
      NULL,
      0,
      3.261544,
      5.113765,
      1,
      1.791966,
      16,
      NULL,
      3.211711,
      98,
      NULL,
      4,
      3.819598,
      '20310',
      '12321',
      '42003',
      0,
      NULL,
      '',
      NULL,
      1,
      NULL,
      '',
      '',
      2,
      38,
      137,
      40.828678,
      0,
      0.147507,
      2,
      12.855378,
      8.698357,
      0.623930,
      NULL,
      0.677708,
      2.691187,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      3,
      1,
      0.268255,
      NULL,
      NULL,
      2,
      1,
      1,
      1.652372,
      NULL,
      NULL,
      3.116509,
      0,
      1.486160,
      NULL,
      NULL,
      NULL,
      9,
      0,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      2.323897,
      3.280373,
      1,
      0,
      2.641739,
      2,
      1,
      1,
      1.027072,
      1.624612,
      3,
      2,
      0,
      1,
      2,
      3,
      1.440028,
      1,
      1,
      0.367350,
      1.488764,
      1,
      NULL,
      1.984474,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.922438,
      NULL,
      0,
      3,
      1.799688,
      NULL,
      3,
      1.488145,
      NULL,
      0.383814,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      3.452338,
      0.148295,
      0,
      0,
      1.611484,
      NULL,
      NULL,
      3,
      2,
      0,
      1.826539,
      NULL,
      NULL,
      3.766378,
      0,
      5,
      3.217825,
      NULL,
      1.429446,
      1,
      1.328620,
      1,
      3.938932,
      NULL,
      4.459859,
      1,
      NULL,
      NULL,
      1.180087,
      NULL,
      NULL,
      1.586030,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.717214,
      NULL,
      NULL,
      0.973459,
      1,
      0,
      3,
      NULL,
      1.657385,
      4.825815,
      1.798931,
      0.513312,
      2,
      NULL,
      1.467250,
      0,
      NULL,
      NULL,
      1,
      0,
      0.390165,
      3.313751,
      2.898578,
      1,
      1,
      3.413475,
      2,
      NULL,
      1,
      7,
      2.951666,
      2.998200,
      0.880141,
      2,
      NULL,
      1.138453,
      1.805441,
      1.391761,
      2,
      3,
      0,
      1,
      2,
      0.726223,
      0,
      1.801394,
      0,
      3,
      3,
      0.522443,
      1,
      0.424951,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.053990,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.777689,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.874543,
      NULL,
      NULL,
      0.153582,
      3.885117,
      3.087271,
      0,
      NULL,
      2.427159,
      1,
      NULL,
      0.411267,
      1,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.728907,
      NULL,
      NULL,
      NULL,
      3.344648,
      NULL,
      NULL,
      NULL,
      0.837671,
      NULL,
      1.257351,
      NULL,
      0.814704,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      1.871646,
      NULL,
      NULL,
      1.640253,
      0,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      0.334445,
      0.776326,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1,
      3.544961,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      0.683383,
      NULL,
      NULL,
      2,
      1.857016,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3,
      0.694895,
      NULL,
      NULL,
      NULL,
      2.293878,
      76,
      NULL,
      0,
      4.732359,
      0,
      0.468721,
      NULL,
      NULL,
      1.758442,
      NULL,
      NULL,
      0.643179,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.854213,
      NULL,
      0.683324,
      57.529545,
      24.253245,
      1,
      0.955431,
      1,
      1.145948,
      0.666802,
      1,
      NULL,
      0.418177,
      NULL,
      NULL,
      1,
      0,
      0.467118,
      0.294500,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.094128,
      0.349292,
      1.776185,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.924875,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.021055,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.789078,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.139144,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.028778,
      0.835734,
      2.930487,
      0,
      NULL,
      0.460267,
      NULL,
      NULL,
      2.303737,
      1,
      NULL,
      0.004701,
      1,
      0,
      2.233621,
      1.795095,
      11,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.058406,
      2,
      3,
      1.674003,
      3,
      2,
      3,
      0,
      8.582526,
      0.671238,
      1,
      2.024723,
      0,
      NULL,
      0.389526,
      1,
      0.101647,
      1,
      0,
      0.424424,
      NULL,
      0,
      NULL,
      0,
      1.439750,
      1.501693,
      1,
      1,
      1.791665,
      1.099154,
      1.013389,
      1.044439,
      2.118842,
      1.574094,
      1,
      NULL,
      0,
      0.887735,
      0.062120,
      1.413467,
      1.399816,
      3.663395,
      NULL,
      1.399336,
      1,
      2.068435,
      0.085539,
      1.505589,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      1.861017,
      5,
      3,
      4.615942,
      0,
      NULL,
      NULL,
      34,
      54.997664,
      0.339126,
      0.009866,
      7.655312,
      '20144',
      '41330',
      '24414',
      0.638184,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


