set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8807476';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-7-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      '3313004',
      0.031855,
      1,
      1,
      1,
      '2004',
      3,
      1.057936,
      NULL,
      NULL,
      '10- 2-1990',
      37,
      NULL,
      NULL,
      2,
      1,
      '11-19-1994',
      36.150268,
      NULL,
      101,
      NULL,
      1.507415,
      ' 6-14-1996',
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2,
      1.624827,
      0.401719,
      121,
      7,
      4.225968,
      5.573262,
      NULL,
      194,
      NULL,
      11,
      NULL,
      1.009685,
      8,
      1.624857,
      NULL,
      1.827700,
      0.242893,
      0.683577,
      1,
      0,
      1,
      0,
      0.958950,
      191,
      10,
      NULL,
      1.623239,
      1,
      NULL,
      8.891741,
      0.191742,
      1.744379,
      5.286171,
      NULL,
      NULL,
      3,
      6.566836,
      0,
      1,
      1.600945,
      0.245326,
      0,
      4,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.757744,
      NULL,
      1,
      0.455762,
      0.281332,
      0.637514,
      NULL,
      NULL,
      NULL,
      3,
      2.538375,
      NULL,
      2.247242,
      NULL,
      NULL,
      0,
      1,
      2.186819,
      NULL,
      2,
      1.457193,
      5.629637,
      10.897505,
      0.494792,
      2.611522,
      1,
      NULL,
      NULL,
      NULL,
      1.760865,
      NULL,
      NULL,
      0,
      NULL,
      7,
      NULL,
      8,
      1,
      3.926696,
      1,
      0,
      0.622526,
      0.781493,
      0.905132,
      1.590574,
      1,
      0.527183,
      NULL,
      1,
      1.909068,
      NULL,
      NULL,
      NULL,
      6.088594,
      1.457069,
      NULL,
      2.079009,
      1.667868,
      4,
      2,
      3,
      10.262134,
      3.137919,
      5.877374,
      2,
      4,
      NULL,
      1,
      7,
      NULL,
      11,
      NULL,
      10.035978,
      0,
      4.497164,
      NULL,
      5,
      3,
      9.509850,
      NULL,
      NULL,
      NULL,
      ' 7-20-1989',
      172,
      1.870069,
      1.254208,
      NULL,
      4,
      0.279756,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.557055,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      0.784973,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.089530,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      11.569009,
      NULL,
      NULL,
      9.402582,
      1.486447,
      NULL,
      NULL,
      NULL,
      0.850366,
      2.187111,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.130993,
      0,
      1.450783,
      0,
      NULL,
      1.197227,
      NULL,
      0,
      NULL,
      2,
      1.466033,
      NULL,
      NULL,
      NULL,
      2.294848,
      1,
      NULL,
      0.126766,
      NULL,
      3,
      NULL,
      1.363626,
      1,
      3.815966,
      NULL,
      2.662784,
      0.123343,
      2,
      2.835062,
      2.847270,
      1.317424,
      0.624580,
      0.577960,
      0.333650,
      1,
      NULL,
      1.384639,
      1,
      1,
      NULL,
      0.404340,
      NULL,
      NULL,
      0,
      1.519288,
      1,
      2,
      5,
      1,
      10.234400,
      NULL,
      4,
      3.888718,
      3,
      NULL,
      2.367834,
      1,
      0.620803,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      17.852080,
      4.752234,
      0,
      3.822071,
      NULL,
      '10343',
      '14100',
      1,
      '',
      '',
      NULL,
      NULL,
      '42130',
      '3022',
      '4024',
      3,
      20,
      NULL,
      12.282729,
      2,
      NULL,
      NULL,
      7,
      2,
      3,
      3,
      3,
      0.071323,
      NULL,
      NULL,
      1.790549,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      2.090173,
      1.432679,
      3,
      1,
      0.693688,
      0,
      NULL,
      NULL,
      2,
      3,
      0.994050,
      NULL,
      2.762970,
      1.819238,
      1.541310,
      NULL,
      NULL,
      1.798168,
      NULL,
      NULL,
      2,
      8.500630,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.581133,
      NULL,
      NULL,
      NULL,
      3.094079,
      3.504894,
      2.235142,
      NULL,
      NULL,
      3.631214,
      2,
      3.887523,
      3.683483,
      0.327095,
      1,
      NULL,
      3,
      0.452228,
      0,
      2.109680,
      1,
      0.650629,
      1,
      3,
      NULL,
      2.594004,
      0,
      NULL,
      0.518939,
      0.842322,
      3.867002,
      1.551086,
      1.991533,
      NULL,
      NULL,
      2.933870,
      2,
      3,
      4.831402,
      7,
      6,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.469764,
      NULL,
      NULL,
      NULL,
      0.862758,
      NULL,
      NULL,
      1.180647,
      NULL,
      1.351648,
      3.418391,
      1.437646,
      1.809478,
      0.114111,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      2,
      1,
      NULL,
      NULL,
      NULL,
      4.959456,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.420230,
      NULL,
      NULL,
      0.038487,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.018250,
      NULL,
      3,
      1,
      3.680092,
      NULL,
      5,
      9,
      0.740930,
      8.323952,
      NULL,
      3.117410,
      NULL,
      2.526600,
      0,
      0,
      1.536983,
      0,
      1.948814,
      3,
      NULL,
      3,
      2,
      3,
      NULL,
      1.189583,
      7.012979,
      NULL,
      3.380608,
      0,
      3.567401,
      3.639795,
      NULL,
      3.186186,
      0.902789,
      3,
      3,
      1.644924,
      1,
      9,
      0.595537,
      6,
      5,
      7,
      1.592179,
      3.279836,
      1.841142,
      NULL,
      0,
      1,
      1.807392,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.476427,
      NULL,
      NULL,
      0.109744,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.197365,
      NULL,
      NULL,
      1,
      0.348364,
      NULL,
      1.900931,
      NULL,
      1.913065,
      NULL,
      NULL,
      NULL,
      1.837641,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.958599,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.218206,
      NULL,
      NULL,
      NULL,
      0.432925,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.296672,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.991125,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5.575891,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      79,
      40,
      0,
      7,
      1,
      1.215678,
      NULL,
      NULL,
      2,
      6.718178,
      1.798908,
      2.598987,
      4,
      NULL,
      1.069689,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      0,
      NULL,
      1.724296,
      0.333542,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      0.658241,
      1,
      2.941156,
      0.454565,
      0,
      0.764435,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.084863,
      NULL,
      NULL,
      NULL,
      3,
      18.834707,
      12.417591,
      0,
      1.661456,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.057985,
      NULL,
      0.779648,
      NULL,
      0,
      NULL,
      0.829310,
      NULL,
      0.010542,
      NULL,
      1.883377,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.343243,
      NULL,
      0,
      NULL,
      0.839286,
      NULL,
      1.327038,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.145761,
      NULL,
      2.713823,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.025936,
      NULL,
      0.233175,
      NULL,
      1.142862,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.970022,
      0.288487,
      NULL,
      1,
      NULL,
      1.288610,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.773741,
      NULL,
      0,
      NULL,
      3,
      NULL,
      133,
      NULL,
      3.136841,
      NULL,
      0.227911,
      NULL,
      0.384831,
      0.229615,
      1,
      7.106097,
      50.940641,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.191840,
      2.615152,
      2,
      1.473135,
      1,
      NULL,
      2.786000,
      6.368224,
      NULL,
      1,
      0.847025,
      NULL,
      1,
      NULL,
      0.710731,
      1,
      NULL,
      0.519318,
      1,
      NULL,
      1.727276,
      1,
      NULL,
      0.241108,
      0.998569,
      NULL,
      1.698019,
      1.383433,
      NULL,
      0,
      1.617799,
      NULL,
      0.073044,
      NULL,
      NULL,
      0.011716,
      NULL,
      NULL,
      1.125707,
      1.429795,
      NULL,
      1.187546,
      0.651419,
      NULL,
      NULL,
      0.510200,
      1.486126,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.474742,
      NULL,
      0.335343,
      NULL,
      1,
      NULL,
      NULL,
      6.636589,
      6.879196,
      NULL,
      0,
      NULL,
      NULL,
      37.468729,
      3.033249,
      1.806211,
      5.221112,
      '30230',
      '14243',
      '23214',
      0.695374,
      NULL,
      '',
      '',
      1,
      '11304',
      '3023',
      '1232');
commit;
end;
/


