set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8902854';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-1-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '0',
      NULL,
      NULL,
      '3111211',
      2,
      1,
      1,
      3,
      '0003',
      1.510828,
      1.630809,
      NULL,
      0.337024,
      ' 6-16-1994',
      6,
      NULL,
      4,
      NULL,
      1,
      ' 4-16-1978',
      13.888642,
      3.317665,
      905,
      NULL,
      5.530594,
      NULL,
      NULL,
      NULL,
      1,
      1.937743,
      1,
      0.314628,
      0,
      2.422086,
      NULL,
      0,
      3,
      NULL,
      5.830604,
      3,
      8.217284,
      NULL,
      156.424348,
      2.056716,
      4.824540,
      17.461198,
      NULL,
      1.717592,
      0.998310,
      0.956292,
      0.304588,
      1,
      1.167467,
      0.149864,
      0.146578,
      1,
      NULL,
      1.650972,
      1.327998,
      0,
      2,
      1.465457,
      2,
      1.765864,
      0,
      1.812478,
      1,
      0.591149,
      0.044589,
      0.761925,
      1.522245,
      1.910305,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.436497,
      0.304292,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.959653,
      0.194373,
      0.180771,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.119388,
      1,
      3.047597,
      NULL,
      1.708158,
      0,
      0,
      1,
      1.738555,
      5.767233,
      NULL,
      1.232763,
      NULL,
      NULL,
      0.732961,
      0.752570,
      NULL,
      0,
      0,
      NULL,
      1.188003,
      NULL,
      0.860289,
      1.721160,
      1,
      0.950297,
      3.906492,
      1,
      NULL,
      NULL,
      1.429077,
      1,
      NULL,
      0.597677,
      NULL,
      0.659791,
      NULL,
      NULL,
      NULL,
      1.121797,
      0.549638,
      1.191804,
      1.577265,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.075255,
      NULL,
      0.877601,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.322591,
      0,
      0,
      0,
      NULL,
      1.779091,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.986741,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.842265,
      1.753997,
      0.864929,
      NULL,
      NULL,
      1.304037,
      NULL,
      NULL,
      1.679763,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.829905,
      0,
      3,
      5.860901,
      5.123584,
      2,
      3,
      2,
      2,
      5,
      NULL,
      0,
      0.834792,
      NULL,
      17,
      1,
      1,
      0.525637,
      5.419664,
      1,
      1,
      2.480434,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      0.012246,
      3,
      0.230767,
      0,
      5,
      3,
      1.745949,
      2.987923,
      2,
      NULL,
      3,
      7,
      2.914007,
      3,
      2.552269,
      20,
      1.632998,
      NULL,
      158,
      NULL,
      NULL,
      NULL,
      2.158810,
      0.299802,
      1.272365,
      '34322',
      '23434',
      NULL,
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      1.032533,
      21.706999,
      529.374824,
      11,
      NULL,
      NULL,
      5.746331,
      8.335802,
      1,
      3.618594,
      3,
      0.140754,
      0,
      NULL,
      NULL,
      0.703137,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.626937,
      NULL,
      NULL,
      1.894806,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6.865223,
      1.628907,
      1,
      3.684884,
      0,
      3,
      0,
      14.455575,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.323044,
      NULL,
      NULL,
      0.541136,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.771428,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.209223,
      NULL,
      1,
      1,
      3.546837,
      0.521276,
      1.372597,
      NULL,
      NULL,
      1.513037,
      NULL,
      0.785169,
      0.526325,
      1,
      1.720727,
      1,
      2,
      NULL,
      NULL,
      6.638936,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.489254,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      6,
      0,
      0,
      NULL,
      0,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.004936,
      1.367429,
      0.793586,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0.530310,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.437018,
      NULL,
      NULL,
      3.203703,
      NULL,
      1.591203,
      1.637755,
      3,
      3,
      0,
      0,
      2.137283,
      2,
      NULL,
      1,
      7.411201,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.840225,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.429323,
      NULL,
      NULL,
      1.395863,
      NULL,
      NULL,
      7.378103,
      NULL,
      NULL,
      1.298988,
      NULL,
      NULL,
      1.344825,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.955374,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.190450,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.423836,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.413358,
      1.892903,
      NULL,
      NULL,
      1.503679,
      0.603128,
      NULL,
      NULL,
      2.803714,
      0.745490,
      NULL,
      NULL,
      1.992277,
      0.870022,
      NULL,
      NULL,
      4,
      0,
      NULL,
      NULL,
      1.508267,
      NULL,
      NULL,
      NULL,
      NULL,
      1285,
      977,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      1.457918,
      4627,
      1630,
      1.861515,
      0,
      0.764477,
      0,
      0,
      1,
      NULL,
      0.234557,
      0,
      1,
      0.484302,
      0,
      0.101429,
      2.909514,
      1.608687,
      1.399546,
      1.161187,
      1,
      NULL,
      NULL,
      NULL,
      0.659205,
      NULL,
      1,
      NULL,
      3.056825,
      NULL,
      2,
      NULL,
      532,
      NULL,
      0.600865,
      3.403296,
      NULL,
      1.020609,
      2,
      1.243777,
      NULL,
      2,
      NULL,
      0.074239,
      NULL,
      1.347980,
      NULL,
      1,
      NULL,
      0.399958,
      NULL,
      0.075040,
      NULL,
      3,
      NULL,
      0,
      NULL,
      3,
      NULL,
      0,
      NULL,
      0.618121,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.382712,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      8,
      3.534698,
      0,
      2.603338,
      NULL,
      2,
      0.373097,
      3.703424,
      2.838448,
      0,
      1,
      1.018715,
      0.241166,
      1,
      1.241988,
      1,
      0.943324,
      0.107426,
      1,
      NULL,
      0.844515,
      0,
      0,
      NULL,
      NULL,
      3,
      3.891270,
      0,
      0,
      1,
      0.331473,
      1,
      0.611141,
      1,
      0.155136,
      1.791191,
      1,
      1.806692,
      1,
      1,
      NULL,
      0.297140,
      3,
      2,
      0,
      1,
      2,
      19,
      15,
      NULL,
      0.372856,
      0,
      0.340514,
      1.168802,
      3,
      0.174176,
      0.846871,
      NULL,
      NULL,
      0,
      1,
      1.762177,
      0.962906,
      NULL,
      NULL,
      2.561149,
      3,
      NULL,
      0.026038,
      NULL,
      0,
      75.823981,
      NULL,
      NULL,
      0.846017,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.495407,
      NULL,
      0.675931,
      1.319152,
      0,
      2.590866,
      4,
      5.750204,
      0,
      NULL,
      NULL,
      134.417952,
      NULL,
      NULL,
      1.165364,
      NULL,
      '01032',
      NULL,
      '',
      1,
      '',
      '',
      '',
      0.702458,
      '',
      NULL,
      '');
commit;
end;
/


