set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9684860';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-12-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '30',
      '21',
      5.689133,
      NULL,
      NULL,
      0,
      1,
      2,
      NULL,
      '0113',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-21-1990',
      58,
      3,
      NULL,
      1.699854,
      NULL,
      ' 5-14-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 8- 8-1984',
      NULL,
      ' 2-20-1985',
      3.296715,
      3.814288,
      2,
      2,
      2,
      2.800651,
      NULL,
      0,
      0.016375,
      41,
      9,
      4.762187,
      5.550831,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.467692,
      NULL,
      NULL,
      3.028687,
      NULL,
      NULL,
      1.201016,
      NULL,
      1,
      NULL,
      3,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      0.876175,
      0,
      NULL,
      1.734239,
      0.265963,
      NULL,
      NULL,
      1.404214,
      NULL,
      NULL,
      0,
      NULL,
      1.887597,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      3.044883,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.689221,
      1.733053,
      1.130974,
      1.221552,
      2.285825,
      0,
      5,
      1.838278,
      0.335928,
      1.694285,
      1.701544,
      2.618983,
      0,
      NULL,
      1.037366,
      1,
      1.711186,
      0.805430,
      3.706020,
      0,
      6.713380,
      7,
      1.398699,
      0,
      0,
      NULL,
      7.912557,
      6,
      NULL,
      5,
      9,
      1,
      0,
      3,
      4.651816,
      8,
      5,
      4.033685,
      4,
      4.040050,
      1.036882,
      0.894545,
      4,
      NULL,
      5,
      1,
      1,
      NULL,
      ' 5- 3-1976',
      230.490099,
      ' 4- 1-1974',
      72.576366,
      1.544276,
      1,
      1,
      0,
      0.951393,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.946306,
      NULL,
      0,
      1.872601,
      1.210370,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.368034,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.263847,
      0,
      1.160124,
      0.823755,
      NULL,
      1.828737,
      0.424061,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.018329,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.199245,
      2,
      0,
      1,
      1,
      0.106981,
      NULL,
      2.954598,
      0,
      NULL,
      NULL,
      NULL,
      2.520948,
      0,
      NULL,
      0.213855,
      3.004542,
      1,
      3.339414,
      1.332709,
      1,
      0,
      1,
      2,
      2.554464,
      3.451824,
      3.898298,
      0.068400,
      1.692435,
      0.372988,
      0,
      0.110737,
      1,
      1.461496,
      0.089304,
      NULL,
      0,
      1,
      NULL,
      0,
      1.863832,
      3.093243,
      0.477162,
      0.671050,
      2.146534,
      1,
      5,
      6,
      0,
      4.583434,
      NULL,
      2,
      NULL,
      3,
      0.586393,
      1,
      40.878970,
      NULL,
      0,
      51,
      NULL,
      NULL,
      46.007489,
      2.941181,
      2,
      1.331393,
      '44443',
      '',
      NULL,
      0.198269,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      2,
      12,
      31.473303,
      NULL,
      2,
      NULL,
      NULL,
      1,
      1.780924,
      1.033662,
      NULL,
      1.566319,
      1.561696,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.436549,
      3.623882,
      0,
      2.411807,
      NULL,
      1.229056,
      NULL,
      NULL,
      1.060820,
      3,
      3.168812,
      1.669477,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.712075,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.257453,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.324201,
      1,
      NULL,
      NULL,
      0.260203,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.609327,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.987968,
      NULL,
      NULL,
      0.772718,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      2.157622,
      5.613731,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.859067,
      7,
      4,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.985717,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.239497,
      0,
      2,
      0.650335,
      1,
      NULL,
      NULL,
      0,
      3.382303,
      1.899409,
      NULL,
      NULL,
      7.213579,
      NULL,
      4.885846,
      NULL,
      5,
      5.643005,
      4.367549,
      NULL,
      1.184637,
      NULL,
      2.718353,
      1.434311,
      0,
      2.773686,
      0,
      NULL,
      2,
      0.509873,
      9.379339,
      7.260864,
      5.407655,
      3,
      3,
      1,
      0.500331,
      0.498089,
      0.430831,
      NULL,
      NULL,
      1,
      3.039945,
      NULL,
      0.747581,
      NULL,
      2,
      0,
      NULL,
      1,
      0.630337,
      2.918749,
      3,
      9.288872,
      1,
      0.210025,
      0.346514,
      0.776893,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.307005,
      NULL,
      NULL,
      1.725425,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.748271,
      NULL,
      NULL,
      1.619932,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      1,
      0,
      1.715368,
      0,
      3.380501,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.774398,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.460687,
      NULL,
      NULL,
      NULL,
      0.139744,
      NULL,
      NULL,
      NULL,
      1.318091,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.212421,
      NULL,
      NULL,
      NULL,
      1.717388,
      NULL,
      NULL,
      NULL,
      0.026584,
      NULL,
      NULL,
      NULL,
      1.678967,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.850897,
      2,
      NULL,
      3.776405,
      0,
      7,
      7.307667,
      1,
      9,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.824464,
      NULL,
      1.201938,
      162.297878,
      11,
      0.542371,
      0,
      0.995771,
      0.158575,
      NULL,
      1.537476,
      0.094612,
      1.385690,
      0.472018,
      NULL,
      0.407599,
      NULL,
      0,
      1.194489,
      NULL,
      1.290822,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.406587,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.593842,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.191866,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.940245,
      1.337633,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.768625,
      NULL,
      0.868263,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.324388,
      NULL,
      0.830221,
      0.013326,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.258538,
      0,
      1,
      0,
      3.963874,
      3,
      4.373750,
      1,
      0,
      1.379441,
      1.393078,
      1,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.788692,
      3.108865,
      NULL,
      1.452617,
      0.788917,
      NULL,
      1,
      1.398847,
      NULL,
      0.518902,
      2,
      NULL,
      0.056379,
      2.377533,
      NULL,
      1.898448,
      NULL,
      NULL,
      1,
      0.209561,
      1.957566,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      10.687399,
      NULL,
      3.811366,
      NULL,
      NULL,
      4,
      43,
      NULL,
      3.502751,
      NULL,
      NULL,
      '',
      '',
      0.397364,
      '',
      '',
      '',
      0.689286,
      '',
      '',
      '');
commit;
end;
/


