set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8721162';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-3-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2,
      1.062762,
      1,
      NULL,
      6.925370,
      1.466158,
      3,
      2.766379,
      '212',
      '00430013',
      NULL,
      68,
      '0014414',
      3,
      1.622910,
      NULL,
      3,
      '2242',
      NULL,
      1,
      NULL,
      NULL,
      ' 0-26-1975',
      52,
      9.178387,
      NULL,
      NULL,
      0,
      ' 4-22-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      0.035136,
      '11-26-1984',
      ' 5- 3-1976',
      ' 9-22-1978',
      3.884037,
      1.634756,
      0.522677,
      2,
      1,
      0.177960,
      2,
      1.417847,
      0,
      0,
      7.982012,
      9.673042,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.574028,
      3.699636,
      0,
      NULL,
      NULL,
      1.598507,
      0,
      2,
      1,
      1.191817,
      0,
      3.504725,
      5,
      2,
      2.546346,
      NULL,
      1,
      0.542338,
      1,
      7,
      1,
      7.012142,
      0.417986,
      0,
      1.436112,
      6.361221,
      0.347834,
      5.279569,
      3.369561,
      NULL,
      NULL,
      5,
      1,
      NULL,
      NULL,
      0.007835,
      NULL,
      NULL,
      0.468071,
      3.204917,
      NULL,
      1.327556,
      1.426557,
      1.866987,
      NULL,
      NULL,
      1.920943,
      0,
      1,
      1.249180,
      3.556978,
      0.340191,
      0,
      0,
      1,
      1,
      1,
      0,
      NULL,
      0.053682,
      7.733612,
      NULL,
      2.922169,
      1.479255,
      NULL,
      NULL,
      NULL,
      1.419238,
      NULL,
      NULL,
      0,
      0,
      0,
      0.764372,
      0,
      0,
      2,
      1.732330,
      0,
      0.740996,
      1,
      0,
      NULL,
      3,
      0,
      1.344318,
      1,
      NULL,
      1.041214,
      NULL,
      0,
      0,
      6.984024,
      1.632320,
      7.903809,
      1.557520,
      4.669943,
      4.802165,
      5,
      0.375193,
      7.212219,
      NULL,
      0,
      5.139276,
      NULL,
      6,
      0,
      NULL,
      4.375737,
      NULL,
      6.040293,
      9.883495,
      9,
      NULL,
      0.934578,
      1,
      NULL,
      3.218118,
      ' 7-10-1991',
      111,
      ' 1- 1-1999',
      68,
      NULL,
      3.980489,
      3.508671,
      4.465395,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.644117,
      NULL,
      1,
      NULL,
      1.733972,
      0.489481,
      1.637581,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.773797,
      2,
      4.442432,
      1,
      NULL,
      0.462931,
      3.154410,
      NULL,
      5,
      NULL,
      3,
      NULL,
      NULL,
      2.721937,
      0.810056,
      NULL,
      11.106784,
      6,
      NULL,
      NULL,
      0.480814,
      NULL,
      NULL,
      NULL,
      0.591501,
      6.500265,
      0.922041,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.026166,
      0.429675,
      0,
      0,
      0,
      0.409699,
      0,
      NULL,
      56,
      0,
      1.047316,
      NULL,
      NULL,
      NULL,
      2,
      1.979091,
      0,
      0,
      NULL,
      3,
      0.538505,
      1,
      3.487369,
      3.834144,
      NULL,
      NULL,
      3.875766,
      0,
      2.797749,
      NULL,
      0,
      1.525651,
      1,
      2.841169,
      0.155619,
      1,
      1,
      0,
      0,
      NULL,
      1.807028,
      1,
      0.409097,
      1,
      0.901463,
      NULL,
      10.229623,
      3.711807,
      NULL,
      NULL,
      5,
      1,
      NULL,
      2,
      5,
      NULL,
      1.717698,
      2,
      4,
      2,
      1,
      22.721583,
      NULL,
      21.443666,
      29,
      0.178176,
      1,
      1.853139,
      '24402',
      '42131',
      '',
      3,
      NULL,
      '',
      '',
      1.155699,
      '',
      '',
      '',
      2,
      9,
      55.927362,
      29.243607,
      NULL,
      14,
      NULL,
      2,
      2.839599,
      NULL,
      NULL,
      2,
      0.570631,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3,
      1,
      1.774634,
      NULL,
      NULL,
      1,
      NULL,
      1.236502,
      1,
      NULL,
      NULL,
      0.689135,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.083603,
      2.249160,
      1.591469,
      1.592134,
      NULL,
      NULL,
      9,
      6,
      3.528393,
      NULL,
      0.763703,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.200480,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.463890,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.919325,
      2.635316,
      1,
      NULL,
      0.770510,
      0,
      NULL,
      NULL,
      NULL,
      2.750729,
      3,
      0.074775,
      1,
      0,
      1,
      0.219007,
      NULL,
      NULL,
      4,
      4.635218,
      1,
      0,
      NULL,
      NULL,
      0.718747,
      NULL,
      NULL,
      0.991145,
      NULL,
      NULL,
      0.207777,
      NULL,
      NULL,
      0.424725,
      NULL,
      NULL,
      1.688989,
      NULL,
      NULL,
      1,
      NULL,
      3.359355,
      1.731005,
      NULL,
      3.456345,
      1,
      9.301518,
      4.731293,
      5.529858,
      0.589651,
      1,
      0.618386,
      NULL,
      NULL,
      1.068837,
      2.558850,
      NULL,
      NULL,
      1,
      NULL,
      1.007831,
      2.146546,
      NULL,
      3,
      1.198865,
      5,
      3.304272,
      NULL,
      2,
      3.025678,
      3,
      0.794168,
      NULL,
      2.694947,
      NULL,
      NULL,
      3,
      2,
      3.136090,
      1.940321,
      0.175018,
      2,
      7,
      NULL,
      3.374183,
      1.569415,
      NULL,
      3.548826,
      NULL,
      0.734397,
      1.877574,
      1,
      3,
      NULL,
      NULL,
      0.359741,
      NULL,
      NULL,
      14.141979,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.006910,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.857087,
      NULL,
      NULL,
      2.142714,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.778203,
      NULL,
      NULL,
      NULL,
      0.280371,
      0,
      0,
      NULL,
      NULL,
      1.742080,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.190324,
      NULL,
      NULL,
      NULL,
      0.923942,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.869019,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.204890,
      NULL,
      NULL,
      NULL,
      0.810631,
      NULL,
      NULL,
      NULL,
      0.444935,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.564831,
      NULL,
      NULL,
      NULL,
      1.619042,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      14.913751,
      0.889395,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.871804,
      NULL,
      NULL,
      1.905115,
      NULL,
      NULL,
      1.932661,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      225.128931,
      5,
      1.139478,
      0,
      0.011694,
      1,
      1.550971,
      0,
      0.984832,
      1.894479,
      NULL,
      0,
      1.170397,
      1.231742,
      1,
      1.375638,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      2.773237,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.116501,
      NULL,
      69,
      NULL,
      2.555023,
      NULL,
      24.493202,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.684139,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.478651,
      NULL,
      NULL,
      NULL,
      1.999976,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.777887,
      NULL,
      0.365813,
      NULL,
      1.580553,
      NULL,
      1.044142,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.244508,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.157505,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.740452,
      NULL,
      0,
      NULL,
      0.913279,
      NULL,
      NULL,
      1,
      2.269356,
      NULL,
      NULL,
      NULL,
      128.186245,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.451629,
      NULL,
      0.604573,
      NULL,
      0,
      0.160058,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      2,
      NULL,
      1.694617,
      NULL,
      106.974915,
      NULL,
      3,
      NULL,
      1,
      NULL,
      0,
      NULL,
      3,
      0.063188,
      20.559685,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.370631,
      0,
      NULL,
      4.354368,
      2,
      1,
      1.960064,
      3.957257,
      7,
      3,
      2,
      0,
      1.720736,
      0,
      NULL,
      1,
      1,
      NULL,
      0.289091,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.131867,
      NULL,
      1,
      0,
      NULL,
      1.388541,
      0.926977,
      NULL,
      1.759921,
      NULL,
      NULL,
      1.455732,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.685431,
      0.001545,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.368698,
      NULL,
      4,
      5.325598,
      1,
      0.861352,
      NULL,
      NULL,
      58,
      22,
      4.007580,
      NULL,
      1,
      '40034',
      NULL,
      NULL,
      1,
      '33123',
      '',
      '',
      1.339116,
      '',
      '',
      '');
commit;
end;
/


