set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5112208';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-10-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '2',
      NULL,
      NULL,
      '3003214',
      3,
      NULL,
      1,
      2,
      '0201',
      1.045567,
      1,
      NULL,
      NULL,
      NULL,
      23.689129,
      NULL,
      2.385212,
      2.215439,
      1.385530,
      ' 5- 1-1990',
      49,
      NULL,
      62,
      117,
      0.584631,
      ' 1- 6-2002',
      ' 3- 1-2002',
      ' 3- 7-1975',
      1,
      3,
      2,
      NULL,
      NULL,
      0,
      1.457003,
      1,
      1.371877,
      NULL,
      7.429475,
      18.170436,
      5,
      28,
      30.669792,
      NULL,
      24,
      0.256532,
      1.658345,
      6,
      1,
      0.978918,
      0,
      0.260115,
      2.723071,
      0.950955,
      0.839460,
      1.674728,
      NULL,
      0,
      1,
      2,
      NULL,
      1.646852,
      2.965797,
      7.105868,
      NULL,
      3.209591,
      6,
      0.333311,
      3.852094,
      1.732814,
      1,
      0,
      1,
      1,
      0.421104,
      5.065962,
      0.607871,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.691964,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.771765,
      0.704753,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.040484,
      0,
      1.525221,
      0,
      0.313929,
      0,
      1.152332,
      1.494913,
      NULL,
      4.726111,
      NULL,
      NULL,
      1,
      2.911050,
      NULL,
      1.025451,
      0,
      1.829363,
      NULL,
      NULL,
      NULL,
      0.814742,
      1.624294,
      0,
      0,
      NULL,
      1,
      1.972011,
      NULL,
      0,
      0.287857,
      1.692809,
      0.408971,
      5,
      NULL,
      1.204223,
      0,
      1.729008,
      1.620687,
      0,
      1.862392,
      0,
      3.682721,
      5.575861,
      NULL,
      NULL,
      1.567547,
      0.445825,
      NULL,
      41,
      '11-12-1993',
      69.796088,
      1.895936,
      3,
      0.271000,
      1,
      1.258929,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      38.652109,
      NULL,
      0.156543,
      1.186824,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.682355,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4.552358,
      5.871997,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.769484,
      NULL,
      0,
      0.020994,
      0.813858,
      1.709136,
      0,
      3,
      282.910938,
      0,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.979046,
      2.395652,
      NULL,
      2,
      NULL,
      0,
      1,
      3,
      3,
      3,
      0.920968,
      2,
      3.977368,
      NULL,
      0.558584,
      0,
      0,
      NULL,
      0.385469,
      NULL,
      NULL,
      1.462578,
      0,
      2,
      0.384610,
      0,
      2.584813,
      1,
      4,
      NULL,
      4.866152,
      5,
      6,
      3.346275,
      4.646830,
      NULL,
      1.730679,
      1.528586,
      7,
      2,
      NULL,
      1,
      23,
      0.188560,
      1.161082,
      NULL,
      32,
      49,
      57,
      3,
      1.283876,
      0,
      '32144',
      NULL,
      '',
      0.517724,
      '13322',
      '',
      '',
      3.323831,
      '04022',
      NULL,
      '',
      1.722214,
      NULL,
      466,
      17.495595,
      1.793964,
      50.789371,
      5,
      5.897577,
      2,
      0,
      1,
      2.913068,
      3,
      0,
      0.674261,
      1,
      0.005073,
      0.578773,
      3,
      1.390842,
      NULL,
      0,
      NULL,
      NULL,
      2.830601,
      3,
      2.734974,
      NULL,
      NULL,
      3,
      1.839684,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.474797,
      NULL,
      NULL,
      NULL,
      0,
      2.830333,
      1,
      1.980781,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.975495,
      NULL,
      NULL,
      2.106301,
      NULL,
      1.586819,
      1.074037,
      0,
      0,
      1,
      1.476821,
      0,
      1,
      1.407781,
      1,
      1,
      0,
      1,
      NULL,
      1.892881,
      1.080621,
      1,
      1,
      NULL,
      NULL,
      2,
      1.429600,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.568618,
      NULL,
      NULL,
      NULL,
      NULL,
      2.462856,
      0.555271,
      1.314920,
      1.283489,
      NULL,
      NULL,
      1.170887,
      1,
      0.592988,
      0,
      NULL,
      NULL,
      1.186596,
      NULL,
      NULL,
      NULL,
      0.325856,
      NULL,
      0.635186,
      0,
      1,
      1.608223,
      NULL,
      NULL,
      0,
      1,
      1.966254,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.483433,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2,
      0,
      3.953467,
      0.746708,
      1,
      NULL,
      NULL,
      NULL,
      1.153161,
      3.734258,
      1,
      1.558623,
      NULL,
      0,
      4,
      8.898082,
      1,
      0.560336,
      NULL,
      0.522394,
      3.586332,
      NULL,
      1.228634,
      1,
      2.889186,
      1.924010,
      NULL,
      1.903533,
      3,
      7.514920,
      NULL,
      4,
      4.678582,
      1.024420,
      0,
      3.232627,
      1.600524,
      2,
      0,
      1,
      0,
      0,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.142451,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.205287,
      NULL,
      NULL,
      1.383792,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.368125,
      NULL,
      2.339649,
      NULL,
      0.750603,
      NULL,
      2.422625,
      NULL,
      NULL,
      1.935280,
      7,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.093859,
      NULL,
      NULL,
      NULL,
      1.204353,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.352408,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.125307,
      1,
      NULL,
      NULL,
      2.905852,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.340755,
      0,
      NULL,
      NULL,
      0,
      1.667135,
      NULL,
      NULL,
      0.049854,
      5,
      NULL,
      NULL,
      0,
      3.279649,
      NULL,
      1.499245,
      NULL,
      NULL,
      NULL,
      NULL,
      14,
      6,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.517988,
      NULL,
      1.729720,
      3.863176,
      NULL,
      2,
      1.958087,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      462,
      NULL,
      NULL,
      NULL,
      0.434925,
      0.872121,
      0.482812,
      1.335002,
      0.462856,
      1,
      0,
      0.499645,
      NULL,
      0,
      0,
      0,
      1,
      0.370603,
      NULL,
      1.663941,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.342738,
      1.478968,
      2,
      2,
      1,
      1.765472,
      2,
      0.914924,
      1,
      2.695096,
      0.321277,
      2,
      2.718343,
      1.295466,
      0,
      0,
      0,
      1.726385,
      1.983339,
      0.466256,
      1.854728,
      1.651703,
      NULL,
      0.342720,
      0.150049,
      0.895254,
      1,
      1,
      0,
      1,
      NULL,
      1,
      1.856941,
      0.286602,
      0.389691,
      0.198925,
      1.380761,
      NULL,
      1.212466,
      1.094219,
      NULL,
      1,
      1,
      1.047058,
      0.997380,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.093990,
      NULL,
      0,
      NULL,
      3.486381,
      2,
      2,
      1,
      2,
      2.234837,
      0.084513,
      1,
      1.282220,
      0.665366,
      0.313250,
      0.973481,
      1.721720,
      3.737581,
      0,
      1,
      NULL,
      NULL,
      3.994590,
      0.255319,
      NULL,
      25,
      0.877755,
      2.405815,
      1.445618,
      0,
      0.669147,
      0,
      1,
      1,
      4,
      5,
      6.679760,
      0,
      NULL,
      NULL,
      0.360709,
      55,
      2,
      NULL,
      1,
      NULL,
      '',
      '',
      0,
      '10321',
      '',
      '',
      3.238509,
      '11331',
      '',
      '');
commit;
end;
/


