set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8929470';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-12-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '4',
      NULL,
      NULL,
      '0432242',
      1,
      0,
      0,
      2,
      '1333',
      NULL,
      0.908825,
      NULL,
      NULL,
      ' 0-23-1991',
      54.607438,
      NULL,
      3.927843,
      1,
      1.967585,
      ' 8-24-1992',
      60.018377,
      2.059924,
      NULL,
      102,
      NULL,
      NULL,
      NULL,
      '10-21-1986',
      2,
      1.948642,
      0.406432,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.956692,
      NULL,
      9.873071,
      NULL,
      1,
      27,
      NULL,
      NULL,
      2,
      1,
      0,
      1,
      1.390790,
      NULL,
      0,
      1.911890,
      1.627292,
      0,
      1.484605,
      1,
      0.695882,
      4.543590,
      NULL,
      NULL,
      6,
      0,
      1,
      0.724612,
      1.107721,
      0,
      1.814596,
      NULL,
      1,
      0,
      2,
      2.251500,
      8,
      1.913073,
      4.862191,
      NULL,
      NULL,
      0.875797,
      NULL,
      NULL,
      1.367837,
      NULL,
      NULL,
      9.781833,
      NULL,
      1.471254,
      3,
      1,
      1,
      1.525248,
      1.017566,
      0,
      3.241786,
      NULL,
      0.158719,
      NULL,
      1,
      NULL,
      3,
      1.555595,
      2,
      3,
      1,
      0.561684,
      NULL,
      1.037454,
      1,
      NULL,
      3.389172,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.991544,
      1,
      5.671967,
      1.056981,
      2,
      4,
      0.864738,
      1,
      0.474761,
      0.061828,
      1,
      0,
      0.092426,
      3,
      1,
      1.742089,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      2.464044,
      0,
      0.121856,
      0.215114,
      2,
      NULL,
      0.162787,
      0,
      3.329414,
      NULL,
      0.788074,
      1,
      NULL,
      3,
      NULL,
      NULL,
      1.663858,
      1.156241,
      1.333798,
      0.974452,
      5,
      1.129982,
      NULL,
      2.553929,
      NULL,
      NULL,
      ' 0-21-2002',
      2.379156,
      NULL,
      NULL,
      NULL,
      1.532962,
      1.703754,
      1,
      1.029430,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.513468,
      NULL,
      0.090425,
      NULL,
      NULL,
      1,
      1.034017,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.331449,
      1,
      NULL,
      NULL,
      2.521594,
      1.675339,
      9.740220,
      1.770627,
      3.393638,
      2,
      2,
      3,
      0.087431,
      0,
      NULL,
      0.907929,
      NULL,
      5,
      1.112636,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0.613072,
      NULL,
      NULL,
      NULL,
      NULL,
      2.774668,
      12.577482,
      2.620675,
      1.561062,
      NULL,
      NULL,
      NULL,
      NULL,
      1.414225,
      3.885033,
      NULL,
      3.106307,
      1.863261,
      0,
      1.072261,
      2.006174,
      1,
      3,
      1.860927,
      2,
      NULL,
      NULL,
      3,
      NULL,
      1,
      1.322397,
      0,
      0.989143,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      1.072404,
      0,
      1,
      1,
      0,
      0.472881,
      NULL,
      3,
      9.281151,
      1.035000,
      3,
      3.450095,
      NULL,
      4.986944,
      3.158386,
      0.715902,
      1,
      65,
      0.419351,
      NULL,
      NULL,
      30,
      NULL,
      24.286898,
      4.768724,
      0,
      2.866835,
      '40234',
      '',
      '',
      0.230183,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      3.321928,
      20,
      143,
      38,
      2.301313,
      33.047788,
      4.305044,
      NULL,
      NULL,
      0,
      0,
      2.678090,
      0.347001,
      NULL,
      NULL,
      1.095306,
      NULL,
      NULL,
      1.391230,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.758059,
      NULL,
      0.021665,
      1,
      1.966107,
      0.710723,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      1.872054,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4.270471,
      NULL,
      NULL,
      1.208284,
      0.538813,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.728630,
      1.171399,
      2,
      NULL,
      0,
      NULL,
      NULL,
      0.901482,
      NULL,
      0,
      NULL,
      NULL,
      1.760962,
      1.394456,
      3,
      0,
      NULL,
      0,
      0.236319,
      NULL,
      0.675356,
      0,
      0,
      2,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      10,
      7,
      3,
      0.333888,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      2.015712,
      0,
      3.759005,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.316831,
      1.763212,
      3,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.608038,
      NULL,
      NULL,
      NULL,
      0.138036,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.658430,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.620990,
      1.597561,
      5,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.800525,
      1.427497,
      1,
      3.279783,
      NULL,
      0,
      0.239414,
      1,
      5.672946,
      3.977115,
      4.765660,
      3,
      NULL,
      1.203329,
      3,
      0.188306,
      1,
      NULL,
      3,
      1,
      NULL,
      1,
      NULL,
      NULL,
      6,
      7,
      4,
      6,
      NULL,
      2.248754,
      NULL,
      5.715064,
      0,
      1,
      1.707331,
      NULL,
      1.961512,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.758434,
      NULL,
      NULL,
      0.509873,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.098497,
      1.578456,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.414176,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2.651851,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.765288,
      0.560013,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1.007914,
      3.030464,
      NULL,
      NULL,
      2.214243,
      0.486676,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      2,
      1.578689,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      12,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.114023,
      70,
      NULL,
      1.492830,
      1,
      NULL,
      0.510309,
      NULL,
      NULL,
      0.251728,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.757024,
      NULL,
      NULL,
      644,
      NULL,
      1,
      0,
      1,
      0,
      1,
      NULL,
      1.518659,
      0.672902,
      1,
      0.374524,
      NULL,
      1.146175,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.064635,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.835698,
      NULL,
      1,
      NULL,
      1,
      1,
      0.774707,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.020425,
      NULL,
      1.452291,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.762538,
      NULL,
      1.512817,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.558046,
      0.041475,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.394821,
      0.814108,
      0.128391,
      NULL,
      1.156072,
      2,
      NULL,
      2,
      NULL,
      NULL,
      2.059180,
      2.828590,
      1,
      0.381419,
      1.244229,
      1,
      0,
      0,
      0,
      3,
      2.653717,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.357302,
      NULL,
      0.558524,
      NULL,
      1,
      2.793036,
      1,
      NULL,
      0,
      0.235231,
      NULL,
      1.228266,
      1.032045,
      2,
      1,
      1,
      NULL,
      2.970570,
      0.642833,
      NULL,
      0.992424,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      0,
      4,
      2.631191,
      NULL,
      0.368678,
      0,
      0.598621,
      56.766619,
      128.538475,
      0.715458,
      1.665565,
      0,
      '13422',
      '',
      '',
      0.173392,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


