set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6404872';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-8-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '0',
      NULL,
      NULL,
      '2243310',
      NULL,
      1,
      3,
      3,
      '4033',
      2.373785,
      NULL,
      NULL,
      NULL,
      NULL,
      58,
      NULL,
      0,
      2,
      NULL,
      NULL,
      28,
      3.787856,
      75,
      88.597197,
      3,
      '11-19-1976',
      NULL,
      ' 5-23-1995',
      NULL,
      NULL,
      0,
      1,
      0,
      1.800252,
      6.523449,
      3.836223,
      NULL,
      NULL,
      NULL,
      1.348133,
      0,
      17.364589,
      3.888215,
      6,
      1,
      3.984257,
      3.503898,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.279723,
      1,
      11.651486,
      0,
      0,
      NULL,
      NULL,
      1.875447,
      1.885625,
      0.710085,
      4.492095,
      1,
      3.682103,
      1,
      0.518983,
      0,
      2.691099,
      NULL,
      3.734148,
      1.747410,
      NULL,
      0.113571,
      NULL,
      NULL,
      2,
      3,
      3.575047,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.608912,
      1.069150,
      1.370792,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.143783,
      1.613349,
      4,
      NULL,
      0.616417,
      0,
      NULL,
      1.622553,
      0.764248,
      NULL,
      NULL,
      0.674283,
      0,
      2.488621,
      NULL,
      0,
      NULL,
      0.965575,
      0.960858,
      NULL,
      1.115740,
      0.855062,
      0,
      NULL,
      NULL,
      5,
      3,
      2,
      4,
      7,
      1,
      0.183876,
      4,
      NULL,
      1.511192,
      0,
      NULL,
      2.111752,
      1,
      0.842334,
      1,
      5.034223,
      6.128237,
      5.944488,
      2.126085,
      1.251022,
      1.422024,
      2,
      '10-11-1984',
      1146,
      ' 5- 0-1985',
      741.583713,
      NULL,
      NULL,
      1.079585,
      5,
      1.745550,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.008378,
      0,
      NULL,
      0,
      1,
      1.463403,
      1,
      1.107991,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      209.824012,
      0,
      0,
      NULL,
      0.487043,
      NULL,
      0.636717,
      3.658510,
      NULL,
      4,
      1,
      2.380152,
      3,
      1,
      1.515888,
      7,
      1,
      NULL,
      2.686245,
      4,
      1.779676,
      8.371961,
      1.263349,
      NULL,
      NULL,
      1.869714,
      NULL,
      0,
      1,
      8,
      7,
      1.684366,
      ' 2-18-1999',
      NULL,
      '10-27-1982',
      192.485917,
      NULL,
      0,
      0,
      NULL,
      2.573088,
      1.129635,
      1.407456,
      0,
      0,
      NULL,
      NULL,
      35,
      2,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      2.422381,
      2.346226,
      NULL,
      1.970486,
      3,
      0,
      2,
      0,
      2,
      1.746219,
      NULL,
      NULL,
      3.640843,
      1.533311,
      0,
      1,
      NULL,
      1.043112,
      1,
      3.467877,
      0.535942,
      1,
      1.853048,
      1,
      0,
      1,
      1,
      0,
      0,
      8.904596,
      5,
      3.647597,
      11.013154,
      11.219284,
      4.074778,
      4,
      1.826837,
      5.549214,
      2,
      1,
      3.655084,
      43,
      0.549088,
      1.479902,
      NULL,
      12,
      68,
      62.490587,
      2.232414,
      NULL,
      1,
      '44233',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      6.126119,
      57,
      11.268152,
      3.895283,
      0.124537,
      10,
      25.789275,
      NULL,
      1.604640,
      1,
      0,
      0.884722,
      NULL,
      1.285859,
      3.139669,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.187628,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.366544,
      NULL,
      NULL,
      0.753383,
      NULL,
      NULL,
      0.283239,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.433358,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      2,
      2.536764,
      NULL,
      1,
      NULL,
      NULL,
      0.610415,
      NULL,
      NULL,
      0.011778,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      NULL,
      NULL,
      NULL,
      0.700720,
      NULL,
      NULL,
      0.153638,
      NULL,
      6,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.304027,
      0.523035,
      NULL,
      2,
      0,
      NULL,
      NULL,
      1.952353,
      0.232672,
      1,
      1.085976,
      2,
      3,
      3.181648,
      3.670622,
      3.561421,
      8.804831,
      0,
      0,
      1,
      1,
      NULL,
      0.082360,
      NULL,
      NULL,
      4,
      1.069630,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.855379,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.566143,
      NULL,
      NULL,
      2,
      0.665569,
      2.020787,
      0,
      NULL,
      NULL,
      1.924174,
      5.375572,
      1.663315,
      3.569491,
      6,
      7,
      0,
      NULL,
      NULL,
      NULL,
      1.870391,
      1,
      0,
      NULL,
      1.757336,
      0.294468,
      0.981855,
      3,
      NULL,
      NULL,
      1.486126,
      0.588442,
      NULL,
      0.275910,
      1.869274,
      1,
      3.177209,
      0,
      NULL,
      2.600751,
      3,
      1.103766,
      2.699827,
      6,
      5.198492,
      NULL,
      1.638317,
      NULL,
      NULL,
      2,
      5,
      1.821806,
      0.000409,
      1,
      0.822587,
      NULL,
      0.700658,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.598281,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.878083,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0,
      0.230239,
      2,
      0.307206,
      NULL,
      9.458617,
      0.716259,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.815126,
      NULL,
      NULL,
      NULL,
      0.077693,
      0.195906,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.427498,
      3.633159,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.672732,
      0.828749,
      NULL,
      NULL,
      1.093099,
      NULL,
      NULL,
      NULL,
      0.093690,
      1,
      NULL,
      NULL,
      NULL,
      0.602260,
      NULL,
      NULL,
      1.515615,
      0.328055,
      NULL,
      NULL,
      2.763978,
      2.531755,
      NULL,
      NULL,
      3.074755,
      1,
      NULL,
      NULL,
      2.594025,
      0,
      NULL,
      NULL,
      NULL,
      1.731104,
      NULL,
      NULL,
      1,
      1.632888,
      NULL,
      NULL,
      4.647095,
      NULL,
      NULL,
      NULL,
      6,
      0,
      NULL,
      NULL,
      NULL,
      0.119153,
      NULL,
      13,
      NULL,
      586,
      295.961842,
      1.341408,
      NULL,
      NULL,
      0.254626,
      NULL,
      NULL,
      0.838573,
      NULL,
      NULL,
      1.638510,
      NULL,
      NULL,
      1.447853,
      0,
      NULL,
      222,
      29,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.483407,
      1,
      0,
      0,
      0.341244,
      0.615363,
      1.826270,
      1.533069,
      1,
      0,
      0,
      1.423410,
      1.053396,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.406173,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.078378,
      3,
      1,
      1,
      3.932100,
      1,
      NULL,
      0.803084,
      6.483605,
      1.898839,
      1,
      NULL,
      0,
      1,
      NULL,
      1.738140,
      0.501703,
      NULL,
      1.360599,
      0,
      NULL,
      0.063830,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.337652,
      NULL,
      NULL,
      1.955272,
      0.828047,
      NULL,
      NULL,
      2.014768,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.245482,
      NULL,
      0.816953,
      1,
      NULL,
      1.842882,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      8.474465,
      0.241873,
      3,
      0,
      1.432228,
      3,
      76.947678,
      NULL,
      NULL,
      0,
      1,
      '31323',
      '',
      NULL,
      1.409385,
      '',
      NULL,
      '',
      1,
      NULL,
      NULL,
      '');
commit;
end;
/


