set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '3374023';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-2-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0.853790,
      4.776277,
      0,
      1,
      1.299991,
      0,
      3,
      0.948700,
      NULL,
      '24344330',
      31,
      67.158895,
      NULL,
      1,
      1.650533,
      3,
      2,
      '1420',
      3.411794,
      1,
      NULL,
      NULL,
      ' 1-19-1999',
      38,
      NULL,
      NULL,
      1,
      2,
      '11- 4-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      5.185882,
      NULL,
      NULL,
      ' 0-10-2002',
      3,
      1,
      0.878932,
      3.721413,
      1.248016,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      10,
      5.192551,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.066814,
      NULL,
      NULL,
      0.405985,
      1,
      0.926635,
      1,
      NULL,
      0,
      1,
      1.726746,
      1.302217,
      0.834482,
      7,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.590933,
      0,
      1,
      1,
      1,
      NULL,
      0.279886,
      0,
      0.155980,
      0,
      3.367032,
      1,
      1,
      1,
      0,
      0.860629,
      NULL,
      NULL,
      0,
      5.063972,
      0.346471,
      5.423627,
      0.253582,
      2,
      0,
      0,
      3,
      1.588477,
      NULL,
      3,
      2.799198,
      3,
      1.842697,
      1,
      2.818088,
      NULL,
      1.259351,
      2,
      NULL,
      1,
      1,
      0,
      1,
      4.807940,
      1,
      1,
      0.705730,
      0,
      NULL,
      NULL,
      NULL,
      5,
      2.127256,
      1.208652,
      1,
      0.951971,
      2,
      2.853520,
      0,
      1,
      NULL,
      1.366052,
      1,
      NULL,
      0,
      0.099203,
      0,
      0,
      1,
      0,
      1.484170,
      0.613161,
      NULL,
      1,
      NULL,
      1,
      1,
      1.918978,
      1.210722,
      1.017176,
      3.928884,
      0,
      NULL,
      0.378253,
      1.624851,
      1,
      1.448597,
      0,
      1.989786,
      5,
      1.403133,
      3.707681,
      0.224577,
      3,
      6,
      4.902743,
      1.697782,
      5,
      7.671901,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.912224,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.360850,
      NULL,
      0,
      0,
      1.002956,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      0,
      1.882603,
      0.201718,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.512362,
      1.555547,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      5.240519,
      2.077643,
      7.117932,
      4.432683,
      4,
      1.060724,
      NULL,
      NULL,
      0.511047,
      7,
      2,
      0,
      7.758533,
      2.970499,
      5,
      ' 6- 1-1996',
      NULL,
      '10-18-1990',
      122,
      3,
      3.713799,
      0.901496,
      NULL,
      NULL,
      NULL,
      NULL,
      0.251766,
      NULL,
      0.871975,
      0,
      NULL,
      3.398412,
      0.502844,
      NULL,
      NULL,
      NULL,
      NULL,
      1.263126,
      NULL,
      0,
      3,
      3.465713,
      NULL,
      2,
      0,
      2.446792,
      3.781293,
      1.398269,
      1.957813,
      0.547407,
      3,
      1,
      1,
      NULL,
      0.944124,
      1,
      0.514723,
      1,
      1,
      1.788846,
      0,
      NULL,
      1.866708,
      1,
      0.294981,
      1.046236,
      NULL,
      NULL,
      3.828248,
      4,
      3.939380,
      9,
      9,
      NULL,
      NULL,
      3.632289,
      1.762594,
      0,
      2.861295,
      2,
      42,
      2,
      0.549007,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      '42311',
      '02340',
      '14313',
      1.914162,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      3,
      NULL,
      7,
      20.959856,
      1.124737,
      19,
      2,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      0.891516,
      NULL,
      NULL,
      0.250077,
      1.192187,
      0.462480,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1.874344,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.863701,
      NULL,
      NULL,
      1.537649,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.063823,
      NULL,
      NULL,
      0.612018,
      NULL,
      NULL,
      1.008317,
      NULL,
      NULL,
      1,
      0.816674,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.933666,
      NULL,
      NULL,
      NULL,
      0,
      2,
      3.170666,
      3,
      3.556047,
      0,
      1.297996,
      1,
      NULL,
      2.144126,
      0.837293,
      1.676168,
      NULL,
      0,
      0.911616,
      3.778486,
      NULL,
      0,
      0.116599,
      NULL,
      NULL,
      NULL,
      2.522374,
      0.494330,
      1,
      1.528157,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1.708199,
      0.296711,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.948486,
      3.115977,
      NULL,
      5.137765,
      5.276886,
      NULL,
      1,
      NULL,
      NULL,
      0.847759,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.491610,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.177463,
      NULL,
      NULL,
      0.937810,
      NULL,
      NULL,
      1.345413,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5,
      5,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.117991,
      3,
      3,
      3.861273,
      NULL,
      0,
      5,
      NULL,
      1,
      1,
      2,
      NULL,
      1.757274,
      NULL,
      1.972801,
      0,
      0,
      2,
      2.997083,
      1.428304,
      0,
      6.345515,
      2,
      5,
      NULL,
      NULL,
      4,
      1,
      NULL,
      NULL,
      0.561622,
      1,
      0,
      1,
      0.297763,
      1.258281,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.279790,
      3,
      0,
      0.721860,
      0.117958,
      1,
      NULL,
      NULL,
      NULL,
      49,
      NULL,
      NULL,
      NULL,
      3.194068,
      NULL,
      NULL,
      NULL,
      1.920030,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.916678,
      NULL,
      NULL,
      NULL,
      0.908727,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.456042,
      NULL,
      NULL,
      NULL,
      0.342345,
      NULL,
      NULL,
      NULL,
      2.461795,
      NULL,
      NULL,
      NULL,
      3.196427,
      NULL,
      NULL,
      NULL,
      3.428422,
      NULL,
      NULL,
      NULL,
      3.948947,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      6.840362,
      NULL,
      0.067848,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.432359,
      0.959223,
      NULL,
      NULL,
      1,
      NULL,
      0.356822,
      1,
      1,
      1,
      0.414513,
      1,
      0,
      NULL,
      0.517964,
      NULL,
      1.237320,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.011472,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      9.504949,
      4.828685,
      0,
      2,
      1.695407,
      9.271779,
      1,
      2,
      0,
      0.687135,
      1,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.393683,
      NULL,
      2,
      3.992364,
      NULL,
      NULL,
      1.033357,
      NULL,
      1.618819,
      1.779860,
      NULL,
      NULL,
      0.397756,
      NULL,
      1.518219,
      0.556339,
      NULL,
      1.150442,
      1.175717,
      NULL,
      0.253508,
      0.271760,
      NULL,
      NULL,
      0.171621,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.604892,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.896583,
      NULL,
      2.256125,
      NULL,
      4,
      0,
      NULL,
      NULL,
      12.447598,
      12,
      1,
      3.522629,
      NULL,
      '04422',
      '01014',
      '30401',
      1.646021,
      '',
      '',
      '',
      1.927372,
      '',
      '',
      NULL);
commit;
end;
/


