set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9657548';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-5-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '02',
      '14',
      6.122057,
      10,
      '2422003',
      1.155483,
      1.362253,
      NULL,
      NULL,
      '2341',
      1.957145,
      0.980575,
      NULL,
      NULL,
      NULL,
      33,
      4,
      NULL,
      0,
      1,
      ' 8-21-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      1.172822,
      NULL,
      ' 2-19-1997',
      ' 0-27-1982',
      3.243322,
      3,
      3,
      NULL,
      NULL,
      NULL,
      2.884251,
      3.899370,
      NULL,
      NULL,
      NULL,
      9.358484,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      0.241333,
      0.523164,
      NULL,
      2.835321,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.048065,
      NULL,
      0,
      3.193896,
      0,
      1.410027,
      6,
      5.518309,
      2,
      NULL,
      NULL,
      0.670592,
      NULL,
      1,
      0.823119,
      6.403425,
      NULL,
      3,
      NULL,
      0,
      NULL,
      1.189091,
      NULL,
      1.558219,
      NULL,
      NULL,
      4,
      0.525186,
      0,
      1.483108,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.750505,
      6,
      1,
      7.555667,
      NULL,
      NULL,
      NULL,
      3.023661,
      0,
      2.992605,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.572193,
      NULL,
      NULL,
      10.266147,
      5.496409,
      0,
      NULL,
      1,
      4,
      2.510972,
      NULL,
      5,
      NULL,
      0.462752,
      1.043227,
      1.873188,
      1.685961,
      NULL,
      1.587523,
      0.691036,
      1.798620,
      NULL,
      1,
      1,
      1,
      4.213820,
      1,
      1,
      1,
      0,
      1,
      4,
      5.882273,
      1.612284,
      7.099222,
      1,
      NULL,
      0,
      NULL,
      0,
      7.433755,
      0.085115,
      6,
      5.489686,
      0,
      2.964004,
      '10-18-1987',
      NULL,
      ' 6-17-1990',
      5,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      9.202422,
      1.752976,
      NULL,
      1.810615,
      3,
      1,
      4,
      2,
      4,
      3,
      3,
      NULL,
      1.205175,
      NULL,
      1.155726,
      '10- 1-1984',
      8.402979,
      ' 0-11-1990',
      2.542380,
      1.858231,
      1,
      0.142966,
      2.533186,
      NULL,
      NULL,
      NULL,
      NULL,
      0.270573,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.062096,
      0.934779,
      1,
      0.800250,
      2.417190,
      1.376921,
      0.660480,
      1.061675,
      NULL,
      0,
      0,
      0.803796,
      1,
      NULL,
      NULL,
      NULL,
      0.558662,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.971506,
      2.165189,
      1.968574,
      0.523354,
      1,
      NULL,
      0.335349,
      3.441286,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.654005,
      1,
      2,
      3,
      1,
      NULL,
      0.792666,
      2,
      2,
      2.896506,
      1.933919,
      3.839754,
      3,
      NULL,
      1,
      3,
      1.178021,
      NULL,
      0.791661,
      0.801474,
      NULL,
      0.838466,
      1.130058,
      1,
      0,
      0.571402,
      NULL,
      0,
      NULL,
      5.589372,
      1.914062,
      5,
      11.947746,
      NULL,
      6,
      10,
      2.717310,
      NULL,
      2,
      4.822567,
      3.637244,
      NULL,
      2,
      33,
      3,
      2.236358,
      15,
      NULL,
      25,
      NULL,
      4.004265,
      5,
      1,
      '40312',
      '',
      NULL,
      0.297810,
      '',
      '',
      '',
      1.264743,
      '',
      '',
      '',
      2,
      11.421297,
      NULL,
      8,
      NULL,
      30,
      3,
      7.072153,
      1,
      NULL,
      3.097553,
      3,
      0,
      NULL,
      NULL,
      3,
      NULL,
      0,
      2,
      1.527360,
      3.609397,
      3,
      0.473232,
      NULL,
      NULL,
      2.493388,
      1,
      1,
      2,
      3,
      0.579851,
      3,
      1.133933,
      1.937396,
      2,
      0.760450,
      0.531471,
      1.239706,
      0,
      1.439052,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.693108,
      3.062235,
      4.107385,
      0,
      1.442958,
      0.504772,
      3,
      3.188548,
      0.529044,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.218510,
      1.307592,
      NULL,
      NULL,
      1.721498,
      NULL,
      NULL,
      2.430831,
      3.990396,
      NULL,
      NULL,
      1.783907,
      0,
      1,
      1.394947,
      1.422855,
      1.678084,
      0.020189,
      0.228429,
      0,
      2,
      1,
      3.473103,
      2.372845,
      1,
      2,
      3,
      NULL,
      0,
      3,
      3,
      0,
      5,
      NULL,
      1.603401,
      0.993645,
      2,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.986240,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      2.677612,
      NULL,
      2.789493,
      0.191428,
      0,
      0.330461,
      NULL,
      NULL,
      0.910526,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.779182,
      NULL,
      NULL,
      1.982545,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.842486,
      NULL,
      NULL,
      2,
      2.229659,
      3.033453,
      1,
      NULL,
      2,
      0.204570,
      NULL,
      NULL,
      2,
      2.970551,
      2,
      0,
      1.670696,
      1.115862,
      3.949044,
      3,
      2.524184,
      3,
      3.048706,
      0,
      0.529453,
      0.376191,
      2.420593,
      7,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.108483,
      0,
      2.199357,
      1,
      1,
      3.317689,
      0.261696,
      NULL,
      2.378648,
      3,
      NULL,
      NULL,
      46,
      NULL,
      3,
      1.143079,
      NULL,
      2,
      3,
      NULL,
      1.883637,
      0,
      NULL,
      2,
      1.555201,
      NULL,
      1.848316,
      1.456826,
      NULL,
      1.730422,
      NULL,
      NULL,
      0,
      1.139021,
      NULL,
      3.720296,
      1.655449,
      NULL,
      0.878995,
      NULL,
      NULL,
      3.398367,
      0.693894,
      NULL,
      1,
      2,
      NULL,
      11,
      0.878793,
      NULL,
      2,
      1.935956,
      1,
      0,
      0.418670,
      0.033708,
      1.249630,
      0,
      NULL,
      NULL,
      0.343747,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.089081,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.698802,
      0,
      NULL,
      NULL,
      2.961181,
      0.879352,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      0.639566,
      1.850082,
      NULL,
      NULL,
      0,
      1.474687,
      NULL,
      NULL,
      1.363293,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.849322,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.946907,
      NULL,
      NULL,
      1,
      1.888701,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.644358,
      NULL,
      0,
      0,
      0,
      0,
      0.165910,
      NULL,
      NULL,
      2,
      0.013879,
      1.420044,
      1.344724,
      NULL,
      4.606559,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1741.817092,
      50,
      0,
      NULL,
      1,
      NULL,
      0,
      0.347041,
      NULL,
      NULL,
      NULL,
      1.763919,
      1,
      1.964550,
      0.295661,
      0.142652,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.810542,
      0.476116,
      1.085804,
      0.647202,
      1,
      1.753936,
      1,
      0,
      0.922123,
      0.362064,
      NULL,
      1.813623,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.523372,
      1.944347,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.258672,
      NULL,
      0,
      NULL,
      1.104117,
      0,
      2,
      NULL,
      0.752018,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.024412,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      0.025687,
      1.267476,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.650885,
      2.070304,
      NULL,
      0.956010,
      NULL,
      0.981922,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      3,
      NULL,
      1.321054,
      1,
      NULL,
      NULL,
      2,
      0.121593,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.641585,
      1.505017,
      0.385090,
      0.721856,
      1,
      3.738611,
      NULL,
      1,
      NULL,
      1,
      2.702199,
      3.170269,
      1,
      1.645219,
      NULL,
      1,
      0.618028,
      3,
      0.258880,
      NULL,
      3.443463,
      0,
      0.473186,
      2,
      0.514134,
      1,
      0,
      1,
      3,
      3,
      1,
      0,
      2.206851,
      1.887227,
      0,
      0,
      0.136630,
      2,
      1.076648,
      NULL,
      0.207100,
      3,
      NULL,
      0.432692,
      NULL,
      NULL,
      0.995457,
      0,
      0,
      NULL,
      0.632562,
      NULL,
      NULL,
      3,
      3.530576,
      3.352712,
      1.937420,
      1.816748,
      1.749465,
      0.759639,
      NULL,
      1.788302,
      1.980904,
      1,
      1.460721,
      NULL,
      0,
      0.940278,
      0.138471,
      2.704705,
      1,
      0.639894,
      1,
      3.355801,
      13.972995,
      NULL,
      NULL,
      0.523968,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.777722,
      1.466088,
      1.435649,
      0.090219,
      0,
      6.399439,
      0.076833,
      2,
      NULL,
      NULL,
      NULL,
      9.927893,
      52.502733,
      5,
      3,
      1,
      '04331',
      '',
      '',
      1,
      '',
      NULL,
      '',
      0.468023,
      NULL,
      '',
      '');
commit;
end;
/


