set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5615804';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-11-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '0',
      NULL,
      NULL,
      '0400224',
      1.727266,
      1,
      3,
      NULL,
      '3143',
      NULL,
      0.852240,
      NULL,
      NULL,
      NULL,
      72.358898,
      NULL,
      2.446887,
      0,
      1,
      ' 6- 0-1980',
      70,
      3.492317,
      NULL,
      NULL,
      1.091762,
      ' 7- 7-1986',
      NULL,
      ' 6-17-2000',
      2,
      3.529175,
      2,
      0,
      0.400642,
      2,
      2.537724,
      0,
      1.763817,
      29.213119,
      2,
      NULL,
      NULL,
      NULL,
      11,
      3.198429,
      18,
      2.112157,
      1.319012,
      5.133092,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      0,
      2.781827,
      6,
      NULL,
      5,
      4,
      3,
      NULL,
      9,
      2,
      0.507818,
      0,
      0.105588,
      1,
      2.500492,
      0,
      5.496939,
      1,
      0.371221,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      3.392619,
      2.755932,
      1,
      3.006627,
      NULL,
      1.020498,
      1,
      0,
      0,
      1.464744,
      NULL,
      NULL,
      3.912727,
      1.756272,
      0,
      1.301908,
      0.761854,
      NULL,
      0,
      3,
      0,
      5,
      1.687410,
      1.659147,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      4,
      7,
      0.942748,
      0.769092,
      NULL,
      1,
      1.314245,
      0,
      0,
      NULL,
      1.078626,
      1,
      1.451602,
      1,
      0,
      0.929441,
      NULL,
      0.450015,
      NULL,
      3.971732,
      1.065563,
      7.860146,
      1,
      NULL,
      9,
      NULL,
      6,
      2.129370,
      6,
      4,
      5,
      NULL,
      0,
      0.775073,
      7,
      4,
      0.721856,
      9.333756,
      NULL,
      4,
      3.616095,
      NULL,
      5,
      NULL,
      1,
      ' 8- 4-1979',
      605,
      '10-14-1992',
      482,
      0.114544,
      0.137464,
      1.871425,
      1.355112,
      0.521796,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.484835,
      2.465001,
      0,
      1,
      0.181168,
      1,
      2.130761,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.008766,
      3,
      0,
      0,
      0,
      2,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.342047,
      NULL,
      0.946893,
      NULL,
      NULL,
      1.091675,
      NULL,
      1.416314,
      4,
      0,
      NULL,
      NULL,
      1.209226,
      9,
      3,
      3,
      8,
      4.038609,
      0,
      ' 1-17-1998',
      9,
      ' 8- 9-1981',
      14,
      1,
      NULL,
      NULL,
      0,
      2.865684,
      1,
      1,
      1,
      1.693779,
      1.820612,
      2.111155,
      83.901921,
      3,
      1,
      NULL,
      NULL,
      NULL,
      0.360346,
      1,
      3.033667,
      NULL,
      3.868395,
      2,
      0.496870,
      0,
      NULL,
      NULL,
      1.316147,
      1,
      2,
      3.613875,
      2,
      NULL,
      1.154617,
      0.844721,
      1,
      NULL,
      0.566531,
      0.480219,
      NULL,
      NULL,
      NULL,
      0,
      0.234593,
      1.001010,
      1,
      1,
      3.889511,
      NULL,
      8,
      NULL,
      5,
      NULL,
      NULL,
      5,
      1,
      1.998874,
      3.550207,
      2.943738,
      3.279414,
      0.898094,
      NULL,
      3,
      1.717325,
      NULL,
      15.358224,
      8,
      29,
      0,
      0,
      2,
      '43110',
      '',
      '',
      0,
      NULL,
      '',
      NULL,
      0,
      '',
      '',
      '',
      2.512494,
      21,
      84.629869,
      25.899260,
      0.731334,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.392580,
      0,
      1.852841,
      NULL,
      NULL,
      3.285062,
      2,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0.898718,
      NULL,
      3.168724,
      0.426857,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.311002,
      NULL,
      NULL,
      0.733573,
      NULL,
      NULL,
      1.899379,
      NULL,
      NULL,
      NULL,
      5,
      1.516249,
      1.770041,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.390477,
      0,
      0.011843,
      NULL,
      NULL,
      0.910411,
      NULL,
      NULL,
      2.849621,
      NULL,
      0,
      NULL,
      0.050707,
      0.743334,
      1.203408,
      0,
      1.063850,
      0.259282,
      1.622691,
      3,
      1,
      0,
      0.150462,
      1,
      0.991441,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6.760118,
      0,
      NULL,
      1.349346,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1.453014,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.604102,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.416610,
      1.975585,
      0,
      1.524728,
      NULL,
      NULL,
      0.213387,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.126417,
      NULL,
      NULL,
      0.367360,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.582467,
      0,
      NULL,
      NULL,
      NULL,
      8,
      2.231506,
      5.947200,
      7,
      0.124965,
      2,
      3.253575,
      0,
      1,
      3.381309,
      3.779080,
      1,
      1.061781,
      2.573658,
      1,
      3,
      3.319239,
      NULL,
      6.999615,
      4.365385,
      1.394882,
      1.386565,
      1.616991,
      NULL,
      NULL,
      3.831351,
      2,
      0.188250,
      0,
      0,
      1,
      3.936873,
      1.034969,
      9,
      0.961830,
      9.316668,
      9,
      3.022677,
      1,
      3,
      5,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.272557,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.118618,
      NULL,
      NULL,
      1.908272,
      NULL,
      NULL,
      1.946249,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.873500,
      NULL,
      NULL,
      0.939612,
      1,
      3,
      NULL,
      0.846775,
      0,
      3.968954,
      NULL,
      NULL,
      1,
      4.902198,
      NULL,
      NULL,
      89.782482,
      13.232769,
      NULL,
      NULL,
      2,
      3.093281,
      NULL,
      NULL,
      0.412118,
      1,
      NULL,
      NULL,
      1.279691,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.292341,
      NULL,
      NULL,
      1.718417,
      0,
      NULL,
      NULL,
      3,
      2.466101,
      NULL,
      NULL,
      3.323580,
      2.580713,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.053568,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      0.698233,
      NULL,
      NULL,
      1.628115,
      3,
      NULL,
      NULL,
      2,
      0.498506,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      0.024297,
      3,
      NULL,
      NULL,
      12,
      15,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.944513,
      2,
      4.599771,
      0.112392,
      2.500359,
      1,
      1,
      NULL,
      NULL,
      3,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      6,
      1.594853,
      338.342921,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      1,
      0.619530,
      NULL,
      1.249264,
      0,
      0.342708,
      1,
      1,
      0.805904,
      1,
      0,
      1.049278,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      4.583440,
      2.086863,
      4,
      NULL,
      5,
      3,
      NULL,
      2.466603,
      1,
      3,
      1.669130,
      1,
      2,
      1.836034,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.993370,
      1.044383,
      0.680976,
      3.592902,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1.963889,
      NULL,
      1,
      2.729564,
      3,
      NULL,
      1,
      0.577839,
      NULL,
      2,
      0.978879,
      1,
      NULL,
      0.213218,
      3,
      3,
      1.677316,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.543176,
      0,
      0,
      0,
      1,
      1.908739,
      0.079924,
      0.856535,
      0.626594,
      NULL,
      1,
      1,
      1.276592,
      2.427011,
      NULL,
      3.268145,
      NULL,
      1,
      3.214371,
      0,
      NULL,
      1.116782,
      1,
      3,
      1.318312,
      NULL,
      3.579901,
      1.731443,
      7,
      NULL,
      1.983819,
      0,
      2,
      1.576873,
      1.258589,
      NULL,
      NULL,
      6.703425,
      0.079884,
      1,
      1.208831,
      63,
      NULL,
      1,
      NULL,
      2.872732,
      '13330',
      '',
      '',
      3,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


