set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9531493';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-10-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '3',
      NULL,
      NULL,
      NULL,
      0.617568,
      0,
      1,
      2,
      '1441',
      1,
      NULL,
      NULL,
      NULL,
      ' 7-22-2002',
      24,
      NULL,
      0,
      1.145055,
      2.540493,
      ' 7-10-1996',
      NULL,
      3.797948,
      161,
      NULL,
      0.113297,
      ' 8- 2-1992',
      ' 7- 3-1979',
      ' 2-21-1987',
      0,
      1.165176,
      0,
      1.582535,
      0,
      3,
      1.617670,
      2,
      NULL,
      NULL,
      NULL,
      5.384786,
      7,
      NULL,
      19.803674,
      NULL,
      9.656487,
      3.470592,
      1.510371,
      7,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.263134,
      1,
      1.331275,
      1.408870,
      0,
      0,
      2,
      1,
      NULL,
      2.393499,
      NULL,
      1.525695,
      1.483896,
      1,
      0.990000,
      NULL,
      7.208215,
      1.305081,
      NULL,
      NULL,
      1,
      1.003014,
      5,
      1,
      0.303817,
      0.210041,
      1,
      1.300944,
      NULL,
      NULL,
      3.340472,
      2.698587,
      NULL,
      1,
      1.462850,
      1.138353,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.177248,
      1,
      1.346361,
      1.237088,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.400875,
      0.117618,
      1.989332,
      1.728932,
      0,
      1.383743,
      0.762556,
      0.528398,
      NULL,
      1.414422,
      NULL,
      1,
      1,
      1,
      1.509583,
      0.683208,
      1.830576,
      0.904124,
      1.334938,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.372575,
      NULL,
      1.854271,
      1,
      0,
      1.443378,
      1.180614,
      1.472881,
      0.017176,
      0.546667,
      0,
      0.066370,
      1,
      0.811477,
      5,
      2.489588,
      1,
      NULL,
      NULL,
      1,
      0,
      0.339883,
      1.778624,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      0.323603,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.417736,
      NULL,
      2,
      NULL,
      NULL,
      0.029468,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.094448,
      3.125964,
      0.328487,
      0,
      0.116039,
      0,
      0.068348,
      2.554485,
      NULL,
      NULL,
      0.295846,
      NULL,
      NULL,
      NULL,
      2.315889,
      6,
      1.469994,
      NULL,
      1.042501,
      5,
      6,
      NULL,
      NULL,
      ' 8-11-1998',
      97.913786,
      1,
      NULL,
      1,
      0,
      1.558283,
      1,
      0,
      1.072890,
      1.081658,
      1.163411,
      3.456069,
      5,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      0.824635,
      3,
      3.600879,
      1,
      NULL,
      3,
      1,
      NULL,
      1.407152,
      2.937368,
      5.064898,
      NULL,
      NULL,
      NULL,
      NULL,
      0.397312,
      NULL,
      0.828560,
      1,
      0,
      0.772077,
      1,
      0,
      0,
      1,
      3.544158,
      0.224803,
      6,
      NULL,
      0,
      NULL,
      2,
      3,
      NULL,
      0,
      3.726638,
      1.388870,
      1.062421,
      NULL,
      27,
      0,
      3.308320,
      NULL,
      21,
      25.792421,
      72.303856,
      0.995896,
      0.217232,
      NULL,
      '42104',
      '22413',
      '01441',
      0,
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      '',
      2.673004,
      37.542015,
      16,
      40.161484,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.626406,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.117200,
      NULL,
      NULL,
      0.725891,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.924110,
      1.245702,
      NULL,
      NULL,
      NULL,
      1.211071,
      3.975012,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.937866,
      4,
      2,
      0.070759,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.160233,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.608781,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.231458,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.071453,
      NULL,
      NULL,
      0.661238,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.358938,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.380579,
      NULL,
      NULL,
      0.105260,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.799439,
      NULL,
      NULL,
      1.107385,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.614784,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.686242,
      1.671458,
      3.818589,
      1,
      NULL,
      NULL,
      3,
      2,
      4.377131,
      3,
      NULL,
      3.371043,
      1.602375,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.031861,
      1,
      NULL,
      3.169841,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.837856,
      1,
      0.761055,
      0,
      1.286247,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3.961256,
      2,
      NULL,
      1,
      0.790037,
      5.035772,
      1,
      NULL,
      NULL,
      41,
      9,
      NULL,
      NULL,
      3.086614,
      1.439947,
      NULL,
      NULL,
      0.806114,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.765087,
      NULL,
      NULL,
      NULL,
      0.432035,
      1.015484,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.689577,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.939646,
      NULL,
      NULL,
      NULL,
      3.010932,
      1.171823,
      NULL,
      NULL,
      1.928495,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.174761,
      1.728442,
      NULL,
      NULL,
      9.692315,
      2.743596,
      NULL,
      NULL,
      0.018489,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.708435,
      1.745701,
      2,
      0.253304,
      1.965992,
      0.729244,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.391338,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      0,
      3,
      NULL,
      1.057820,
      NULL,
      NULL,
      1.491540,
      1,
      1,
      0.999531,
      1.979539,
      0.403478,
      1,
      0.859003,
      0.537479,
      1.060245,
      1.633329,
      3.578384,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.740270,
      NULL,
      NULL,
      NULL,
      0.293844,
      NULL,
      4.791287,
      NULL,
      0,
      36.323576,
      NULL,
      0,
      0.578973,
      NULL,
      NULL,
      NULL,
      NULL,
      0.985503,
      NULL,
      1,
      NULL,
      0.308154,
      NULL,
      0.447255,
      NULL,
      1.356280,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.990871,
      NULL,
      1,
      NULL,
      1.203456,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.804886,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.851082,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.917423,
      0.376786,
      NULL,
      3,
      NULL,
      1,
      NULL,
      45.514148,
      NULL,
      0,
      NULL,
      1.412526,
      NULL,
      NULL,
      0,
      NULL,
      3.033925,
      6.558880,
      1.061306,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      0,
      0.195728,
      1,
      NULL,
      3.587097,
      1.292557,
      1,
      1,
      NULL,
      NULL,
      1.793288,
      NULL,
      0.187686,
      1,
      NULL,
      1.306258,
      1.554414,
      NULL,
      0.239379,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.755642,
      NULL,
      0.219940,
      1.060930,
      NULL,
      NULL,
      1.769334,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.201725,
      NULL,
      2,
      0.061334,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.370306,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.121602,
      NULL,
      0.013320,
      NULL,
      0,
      NULL,
      NULL,
      0.521124,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      126,
      0,
      0.771207,
      4,
      '13012',
      '20144',
      '14214',
      1.883094,
      '',
      '',
      '',
      1,
      '',
      '',
      NULL);
commit;
end;
/


