set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000090';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-3-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '3',
      NULL,
      NULL,
      '4031341',
      0.490629,
      1.222959,
      NULL,
      0,
      '3233',
      0,
      3.585380,
      4.054133,
      3,
      ' 2- 0-1976',
      33.047777,
      NULL,
      1.467943,
      0,
      0,
      ' 3-27-1987',
      84.348058,
      4.557694,
      180.135241,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.323615,
      1.963558,
      0,
      NULL,
      2.524025,
      1,
      0.575136,
      NULL,
      150.868541,
      3,
      12,
      1.122695,
      5,
      14.180350,
      7.757929,
      23.155406,
      3.154170,
      0,
      1,
      1,
      1,
      3.946381,
      0,
      NULL,
      NULL,
      0.062157,
      NULL,
      0,
      0,
      0,
      0.923297,
      NULL,
      NULL,
      0.801615,
      0,
      1,
      0,
      0.244898,
      0.167717,
      1.902877,
      1.437880,
      0,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.918924,
      0,
      0.357175,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.516992,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      0.677373,
      0,
      0.301439,
      NULL,
      0.242228,
      0,
      0,
      1,
      NULL,
      0.258799,
      1.192985,
      0,
      1.364506,
      0,
      0,
      NULL,
      0,
      2.397125,
      1,
      1,
      1,
      0,
      3,
      NULL,
      0,
      NULL,
      0,
      1,
      2.318922,
      NULL,
      1.571017,
      1,
      3,
      7.693551,
      5,
      3.484254,
      0.906377,
      3.924949,
      7.749596,
      6.046111,
      0,
      1.316860,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      0.481908,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.413068,
      0.802494,
      1.908826,
      0,
      0.789999,
      1.400934,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      4,
      1.468526,
      1,
      5.216261,
      0,
      NULL,
      NULL,
      NULL,
      1.412449,
      NULL,
      1.172208,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.368376,
      NULL,
      1,
      1,
      1.047771,
      NULL,
      1.150149,
      NULL,
      1,
      3,
      87.401866,
      70.194138,
      189,
      1.931457,
      NULL,
      NULL,
      1,
      NULL,
      3,
      0.214688,
      1.677349,
      1.524345,
      NULL,
      NULL,
      1.005117,
      1,
      0.980085,
      NULL,
      2,
      NULL,
      1,
      1.763917,
      14.359635,
      NULL,
      1.307619,
      3,
      0.275736,
      0.891423,
      3,
      0,
      0.092528,
      3,
      1.512132,
      2,
      1,
      2,
      2,
      2,
      NULL,
      NULL,
      0.769405,
      3.020674,
      2.237418,
      2.734449,
      1,
      3,
      0.485993,
      25.249930,
      NULL,
      1,
      62,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      '20234',
      '',
      NULL,
      0,
      '',
      '',
      '',
      3.994341,
      '432',
      '04334',
      NULL,
      NULL,
      69.733493,
      188.901259,
      40,
      3,
      55,
      58,
      16,
      NULL,
      2.607680,
      NULL,
      3.342558,
      1.084366,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.145281,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.596115,
      NULL,
      NULL,
      0.136404,
      NULL,
      NULL,
      0.735366,
      NULL,
      NULL,
      2.552984,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.165511,
      1,
      2.027613,
      NULL,
      3,
      1.421065,
      0.490598,
      NULL,
      NULL,
      3.307515,
      3,
      1.964226,
      0,
      NULL,
      1,
      0,
      1,
      1.877484,
      3.410874,
      2.029570,
      NULL,
      1,
      3,
      1.925977,
      NULL,
      0.328100,
      NULL,
      NULL,
      1.395415,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      9,
      NULL,
      2.620547,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.530454,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.070871,
      2,
      1.916081,
      NULL,
      1.513372,
      1,
      0.908130,
      NULL,
      NULL,
      2.568804,
      1.096063,
      1.297915,
      11.307569,
      NULL,
      NULL,
      1.870169,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      17.489429,
      NULL,
      NULL,
      3.541180,
      17.918965,
      6.379137,
      1.734059,
      NULL,
      NULL,
      0,
      2.713646,
      NULL,
      0.120740,
      NULL,
      NULL,
      NULL,
      12.925144,
      9,
      NULL,
      1.736069,
      NULL,
      0,
      NULL,
      0.024560,
      NULL,
      4,
      6,
      3,
      14,
      3.165919,
      3,
      10.807732,
      NULL,
      0.207327,
      16.816865,
      1.841574,
      0.289367,
      10,
      0.626748,
      2,
      0,
      3,
      1,
      NULL,
      NULL,
      1.079708,
      0.698660,
      4,
      1.247196,
      1,
      0,
      0,
      0,
      2,
      NULL,
      NULL,
      0.195133,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      17,
      NULL,
      NULL,
      1.291966,
      NULL,
      NULL,
      3.259482,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.006646,
      1.973665,
      0.018387,
      1.641147,
      NULL,
      NULL,
      NULL,
      2,
      5.015968,
      NULL,
      NULL,
      1200.325065,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.760434,
      0,
      NULL,
      NULL,
      2,
      1.513530,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1.743315,
      NULL,
      NULL,
      2.931968,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.251472,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.590153,
      0,
      NULL,
      NULL,
      1.227044,
      0.614927,
      NULL,
      NULL,
      1.189124,
      1.343276,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.591164,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      0.798000,
      NULL,
      NULL,
      NULL,
      7,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      112,
      154,
      2,
      4.279682,
      0.512125,
      1.924281,
      NULL,
      NULL,
      1.253910,
      NULL,
      NULL,
      3.748073,
      3,
      0.368992,
      1.680888,
      NULL,
      NULL,
      1,
      NULL,
      0.445008,
      1801,
      57.800959,
      NULL,
      1.281637,
      1.381315,
      1,
      1.100010,
      0.476359,
      1.903275,
      0,
      1,
      1.976002,
      0.752080,
      NULL,
      1,
      0,
      1,
      1.926106,
      1.924329,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      1.544312,
      NULL,
      0.673248,
      1,
      1.738938,
      5,
      1.669921,
      NULL,
      0.603587,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.483279,
      0,
      0.149268,
      NULL,
      1,
      1.929509,
      NULL,
      0.295691,
      0.418093,
      3,
      17.024656,
      4.548044,
      3,
      NULL,
      1.650836,
      NULL,
      1.123525,
      0,
      1,
      0,
      1.929035,
      0.478560,
      16.837846,
      NULL,
      0,
      19.417303,
      12,
      2,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      1.746957,
      3,
      8,
      NULL,
      0,
      0.955385,
      1,
      0,
      11,
      7,
      NULL,
      NULL,
      '40342',
      '',
      '',
      1,
      NULL,
      '',
      '',
      3.259528,
      '430',
      '22122',
      NULL);
commit;
end;
/


