set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6909717';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-5-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0,
      3,
      NULL,
      2,
      2,
      1,
      0,
      2.368167,
      '430',
      '30114444',
      3,
      33.376661,
      NULL,
      1,
      NULL,
      2,
      0,
      '3213',
      0,
      0,
      NULL,
      NULL,
      ' 3- 1-1993',
      1,
      41,
      NULL,
      0.900941,
      1.647001,
      ' 0- 1-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-19-1978',
      ' 7-27-1985',
      0.488376,
      3,
      0,
      2.752756,
      1,
      3.780262,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.426308,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.985583,
      1.583021,
      1,
      0.207496,
      NULL,
      1.757617,
      0.894937,
      NULL,
      1.232508,
      0,
      2.689751,
      0,
      NULL,
      7.242364,
      0,
      0.864929,
      3,
      2,
      7,
      5,
      2.735197,
      NULL,
      0,
      1,
      NULL,
      6,
      0.660679,
      2.013548,
      NULL,
      3.964001,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.196939,
      0,
      0.143614,
      0.738342,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.641800,
      1.410995,
      NULL,
      0,
      NULL,
      NULL,
      0.131857,
      1,
      1,
      0,
      1,
      1,
      1.293477,
      1.988999,
      0.743303,
      0,
      1,
      1.155081,
      0.481846,
      NULL,
      1.063048,
      2,
      NULL,
      NULL,
      0.557931,
      NULL,
      2,
      NULL,
      0.987587,
      7,
      2,
      5,
      NULL,
      5,
      0,
      9,
      3,
      NULL,
      NULL,
      NULL,
      2.259612,
      5.573097,
      3.824433,
      0.246362,
      0,
      3.877137,
      0,
      0,
      ' 5-21-1977',
      310.868600,
      NULL,
      0,
      0.921461,
      1.886143,
      0,
      4.533565,
      1.143451,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.748682,
      0.084723,
      0,
      1.286798,
      0.098843,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      2,
      1.930426,
      1.122149,
      0.921722,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.801758,
      2,
      NULL,
      NULL,
      3,
      1.197877,
      4,
      NULL,
      2,
      NULL,
      7.485180,
      0.909065,
      0,
      NULL,
      NULL,
      1.456557,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.216815,
      0,
      0.877355,
      NULL,
      0.372230,
      0,
      3.479907,
      1.266297,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      3.017206,
      1,
      2.037465,
      1.766632,
      3.109161,
      3,
      1,
      1,
      2.579993,
      2.102592,
      0,
      NULL,
      2,
      NULL,
      NULL,
      1.754524,
      0,
      0.234559,
      0,
      0,
      NULL,
      NULL,
      1,
      1.553403,
      1.264840,
      1.680424,
      0,
      NULL,
      NULL,
      11,
      NULL,
      1.935406,
      7,
      8.357153,
      5,
      3,
      2.723904,
      7.326127,
      NULL,
      0.436065,
      3,
      41,
      NULL,
      2.311632,
      39.327913,
      NULL,
      43,
      33.855730,
      2,
      NULL,
      0,
      '41311',
      '00124',
      '',
      1.379643,
      '',
      '',
      '',
      0.053073,
      NULL,
      '',
      '',
      NULL,
      31.490931,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.917158,
      3.415262,
      3.749766,
      3.778346,
      1.446861,
      NULL,
      NULL,
      2.159895,
      1,
      NULL,
      2.768576,
      2,
      1,
      0,
      2.775921,
      0.077692,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.734073,
      1.872512,
      NULL,
      NULL,
      1.369363,
      3,
      1.324274,
      1.518585,
      NULL,
      NULL,
      1.942578,
      1.508647,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.599617,
      0.761396,
      1,
      1,
      0,
      1.430300,
      1.868709,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.106774,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      2.273196,
      3.684654,
      1.412559,
      2,
      2.187382,
      1.669360,
      0,
      1.241728,
      0,
      0.511424,
      3,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.051405,
      NULL,
      NULL,
      3,
      7,
      1,
      NULL,
      3.470479,
      0.398459,
      1.394661,
      1.371890,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.593412,
      1.533991,
      0.704401,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      4,
      1.199141,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.510364,
      NULL,
      NULL,
      1.506019,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.845320,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.082458,
      2.988209,
      NULL,
      3.423651,
      0.427403,
      1,
      NULL,
      0.522512,
      2.158601,
      1.228906,
      5,
      0.028157,
      NULL,
      NULL,
      NULL,
      3.988882,
      1.977544,
      2,
      NULL,
      NULL,
      3,
      0.968593,
      2,
      NULL,
      0.232388,
      0,
      2,
      0,
      NULL,
      3,
      1,
      NULL,
      1,
      1.593535,
      0.798974,
      1,
      1.997443,
      2,
      6.064862,
      5.998040,
      4,
      6,
      4.683371,
      1.536036,
      3.436788,
      NULL,
      3.560827,
      1.571605,
      3.614774,
      3.298998,
      1,
      2,
      1.885734,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.774564,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.722361,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.280017,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4.243978,
      NULL,
      NULL,
      2,
      3,
      3,
      0,
      1.472414,
      2,
      0,
      NULL,
      NULL,
      1,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      0.221308,
      NULL,
      NULL,
      NULL,
      2.998677,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.201383,
      NULL,
      NULL,
      NULL,
      1.651765,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.980280,
      NULL,
      NULL,
      NULL,
      1.697943,
      NULL,
      0.285385,
      NULL,
      0.041451,
      NULL,
      1,
      NULL,
      0.250063,
      NULL,
      0.077973,
      NULL,
      2,
      NULL,
      1.159381,
      NULL,
      0.319428,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2.666260,
      2.106318,
      0,
      3.588182,
      16,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.528661,
      4.064544,
      4.062451,
      0.503508,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      135,
      NULL,
      0.557977,
      1,
      1,
      0,
      1,
      0,
      NULL,
      1.206854,
      0.589377,
      1,
      0.320541,
      1,
      1.740228,
      NULL,
      0,
      1.697075,
      1.601522,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      10,
      NULL,
      1,
      26.773844,
      12,
      NULL,
      3,
      3,
      NULL,
      0,
      NULL,
      1.614838,
      NULL,
      1,
      NULL,
      0.361424,
      NULL,
      1.389905,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.945467,
      NULL,
      1.515705,
      NULL,
      0,
      NULL,
      0.178321,
      NULL,
      1.592877,
      NULL,
      NULL,
      NULL,
      1.527264,
      3,
      0.948013,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.688420,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.679919,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.000598,
      1.611439,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.980817,
      1.996292,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.896333,
      NULL,
      0.974090,
      NULL,
      0.819286,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.347823,
      NULL,
      0.687027,
      1.517951,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.701672,
      3.480152,
      5,
      6.581414,
      0,
      2.098285,
      3,
      NULL,
      2.197036,
      NULL,
      0.988324,
      NULL,
      NULL,
      0,
      0,
      0.226118,
      1.799162,
      2.822892,
      1.096154,
      1,
      0.077371,
      0,
      0.500316,
      NULL,
      0.285113,
      0,
      0.395374,
      0.626912,
      NULL,
      1,
      1,
      0.897428,
      0,
      1,
      NULL,
      2,
      1.622992,
      1.753634,
      0.592446,
      NULL,
      0.657280,
      1,
      1,
      1,
      0.724094,
      0.726763,
      1,
      0.487420,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.586865,
      0.811063,
      NULL,
      NULL,
      0,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      117,
      1,
      NULL,
      4,
      '10004',
      '44104',
      '',
      1.781983,
      NULL,
      '',
      NULL,
      NULL,
      '',
      NULL,
      NULL);
commit;
end;
/


