set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9112150';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-5-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      '3014420',
      0,
      0.212032,
      NULL,
      3,
      '0324',
      0.641745,
      0.673026,
      NULL,
      NULL,
      ' 7-15-1998',
      41.824872,
      NULL,
      2,
      2.204818,
      0.191820,
      ' 1-23-1999',
      1,
      1.619129,
      NULL,
      15,
      NULL,
      '11-26-1981',
      ' 6-20-1981',
      ' 8-10-1975',
      NULL,
      1,
      2,
      NULL,
      1.798498,
      1.236310,
      2.235401,
      NULL,
      NULL,
      NULL,
      NULL,
      5.539240,
      2.211081,
      8.222183,
      12.089607,
      2.836042,
      16,
      NULL,
      2.984015,
      NULL,
      2.624817,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3.383878,
      3.864467,
      3.264331,
      0,
      0,
      NULL,
      1.055146,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.445055,
      1,
      0,
      5,
      0.050012,
      NULL,
      1.106103,
      1,
      0,
      NULL,
      NULL,
      1.070230,
      NULL,
      NULL,
      NULL,
      7,
      6,
      NULL,
      0,
      NULL,
      NULL,
      0.084496,
      1,
      1.591473,
      0,
      NULL,
      3,
      NULL,
      1,
      1.052654,
      1,
      1.550322,
      0,
      1,
      2,
      1,
      8,
      0,
      3,
      1,
      0.442249,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      2.999697,
      0,
      NULL,
      0,
      1.901297,
      0,
      0,
      6.954278,
      4.848609,
      1.696756,
      1.335712,
      5,
      1,
      0.788536,
      0.053528,
      1,
      0.051995,
      NULL,
      0.446965,
      0,
      1.097328,
      0.034195,
      NULL,
      0.867263,
      0.294103,
      0,
      NULL,
      1.264924,
      1.350912,
      1,
      0.897981,
      1.408021,
      0.281196,
      0,
      0.527366,
      NULL,
      1,
      NULL,
      7.312678,
      5,
      3,
      8,
      0.457794,
      0,
      NULL,
      3,
      '11-23-1990',
      760.866368,
      ' 2-25-1976',
      6.725952,
      1.368205,
      0,
      1.533275,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.513708,
      NULL,
      0,
      1.940175,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      35.259266,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.936850,
      0.276879,
      NULL,
      NULL,
      1.073256,
      1.371021,
      NULL,
      1.690885,
      2,
      0,
      0,
      5.302870,
      4.041319,
      1,
      NULL,
      NULL,
      1.398111,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.975474,
      1.511268,
      1,
      1,
      0,
      1.736169,
      NULL,
      0,
      23,
      0,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      2,
      3.903261,
      1.861140,
      2.584410,
      3,
      0.069224,
      3,
      2,
      2.802234,
      0.763381,
      NULL,
      3.033075,
      1,
      2,
      0,
      1.892136,
      0,
      0,
      3.800215,
      1,
      NULL,
      1.701821,
      1.037611,
      0,
      NULL,
      0,
      NULL,
      1.210776,
      NULL,
      8.823025,
      9,
      6.380346,
      8.902236,
      11.183704,
      1.988294,
      NULL,
      NULL,
      0.435469,
      2.593232,
      NULL,
      3.851401,
      43.642596,
      0.367164,
      0,
      NULL,
      18.176560,
      72,
      19,
      3,
      0,
      0.648122,
      '33023',
      '',
      '',
      1.120242,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      1.654442,
      NULL,
      107.172474,
      31.725463,
      1.114831,
      NULL,
      NULL,
      NULL,
      NULL,
      1.156021,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.111531,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.220557,
      NULL,
      NULL,
      2,
      NULL,
      2,
      0.709472,
      NULL,
      NULL,
      2,
      0,
      NULL,
      1.770752,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.632449,
      NULL,
      NULL,
      4.560906,
      5,
      NULL,
      0.222965,
      1.632347,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.666922,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.516779,
      1.007562,
      0.681646,
      NULL,
      NULL,
      5.834811,
      0.637879,
      0,
      NULL,
      2.806297,
      3.014806,
      1.798380,
      3.854115,
      0.442190,
      1,
      NULL,
      NULL,
      0.026720,
      NULL,
      NULL,
      0.428411,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.262103,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.063875,
      0,
      0.874951,
      0,
      NULL,
      NULL,
      2,
      1,
      0.084454,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.412498,
      NULL,
      3,
      2,
      2,
      NULL,
      3,
      1,
      3,
      1.653313,
      3.379883,
      0.708313,
      3,
      NULL,
      1,
      1.050121,
      0.380114,
      0.529267,
      5,
      4,
      NULL,
      1.653740,
      NULL,
      NULL,
      1.796435,
      0.283762,
      NULL,
      NULL,
      NULL,
      1.368049,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.976077,
      NULL,
      1,
      1,
      0.298856,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.484355,
      2,
      NULL,
      0,
      0.987437,
      NULL,
      NULL,
      2.745550,
      NULL,
      0.166662,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.115556,
      10.529991,
      NULL,
      1,
      0,
      1,
      1.689114,
      0.100843,
      NULL,
      1,
      0.102177,
      0,
      0.034683,
      1.809156,
      1.919138,
      0,
      0.920984,
      1,
      1.708953,
      0.656926,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3,
      3.844741,
      4.132446,
      5,
      NULL,
      2.271399,
      3,
      11,
      1,
      3.116554,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1,
      0,
      NULL,
      1.325915,
      0.091549,
      NULL,
      0.844560,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.052031,
      1,
      NULL,
      1,
      1,
      NULL,
      1,
      1.141731,
      NULL,
      0.056711,
      0.636035,
      NULL,
      0.870634,
      0.583808,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.050862,
      0,
      NULL,
      NULL,
      NULL,
      1.314100,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.488331,
      NULL,
      3,
      NULL,
      0.081036,
      NULL,
      3.019867,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.898473,
      3.234627,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.284230,
      NULL,
      1,
      6,
      2.592647,
      1.228071,
      NULL,
      NULL,
      45,
      132,
      NULL,
      0.746430,
      1,
      NULL,
      '',
      NULL,
      0,
      '33013',
      '',
      '',
      1,
      '',
      '',
      NULL);
commit;
end;
/


