set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7704198';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-9-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '2',
      NULL,
      NULL,
      NULL,
      2.361878,
      1,
      0,
      3,
      '3104',
      2.739078,
      0.842537,
      NULL,
      NULL,
      ' 7-28-1998',
      8,
      NULL,
      2,
      3,
      0,
      ' 0-29-1985',
      23.516982,
      2,
      159.924495,
      18,
      4.744967,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1.600493,
      0,
      1.886417,
      2.727369,
      3.857083,
      1.845494,
      NULL,
      269,
      NULL,
      19,
      5.948664,
      16,
      21.805926,
      8.940533,
      2.884131,
      4.489476,
      8.854885,
      1.626551,
      1,
      0,
      0.450425,
      1,
      NULL,
      NULL,
      1.251975,
      0,
      0.933883,
      NULL,
      72,
      NULL,
      NULL,
      0,
      3.585369,
      2.119826,
      1.030722,
      0,
      6.250317,
      0.618731,
      0.867890,
      2,
      0.419036,
      NULL,
      1,
      1.593760,
      1.242349,
      3,
      2,
      2.411994,
      3.144086,
      2,
      0,
      NULL,
      NULL,
      1.865408,
      NULL,
      NULL,
      2,
      3,
      3,
      1.116979,
      NULL,
      1.971874,
      1,
      1.919228,
      1.445164,
      1,
      1.772419,
      0,
      0,
      NULL,
      0,
      1.003762,
      1.365406,
      1.624355,
      0,
      NULL,
      0.149983,
      0.716252,
      NULL,
      2,
      3.374538,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.851284,
      4,
      1.490384,
      5.465134,
      9.916458,
      8.455326,
      0.111662,
      1.904240,
      NULL,
      1.450007,
      2,
      0,
      NULL,
      0.641924,
      1,
      1.545597,
      1.432066,
      NULL,
      NULL,
      1.551557,
      0,
      NULL,
      NULL,
      NULL,
      1,
      8.678643,
      2,
      0.638934,
      1.423405,
      9.364283,
      1.152928,
      2.462580,
      4,
      NULL,
      11,
      7,
      4,
      5,
      4.551119,
      NULL,
      9,
      10.775979,
      8,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      ' 6- 7-1981',
      378,
      0,
      0.668753,
      NULL,
      2.445442,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.719782,
      0.143921,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.554284,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.702084,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.732085,
      7.523334,
      2.936493,
      1.451532,
      NULL,
      1.589376,
      NULL,
      NULL,
      NULL,
      0.920799,
      6,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.980870,
      0.221344,
      0,
      1.825749,
      1,
      1.197686,
      2.520947,
      18.078088,
      0,
      1.520550,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.435061,
      NULL,
      8,
      41,
      NULL,
      3.523097,
      NULL,
      2.459535,
      '43030',
      '',
      '',
      1.573441,
      '',
      '',
      '',
      0.666749,
      '',
      NULL,
      '',
      0.359503,
      NULL,
      42.201420,
      29.698275,
      1.265368,
      18.170020,
      30,
      NULL,
      8.386913,
      0.994141,
      1.605942,
      NULL,
      0.822391,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.780239,
      0.245890,
      3,
      1,
      NULL,
      NULL,
      0.560799,
      NULL,
      NULL,
      1,
      2,
      3.503399,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.820495,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.113766,
      9.235505,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.747903,
      NULL,
      NULL,
      NULL,
      NULL,
      0.314214,
      NULL,
      1.293336,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.227143,
      1,
      1.537424,
      1,
      1,
      1,
      1,
      1.849375,
      1,
      0.082527,
      1,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.368142,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5.349985,
      1.857726,
      4.648819,
      0.904618,
      NULL,
      NULL,
      NULL,
      0.754867,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      2,
      3,
      0.015957,
      3.833127,
      1,
      NULL,
      NULL,
      2.110202,
      8,
      NULL,
      2,
      0,
      3.489957,
      1.226034,
      NULL,
      NULL,
      4,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.525628,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.486652,
      NULL,
      NULL,
      0.372042,
      NULL,
      NULL,
      2,
      2,
      2,
      8.752663,
      8,
      8.016538,
      1,
      9,
      NULL,
      3.671448,
      NULL,
      NULL,
      2,
      2.105420,
      1.926954,
      1,
      1,
      3,
      1,
      2.809076,
      0,
      11,
      7.173903,
      NULL,
      NULL,
      3.801473,
      0.047004,
      3.927347,
      NULL,
      1.368679,
      2,
      NULL,
      0.524320,
      2.855004,
      0,
      0,
      9,
      8.210845,
      NULL,
      6.387097,
      8.939479,
      2.028778,
      0,
      0.159846,
      5.778634,
      NULL,
      1.709644,
      1.532299,
      1.170568,
      1.077261,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.345820,
      NULL,
      NULL,
      1.204909,
      NULL,
      NULL,
      0.865056,
      NULL,
      NULL,
      1.231836,
      NULL,
      NULL,
      0.551340,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.286204,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      2.339880,
      1.756480,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.266552,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.181462,
      158,
      106,
      0.839164,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.381008,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      754.023277,
      973.077401,
      0,
      1,
      0.612655,
      0.546208,
      1.467331,
      0.933236,
      1.195948,
      1.928250,
      0,
      NULL,
      0,
      0,
      1.682720,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.946457,
      3,
      0.300335,
      4.582030,
      1,
      NULL,
      9,
      0.479695,
      NULL,
      15,
      1.022978,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.271805,
      NULL,
      9.228941,
      0.704957,
      NULL,
      6.408606,
      0.452802,
      NULL,
      16.667204,
      0,
      NULL,
      11.770313,
      NULL,
      NULL,
      2,
      0,
      NULL,
      14,
      3.756790,
      NULL,
      1,
      1.036020,
      1.265351,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.250346,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.605539,
      NULL,
      5.958429,
      10.980201,
      NULL,
      0.429607,
      0.870540,
      1.357297,
      45.239110,
      33.730683,
      1.404293,
      1,
      0,
      '34014',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


