set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8930257';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-1-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '3',
      NULL,
      NULL,
      '3013414',
      0.258973,
      1,
      0,
      NULL,
      '0403',
      0,
      3,
      NULL,
      0,
      ' 0-16-1974',
      24.073662,
      NULL,
      NULL,
      2,
      0,
      ' 1-18-1988',
      19,
      NULL,
      179,
      114.644802,
      2,
      '10- 8-1983',
      ' 2- 3-1986',
      '10-18-1995',
      3,
      3,
      0.113172,
      0,
      0.631946,
      2,
      3.888939,
      0,
      NULL,
      NULL,
      11,
      16.652462,
      0.623407,
      25.666754,
      124,
      2,
      18,
      NULL,
      NULL,
      0,
      0.382904,
      0.816592,
      1.977437,
      1,
      1.324792,
      0.776920,
      1.016113,
      0,
      1.070882,
      1,
      108.995505,
      10,
      3.933504,
      NULL,
      NULL,
      NULL,
      1.024969,
      0,
      6,
      1.428116,
      0.503189,
      1,
      0.032624,
      0.441546,
      0.582215,
      1.073943,
      0,
      5,
      NULL,
      5,
      5.403365,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0.292667,
      1.611178,
      7,
      5,
      9,
      3,
      NULL,
      1.031442,
      NULL,
      1.334803,
      NULL,
      7.277680,
      0.148390,
      NULL,
      0.474579,
      0,
      0,
      NULL,
      NULL,
      3.613286,
      NULL,
      1,
      3,
      5.953266,
      5,
      NULL,
      1.219531,
      1,
      4.774972,
      0.368410,
      4,
      3,
      3,
      11.646826,
      7.592260,
      5,
      6,
      NULL,
      0,
      NULL,
      5.609670,
      NULL,
      NULL,
      4,
      4,
      2,
      NULL,
      1964,
      NULL,
      297.698802,
      0.245963,
      NULL,
      1.558815,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.319523,
      1.899169,
      4,
      2,
      NULL,
      0,
      0.217095,
      1.125795,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.735378,
      NULL,
      NULL,
      NULL,
      NULL,
      5.571537,
      1,
      NULL,
      0.787289,
      3.338569,
      NULL,
      2.866808,
      1,
      2,
      0.236526,
      2,
      0,
      4.534020,
      1.915145,
      3,
      3.782550,
      1,
      7,
      0.063039,
      NULL,
      NULL,
      NULL,
      1.457589,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.224159,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      9739.749525,
      1,
      1.619615,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      0.124873,
      NULL,
      3,
      2.305849,
      NULL,
      NULL,
      NULL,
      3,
      3.182711,
      3.116343,
      18.842861,
      17.014587,
      NULL,
      1,
      1,
      16.327427,
      70.193935,
      56,
      NULL,
      1.142041,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.037764,
      NULL,
      0,
      3,
      2.055991,
      NULL,
      0.172033,
      1.858357,
      1,
      0.737540,
      1.779060,
      5.192727,
      NULL,
      NULL,
      0,
      26,
      3.302014,
      0,
      NULL,
      48.657719,
      1.638516,
      2.981438,
      NULL,
      1,
      0,
      NULL,
      '',
      '',
      1,
      '',
      '',
      NULL,
      1,
      NULL,
      '',
      '',
      NULL,
      13.982718,
      468.035917,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.006539,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      2.905735,
      0.893307,
      NULL,
      NULL,
      1,
      NULL,
      1.877578,
      3.739761,
      0,
      1,
      0.029058,
      NULL,
      NULL,
      0.954205,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.422134,
      NULL,
      NULL,
      0.946877,
      NULL,
      NULL,
      1,
      3,
      6,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.508490,
      18.916951,
      NULL,
      NULL,
      17,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.814710,
      NULL,
      1,
      1.192141,
      0.236388,
      NULL,
      0,
      0,
      0.713943,
      1.033135,
      1,
      0.647329,
      0,
      NULL,
      NULL,
      0.334273,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      5,
      NULL,
      3.284865,
      0,
      NULL,
      NULL,
      NULL,
      0.646058,
      NULL,
      NULL,
      NULL,
      1.426337,
      NULL,
      NULL,
      1,
      3.077890,
      3.000696,
      1.813874,
      1.920828,
      1.470237,
      1.555973,
      NULL,
      NULL,
      9,
      0,
      5,
      1.388539,
      NULL,
      0,
      2.743974,
      0,
      0.008297,
      0,
      3.522686,
      3,
      1.794578,
      NULL,
      NULL,
      1.384920,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.520458,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.312428,
      6,
      5,
      3.641263,
      5.128410,
      NULL,
      1.369249,
      2,
      NULL,
      6,
      1,
      0.174467,
      3,
      NULL,
      0.925563,
      2.410672,
      NULL,
      NULL,
      NULL,
      NULL,
      1.137944,
      1,
      NULL,
      0,
      3,
      NULL,
      NULL,
      1,
      3.741929,
      NULL,
      2,
      3.089704,
      NULL,
      0,
      7.051228,
      3.417749,
      2,
      NULL,
      NULL,
      0,
      0,
      NULL,
      9.194607,
      1,
      1.646643,
      0.060591,
      1,
      NULL,
      2.794675,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.898808,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.083900,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.535413,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      0.313198,
      1.774775,
      1.675632,
      0,
      0.758878,
      NULL,
      0.907524,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.075846,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.674221,
      NULL,
      NULL,
      NULL,
      0.631107,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.106312,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.278983,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5.836467,
      NULL,
      NULL,
      NULL,
      0.937934,
      NULL,
      NULL,
      NULL,
      0,
      246.257417,
      81.367955,
      0,
      NULL,
      NULL,
      0.127482,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.978782,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      42.221134,
      1,
      288,
      NULL,
      NULL,
      NULL,
      0,
      0.329197,
      1.220881,
      1.469473,
      NULL,
      0.078231,
      NULL,
      NULL,
      0,
      1,
      0.541009,
      0.847588,
      0.151591,
      1,
      0,
      0.124599,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.674349,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      3,
      13.004107,
      2.708237,
      2.468338,
      4,
      0.973779,
      NULL,
      NULL,
      1.910175,
      NULL,
      NULL,
      0.388837,
      NULL,
      14.764976,
      NULL,
      NULL,
      NULL,
      1.251167,
      NULL,
      NULL,
      8,
      NULL,
      1.812893,
      0.797684,
      NULL,
      13.390502,
      15,
      NULL,
      NULL,
      NULL,
      NULL,
      2.698249,
      NULL,
      NULL,
      0,
      0.400307,
      NULL,
      1.899079,
      3,
      NULL,
      1,
      1,
      NULL,
      2,
      NULL,
      0.993295,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.158230,
      NULL,
      0,
      NULL,
      NULL,
      1,
      15,
      0.065570,
      2,
      3.408555,
      18.107020,
      NULL,
      NULL,
      0.713626,
      1,
      '24433',
      '',
      '',
      1.812220,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      NULL);
commit;
end;
/


