set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9693193';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-3-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '31',
      NULL,
      26,
      22,
      NULL,
      NULL,
      0.410191,
      6,
      3,
      '4102',
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.180123,
      NULL,
      ' 8- 4-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      0.437889,
      NULL,
      ' 2- 0-1977',
      ' 2- 4-1980',
      0.719465,
      1,
      2.766750,
      1.601681,
      0.977299,
      3.099262,
      NULL,
      NULL,
      0.959325,
      2.096036,
      13.770579,
      11.057738,
      5.285789,
      NULL,
      NULL,
      NULL,
      NULL,
      5.249633,
      NULL,
      NULL,
      0.894477,
      1,
      1,
      0,
      NULL,
      0,
      NULL,
      0.503567,
      0.984187,
      16.567896,
      1.143662,
      5.831659,
      1,
      3,
      NULL,
      4,
      1.944480,
      2.169050,
      3.270488,
      NULL,
      6,
      NULL,
      NULL,
      3.652981,
      0.346731,
      1,
      1.234990,
      4,
      0.556997,
      1.176958,
      1,
      1.346876,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.350874,
      NULL,
      NULL,
      1.667800,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.256761,
      NULL,
      1.095827,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.900171,
      NULL,
      0,
      1.462026,
      NULL,
      4.846130,
      3,
      0,
      4.947367,
      4.636458,
      3.141789,
      0,
      NULL,
      8.348958,
      0.557820,
      0.049839,
      1.893715,
      0.476501,
      1.716735,
      NULL,
      1.546829,
      NULL,
      3.692961,
      0.953098,
      1,
      NULL,
      0.943173,
      5,
      0,
      3,
      3.731894,
      0.782830,
      0,
      2.582607,
      NULL,
      0.248987,
      5.642380,
      8.208227,
      8,
      NULL,
      0.401434,
      7.437764,
      7,
      6,
      1,
      2,
      NULL,
      NULL,
      ' 0- 4-1981',
      59,
      ' 8-21-1981',
      4.682502,
      1.329421,
      0.535407,
      1.438224,
      7,
      6,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.480031,
      1,
      0,
      5.823611,
      3.646951,
      4,
      1.595954,
      2.955533,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      16,
      3,
      3.094964,
      2.320107,
      1.269664,
      0,
      0.637821,
      0.637019,
      0,
      8,
      2,
      1.671630,
      1,
      1.907240,
      0,
      1,
      NULL,
      NULL,
      2,
      0,
      4.212755,
      0,
      NULL,
      NULL,
      NULL,
      1,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.995371,
      0.011850,
      NULL,
      NULL,
      0.654755,
      0,
      0.677678,
      3,
      NULL,
      NULL,
      0.277517,
      NULL,
      NULL,
      NULL,
      3.642687,
      1,
      NULL,
      2,
      1.106383,
      NULL,
      2.652772,
      2.710448,
      0.479099,
      NULL,
      1.627050,
      1,
      3.612590,
      NULL,
      1,
      3.113637,
      1.576170,
      0,
      NULL,
      NULL,
      0,
      1.437836,
      1,
      1,
      NULL,
      0.409221,
      0,
      0,
      NULL,
      1,
      2.541444,
      0,
      6,
      4.886752,
      7,
      7.462402,
      11,
      2.246930,
      1.945776,
      0,
      3,
      2,
      NULL,
      1.206561,
      70.316352,
      0.236950,
      1,
      16.088852,
      NULL,
      40.053377,
      15,
      1,
      0,
      3.665447,
      '13100',
      NULL,
      '',
      1,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      0.702600,
      13.546884,
      10.270859,
      31.813167,
      NULL,
      13.645160,
      NULL,
      NULL,
      4.134538,
      3.227296,
      0,
      3.658320,
      0.494794,
      NULL,
      NULL,
      NULL,
      0,
      3,
      2.835256,
      0,
      0.865022,
      1,
      NULL,
      NULL,
      1.149696,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0.572905,
      NULL,
      NULL,
      3.632598,
      NULL,
      0.009962,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.088630,
      0,
      0,
      1,
      1.830580,
      NULL,
      NULL,
      NULL,
      1.581962,
      NULL,
      NULL,
      NULL,
      1.487033,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.525607,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.930381,
      NULL,
      NULL,
      1.865243,
      NULL,
      NULL,
      0.869033,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.628765,
      0,
      NULL,
      2,
      3,
      0,
      3,
      2.404705,
      1.738897,
      NULL,
      NULL,
      0.465437,
      4.926986,
      0.140470,
      2.409411,
      2,
      1.760488,
      NULL,
      NULL,
      NULL,
      0.329575,
      3,
      4,
      0.455925,
      NULL,
      NULL,
      0.880483,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.435035,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.651992,
      NULL,
      NULL,
      2.341471,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1.275374,
      3.206967,
      3.010041,
      0,
      6.458064,
      3,
      0,
      0.807060,
      3,
      3.751763,
      2.270016,
      0.189108,
      0.432775,
      2,
      NULL,
      3,
      NULL,
      1.782264,
      0,
      NULL,
      0,
      0.718998,
      0,
      4.235412,
      NULL,
      NULL,
      2.963052,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      0.988604,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.132528,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.000115,
      NULL,
      NULL,
      1.455247,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      0,
      1,
      1,
      1.780402,
      0.463475,
      0.154287,
      NULL,
      NULL,
      NULL,
      5.274498,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.599112,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.621976,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.156118,
      NULL,
      NULL,
      NULL,
      0.968975,
      NULL,
      NULL,
      NULL,
      1.227905,
      NULL,
      NULL,
      NULL,
      1.067488,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.722537,
      NULL,
      NULL,
      NULL,
      1.255801,
      1,
      1.436385,
      1.615836,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.569150,
      NULL,
      0.822066,
      197,
      NULL,
      0.262601,
      1.024789,
      0.344265,
      0.718957,
      0,
      1,
      0.459952,
      1.132386,
      0.460610,
      1,
      2,
      0.119891,
      1.961546,
      1,
      1,
      NULL,
      1.142794,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.809476,
      NULL,
      1.522484,
      NULL,
      3,
      NULL,
      1.278931,
      NULL,
      0.425154,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.088026,
      0.387872,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.242868,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.971277,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.491319,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.691816,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.929485,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0.917676,
      2,
      0,
      1.986864,
      1.707628,
      2,
      4,
      3.262010,
      1,
      1,
      0,
      1.881824,
      NULL,
      0.198744,
      2.709320,
      NULL,
      0.845427,
      0,
      NULL,
      NULL,
      3,
      NULL,
      1.287161,
      0.440992,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.645569,
      NULL,
      0.712609,
      3,
      NULL,
      NULL,
      2.817810,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.163131,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      6.005318,
      1,
      NULL,
      NULL,
      11.042799,
      97.540073,
      5.485150,
      5,
      1,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL);
commit;
end;
/


