set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9231976';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-11-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '3',
      NULL,
      NULL,
      '4212122',
      3,
      0.705951,
      NULL,
      NULL,
      NULL,
      3.873792,
      1.680875,
      NULL,
      NULL,
      '11- 2-1992',
      NULL,
      NULL,
      7,
      3,
      1.868780,
      ' 8-21-1984',
      19.243427,
      1.549644,
      197,
      85.743454,
      2,
      ' 6-20-1994',
      ' 3-12-1994',
      NULL,
      0.844995,
      2,
      1.882572,
      2,
      1.547407,
      1.141239,
      0,
      3,
      NULL,
      NULL,
      NULL,
      3.020554,
      3,
      4.907587,
      NULL,
      NULL,
      14,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.288300,
      3.361519,
      1.821872,
      3.523572,
      6,
      1.704325,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      4,
      0,
      7.728405,
      9,
      NULL,
      0,
      4,
      1.775058,
      0.489161,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      11.449518,
      NULL,
      0,
      1.879009,
      NULL,
      2.726410,
      3,
      NULL,
      0,
      1.607524,
      NULL,
      3,
      0,
      1,
      0,
      NULL,
      3,
      3.988394,
      0.406204,
      7.954005,
      4,
      1.240593,
      0,
      4.446742,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.659864,
      1.461191,
      NULL,
      1.575096,
      NULL,
      4,
      3,
      1.376425,
      1.288459,
      1,
      1,
      0,
      NULL,
      0,
      NULL,
      1,
      0.496553,
      NULL,
      NULL,
      NULL,
      0.001091,
      NULL,
      1.225774,
      NULL,
      0.716364,
      NULL,
      3,
      7,
      5.435450,
      1.905367,
      2.212243,
      2,
      1,
      0.034712,
      1,
      0.439721,
      2.247253,
      1.966418,
      7,
      3,
      0,
      1,
      NULL,
      2.250688,
      1,
      0.506029,
      3,
      2.245027,
      '11- 8-2002',
      NULL,
      '11-27-1977',
      NULL,
      1.933785,
      2.262442,
      NULL,
      1.083502,
      0.074599,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.311238,
      1.131854,
      0,
      0,
      1.249878,
      3,
      3.747213,
      3.851365,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.761820,
      3.111901,
      4.621672,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.930088,
      3,
      1,
      2,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.425199,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.486505,
      1.439478,
      0.190625,
      2,
      0,
      1,
      0,
      0,
      13.197922,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.692476,
      1,
      3,
      NULL,
      0,
      3.314449,
      0.924281,
      0,
      3,
      2,
      NULL,
      NULL,
      2,
      2.474562,
      13.554465,
      9.754054,
      188,
      157,
      111,
      151.645416,
      177,
      26.429688,
      NULL,
      NULL,
      0,
      1.320951,
      1.670475,
      0.290133,
      0,
      16.358233,
      6.319933,
      0,
      9,
      11,
      6.669004,
      2,
      11,
      0.004847,
      3.439911,
      0,
      2,
      1,
      NULL,
      3.269967,
      13.134993,
      3.275748,
      3.408947,
      NULL,
      27.996123,
      15.963834,
      94.100134,
      3,
      0.610930,
      3.607784,
      '32403',
      NULL,
      '',
      1.152183,
      '',
      NULL,
      '',
      0.563557,
      '',
      '',
      '',
      1.294164,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.897638,
      1.851065,
      2.639934,
      1,
      0,
      1.131478,
      NULL,
      NULL,
      1,
      1,
      0.417341,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.639422,
      NULL,
      0.991279,
      92.414435,
      1.464225,
      1.204813,
      0.684224,
      1,
      1,
      0.059117,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      0,
      0,
      1.326622,
      0,
      1.504450,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.716988,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.761664,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.853101,
      0.344737,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.044107,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.398221,
      1,
      1,
      NULL,
      1.001180,
      NULL,
      NULL,
      NULL,
      1.059080,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.470837,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.755540,
      4.731327,
      1.186665,
      0,
      1,
      1,
      1.873840,
      3.250616,
      2.465194,
      2,
      NULL,
      1,
      0.185116,
      NULL,
      0,
      2,
      NULL,
      0.723462,
      1.289002,
      NULL,
      0.605122,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      0,
      NULL,
      2.940339,
      3.778342,
      NULL,
      1,
      3,
      NULL,
      0.608227,
      NULL,
      NULL,
      0.273915,
      0.562705,
      NULL,
      1.908871,
      1,
      NULL,
      2.045999,
      1.497776,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.487167,
      NULL,
      0.855947,
      5,
      NULL,
      0,
      NULL,
      NULL,
      105,
      29.715371,
      NULL,
      NULL,
      1,
      '44421',
      '',
      '',
      0.649983,
      NULL,
      NULL,
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


