set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9007923';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-4-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '0',
      NULL,
      NULL,
      NULL,
      1,
      1.765535,
      3,
      2,
      '0143',
      1,
      0,
      NULL,
      NULL,
      ' 1- 4-1988',
      14.477696,
      NULL,
      NULL,
      1.906407,
      0,
      ' 3-26-1994',
      48,
      2.892034,
      287.652030,
      106.911034,
      3,
      ' 1-18-1996',
      ' 1-26-1979',
      ' 6-16-1990',
      0,
      3,
      2,
      NULL,
      1.958274,
      NULL,
      3.863509,
      NULL,
      1,
      NULL,
      8.602277,
      0.158868,
      1.034408,
      17,
      28,
      0,
      6.268739,
      NULL,
      2,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.123027,
      2,
      NULL,
      0.534201,
      3,
      0.537293,
      NULL,
      7.016937,
      6.483110,
      3.246986,
      6,
      NULL,
      5.682653,
      1,
      1,
      0.210396,
      1,
      0,
      2.975978,
      2,
      0,
      0.500783,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.585307,
      0.351027,
      1.442733,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.923279,
      1,
      0,
      NULL,
      6.849886,
      1.742718,
      5,
      4,
      6.928968,
      NULL,
      0,
      NULL,
      NULL,
      1.945154,
      0,
      NULL,
      0.317104,
      NULL,
      1.378897,
      1.077529,
      1,
      1,
      5,
      0,
      0,
      7.498219,
      NULL,
      1,
      NULL,
      3.050855,
      NULL,
      5,
      1.745900,
      2,
      NULL,
      8,
      4.410000,
      1,
      4,
      NULL,
      11,
      0,
      3.167358,
      1,
      1.106435,
      1.802574,
      '10-19-1976',
      1866,
      ' 0-18-1998',
      596,
      3,
      0.155018,
      0.982577,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      1.871784,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.609203,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.228396,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      1.300978,
      NULL,
      4.432740,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.722740,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.568053,
      1.901783,
      1,
      1.075306,
      1.957303,
      3,
      NULL,
      3.863903,
      0,
      NULL,
      NULL,
      NULL,
      3.805465,
      1,
      0.690461,
      1,
      1.593828,
      0.841105,
      3,
      0,
      1,
      NULL,
      2,
      NULL,
      0.255704,
      0.911801,
      2.578900,
      1,
      0,
      NULL,
      0.350262,
      NULL,
      1.856350,
      0,
      2,
      1.894428,
      0.997276,
      1.778771,
      1,
      NULL,
      2,
      NULL,
      0.758465,
      NULL,
      4.113453,
      5,
      2.495303,
      2.660234,
      3,
      6,
      0.127845,
      3.870907,
      5.021680,
      3,
      2,
      NULL,
      57.796706,
      2.018379,
      NULL,
      NULL,
      12.984954,
      28,
      33.090655,
      NULL,
      1.244830,
      2,
      '21022',
      '',
      '',
      0,
      NULL,
      NULL,
      '',
      0,
      '',
      '',
      '',
      1.670478,
      NULL,
      22.025913,
      3,
      3.089749,
      NULL,
      18,
      48,
      0,
      1,
      2.944609,
      3.030961,
      0.738831,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      NULL,
      0,
      1,
      1.441112,
      2.251505,
      0,
      NULL,
      3.409208,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.896581,
      1.134560,
      0,
      NULL,
      NULL,
      0.572567,
      NULL,
      NULL,
      1.168825,
      NULL,
      NULL,
      7.434534,
      2.602323,
      3,
      NULL,
      1.022567,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.447380,
      0.073034,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      0,
      1.974918,
      3,
      3.471138,
      0,
      1.001171,
      1,
      1,
      0.539414,
      1,
      1,
      2,
      0.113162,
      1,
      0,
      1,
      0.439482,
      1.268339,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      1.150978,
      1.567307,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.400520,
      1.789264,
      0.254269,
      0,
      0,
      NULL,
      0.040491,
      NULL,
      NULL,
      6,
      1,
      0.388118,
      1.536876,
      1.239847,
      0.707876,
      NULL,
      1,
      0.568174,
      NULL,
      NULL,
      NULL,
      0.993883,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.063357,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.562835,
      3.733452,
      1,
      1,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      0,
      3.664537,
      3,
      1,
      1,
      1,
      1.156199,
      0.892086,
      3.268080,
      0,
      1.856899,
      2,
      0.091622,
      3.681796,
      6.492552,
      1.012310,
      3,
      1,
      0,
      NULL,
      1,
      2,
      2.001342,
      NULL,
      0,
      0.907584,
      1,
      3,
      0.146717,
      8.268786,
      2,
      9.422475,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      0,
      0,
      1,
      0.129851,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.756588,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.330375,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.206431,
      1,
      0.235146,
      1.103095,
      NULL,
      2.844684,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.401953,
      NULL,
      NULL,
      NULL,
      1.859043,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.055880,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.537524,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.299572,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.346712,
      NULL,
      NULL,
      NULL,
      9.760739,
      NULL,
      NULL,
      NULL,
      0,
      2.800832,
      4.743199,
      5.290500,
      0,
      NULL,
      308,
      1.692177,
      3,
      NULL,
      1.547224,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.271160,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.474776,
      19.079511,
      1,
      131.319277,
      22,
      1,
      0,
      1,
      0,
      0,
      0.204103,
      NULL,
      1.858076,
      1,
      1.492488,
      1.653969,
      0,
      NULL,
      NULL,
      1,
      1.067213,
      0.983997,
      0.460068,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.135775,
      7,
      1,
      NULL,
      NULL,
      1,
      5.751901,
      3.747381,
      7.939884,
      NULL,
      2,
      1,
      0.067124,
      2.042520,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      1.449358,
      0.805282,
      NULL,
      3,
      0.113500,
      NULL,
      1,
      0,
      NULL,
      3,
      0,
      NULL,
      2,
      3.391276,
      NULL,
      0.289048,
      NULL,
      NULL,
      2.061578,
      1,
      NULL,
      0,
      3.472015,
      NULL,
      3.247290,
      1.660369,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.012019,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.380839,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5.831476,
      4,
      5,
      2,
      2,
      0.168869,
      13,
      55,
      5.942922,
      0,
      NULL,
      '04440',
      '',
      NULL,
      3.486036,
      '12323',
      NULL,
      NULL,
      1,
      '',
      '',
      '');
commit;
end;
/


