set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9857297';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-12-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0,
      2,
      2,
      NULL,
      1,
      NULL,
      NULL,
      0.387283,
      '210',
      '32000033',
      64,
      62.045171,
      '3002204',
      NULL,
      NULL,
      3,
      NULL,
      '4101',
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      140,
      NULL,
      NULL,
      2.018254,
      2,
      '10-29-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      0.641725,
      NULL,
      ' 4-19-1996',
      ' 2- 9-1982',
      3,
      NULL,
      2,
      2,
      1,
      0,
      NULL,
      0.287109,
      NULL,
      NULL,
      NULL,
      8,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      3.367457,
      NULL,
      1.711187,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.366637,
      NULL,
      NULL,
      1.065905,
      4.156750,
      1,
      NULL,
      0,
      10,
      2,
      NULL,
      3,
      0.070585,
      NULL,
      4.677372,
      0.859554,
      4,
      1.761726,
      1.089091,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1.003739,
      1,
      3.943253,
      2.836603,
      NULL,
      1,
      0.856152,
      0,
      2.798835,
      NULL,
      1,
      0.488648,
      0.924887,
      3.994330,
      2.182049,
      1,
      0,
      0,
      4,
      0.486961,
      3.062348,
      1.855807,
      0,
      NULL,
      NULL,
      0.141611,
      NULL,
      NULL,
      0.242015,
      1.042805,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.230515,
      4.217825,
      NULL,
      0,
      1,
      6.899686,
      NULL,
      1.219587,
      NULL,
      0,
      1,
      NULL,
      1.284296,
      NULL,
      9,
      1.872546,
      0.954972,
      NULL,
      3.948739,
      1.921894,
      NULL,
      1.420199,
      0.462825,
      0,
      NULL,
      0,
      0.622937,
      0,
      9.120842,
      4,
      1.731656,
      9,
      0.488783,
      7.908279,
      4,
      8.489260,
      5,
      3,
      4.428135,
      1,
      ' 0-11-1975',
      203,
      ' 9-25-1997',
      27,
      1,
      1,
      0.366179,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      4.047888,
      4,
      1.400653,
      NULL,
      0.894958,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.503338,
      NULL,
      NULL,
      NULL,
      NULL,
      1.856253,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      2.299247,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.383748,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.349398,
      0,
      1.331009,
      NULL,
      NULL,
      1,
      34.603129,
      1.804365,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.240177,
      2.103034,
      NULL,
      3.685336,
      1,
      2,
      0,
      0,
      2.068230,
      1.137579,
      1,
      3.203975,
      3.782189,
      8.259466,
      NULL,
      NULL,
      NULL,
      1.437061,
      NULL,
      0,
      1,
      1,
      0.249977,
      NULL,
      0,
      1.394722,
      2.156345,
      1,
      1,
      10.590443,
      1.014464,
      4,
      7.224600,
      8,
      1,
      2.456246,
      0.012598,
      5,
      1.046062,
      NULL,
      NULL,
      32,
      3.438842,
      NULL,
      43,
      NULL,
      5,
      NULL,
      0,
      2.543277,
      NULL,
      '03341',
      NULL,
      '',
      1,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      3.495829,
      29.026298,
      31.539555,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.788911,
      0.488225,
      1.797345,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.248558,
      2,
      1,
      0.307302,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1.422160,
      1.849555,
      NULL,
      NULL,
      2.176907,
      0.091293,
      0,
      0.843214,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.070743,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.904178,
      1.263442,
      NULL,
      NULL,
      NULL,
      1.613060,
      NULL,
      NULL,
      NULL,
      1,
      3.254257,
      2.967346,
      3,
      1,
      2.728330,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1.879492,
      NULL,
      NULL,
      1,
      NULL,
      3.723018,
      1,
      1.220665,
      3.277922,
      1,
      0,
      0.616196,
      0,
      2,
      1.710595,
      NULL,
      NULL,
      0.031401,
      NULL,
      NULL,
      1.398153,
      NULL,
      NULL,
      NULL,
      2,
      0.644122,
      1,
      1.013613,
      NULL,
      NULL,
      NULL,
      1.632104,
      NULL,
      NULL,
      NULL,
      0.280630,
      NULL,
      NULL,
      0.034048,
      1,
      NULL,
      0,
      1.954460,
      0,
      0.384035,
      NULL,
      NULL,
      0.125436,
      2,
      0.445652,
      NULL,
      NULL,
      NULL,
      1.588501,
      NULL,
      NULL,
      0.358481,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.885483,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.465684,
      0,
      0.054825,
      NULL,
      3.566334,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.135378,
      NULL,
      0.117299,
      1.927266,
      1,
      0,
      NULL,
      0,
      0,
      4.874370,
      1,
      0,
      0.306057,
      3,
      3.357005,
      1,
      NULL,
      NULL,
      2,
      1.913225,
      2,
      0.334788,
      1,
      2,
      2.840119,
      NULL,
      NULL,
      3.966630,
      NULL,
      NULL,
      0.704420,
      NULL,
      NULL,
      0.194992,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.213940,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.273388,
      NULL,
      NULL,
      0.821682,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.009146,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      1,
      1.001035,
      0.766228,
      0,
      1,
      NULL,
      0.321930,
      NULL,
      NULL,
      1.746614,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.571733,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.099872,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.007159,
      NULL,
      2,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.295406,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.591051,
      NULL,
      NULL,
      NULL,
      17,
      0.627281,
      1.940632,
      0,
      1,
      1.650233,
      0,
      1.232083,
      NULL,
      1.843808,
      1,
      0.394029,
      0.218420,
      0.446617,
      NULL,
      0,
      1.557258,
      NULL,
      1.168391,
      NULL,
      1.096405,
      NULL,
      0.385445,
      NULL,
      0.588462,
      NULL,
      1.540984,
      NULL,
      0.952221,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.739905,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.112096,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.303605,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.813345,
      3.430174,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      NULL,
      0.290380,
      NULL,
      NULL,
      NULL,
      0.994017,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.631473,
      NULL,
      2.370855,
      0.366191,
      NULL,
      NULL,
      2,
      NULL,
      1.264721,
      1.826456,
      2.691878,
      NULL,
      1.663719,
      1.822488,
      NULL,
      NULL,
      3.648818,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.358430,
      0.277178,
      NULL,
      0,
      1,
      NULL,
      3.202757,
      1,
      NULL,
      1.287334,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.578418,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.227439,
      NULL,
      0,
      4,
      0,
      0.679960,
      NULL,
      NULL,
      50.448880,
      2,
      NULL,
      3.214025,
      NULL,
      '00112',
      '',
      '',
      0.078275,
      NULL,
      NULL,
      '',
      1.367218,
      '',
      '',
      '');
commit;
end;
/


