set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9212254';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-5-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '0',
      NULL,
      NULL,
      '4410311',
      3,
      0.027809,
      1,
      1,
      NULL,
      1,
      0.146153,
      NULL,
      NULL,
      ' 0- 9-1998',
      11.123463,
      NULL,
      5.384600,
      0,
      1.601408,
      ' 5-24-1979',
      29.491171,
      NULL,
      183,
      NULL,
      5,
      NULL,
      NULL,
      ' 4- 4-1975',
      3.699033,
      NULL,
      0,
      2,
      NULL,
      3,
      NULL,
      0,
      0,
      125.696866,
      0,
      7.651128,
      0.851265,
      21.217317,
      23,
      2.423292,
      21,
      NULL,
      0.238536,
      0.144944,
      1.361442,
      0,
      1.680853,
      0.781368,
      1.406144,
      0.782208,
      1.422010,
      1.539359,
      1.401568,
      0.060829,
      1,
      3,
      NULL,
      6.767674,
      NULL,
      NULL,
      1,
      3,
      1,
      1,
      NULL,
      0,
      1.864440,
      4.133280,
      0,
      3.150661,
      2,
      NULL,
      NULL,
      1.414236,
      2.093326,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7,
      5,
      NULL,
      3.664948,
      0,
      0,
      0,
      NULL,
      0,
      3.180964,
      2.505874,
      1.718160,
      0.519865,
      3.635435,
      1,
      1,
      3,
      2.526541,
      NULL,
      3.181229,
      0.295336,
      0.988329,
      0.484151,
      0,
      3.542250,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.235997,
      1,
      1,
      1.957036,
      NULL,
      0.625058,
      1.834415,
      NULL,
      1.639359,
      0.530134,
      1.923258,
      NULL,
      1,
      0,
      1.510097,
      1.321151,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.778156,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.847460,
      0.882240,
      1,
      0.575065,
      NULL,
      NULL,
      3,
      2,
      0,
      0.648311,
      3.148239,
      3,
      NULL,
      7.281056,
      5.504350,
      6.588990,
      5.995656,
      1.865029,
      0.485595,
      1.462168,
      1.417500,
      ' 0- 6-1989',
      1244,
      ' 1- 2-2003',
      1091,
      0.723418,
      3,
      1.264801,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3.812203,
      1.778790,
      1.221096,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.372353,
      1.237068,
      1.422822,
      2.438710,
      1,
      5,
      1.681144,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.658385,
      0,
      1.034773,
      1.059255,
      1.911037,
      1,
      1,
      1,
      24.306994,
      2,
      0.032339,
      NULL,
      NULL,
      NULL,
      0.700634,
      0.820895,
      1,
      NULL,
      2,
      0,
      0.412450,
      2.596859,
      3.044594,
      1,
      2,
      1,
      3,
      2,
      0,
      NULL,
      10,
      NULL,
      NULL,
      0,
      1.266356,
      1,
      NULL,
      0.203472,
      0,
      1.757362,
      0.205397,
      0,
      NULL,
      13.708354,
      NULL,
      0.607010,
      3,
      3.486604,
      6,
      10.929541,
      6,
      NULL,
      1.065969,
      1.370819,
      2.578372,
      1,
      1,
      1,
      63,
      2,
      NULL,
      18,
      NULL,
      NULL,
      NULL,
      1,
      0.652845,
      NULL,
      '03312',
      '',
      '',
      1.049377,
      '',
      '',
      NULL,
      0.090009,
      '',
      NULL,
      NULL,
      0,
      12,
      166.302507,
      14.067219,
      NULL,
      NULL,
      NULL,
      15.389903,
      NULL,
      3.837320,
      2,
      3.263497,
      1.882965,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.922381,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.645730,
      NULL,
      NULL,
      1,
      7.996473,
      1.374636,
      1,
      NULL,
      NULL,
      0.058547,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.283873,
      1.359965,
      0.421660,
      NULL,
      NULL,
      NULL,
      0.007737,
      NULL,
      NULL,
      NULL,
      2.605261,
      3,
      NULL,
      0,
      0.817924,
      NULL,
      3.203996,
      2.066746,
      1.431958,
      NULL,
      0.514555,
      1,
      1,
      0,
      0,
      1.612321,
      2,
      1.000644,
      0,
      NULL,
      NULL,
      0.087631,
      0.491031,
      NULL,
      0.958074,
      0,
      NULL,
      1.434981,
      1.976149,
      NULL,
      NULL,
      0.605183,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.819828,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      1.938037,
      NULL,
      NULL,
      0.133410,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.914168,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.743240,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.566564,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.779352,
      NULL,
      NULL,
      1.086311,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2.769600,
      2,
      1.363679,
      NULL,
      NULL,
      1.373526,
      NULL,
      NULL,
      3.813888,
      2.400240,
      2.766931,
      2,
      2.643626,
      3,
      NULL,
      6.299299,
      NULL,
      0,
      2,
      1,
      2.334703,
      0,
      3,
      3.474764,
      1,
      NULL,
      NULL,
      2,
      NULL,
      4,
      7.797054,
      NULL,
      2.674989,
      NULL,
      NULL,
      3.398939,
      NULL,
      3.163762,
      0,
      0,
      0,
      1.769303,
      1,
      0,
      NULL,
      NULL,
      1.305886,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.910416,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.150332,
      NULL,
      NULL,
      1.325999,
      NULL,
      NULL,
      2.619562,
      NULL,
      NULL,
      0,
      0.753943,
      NULL,
      1.769283,
      0.225200,
      NULL,
      0.855692,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.288097,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.688200,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.010486,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.773067,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      59.651226,
      447,
      NULL,
      NULL,
      NULL,
      1.519525,
      NULL,
      NULL,
      0.119454,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.721389,
      NULL,
      1.941016,
      1,
      0,
      1,
      0,
      NULL,
      1.678822,
      NULL,
      NULL,
      NULL,
      0.281906,
      NULL,
      1,
      1.907034,
      1.476032,
      1,
      0.645125,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.795397,
      0.659379,
      1.807146,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.907922,
      0.768850,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.419495,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.662936,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.828549,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.591619,
      0.078349,
      NULL,
      0,
      NULL,
      0.441158,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.282422,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.368651,
      1,
      1,
      NULL,
      1.260007,
      0,
      1.643586,
      3,
      1,
      1.944383,
      NULL,
      0,
      NULL,
      18.000982,
      NULL,
      NULL,
      0,
      NULL,
      1,
      2,
      NULL,
      1,
      2,
      NULL,
      1.684512,
      0,
      NULL,
      1,
      1.737243,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      NULL,
      1.789820,
      0,
      NULL,
      0.818261,
      2,
      NULL,
      NULL,
      0,
      NULL,
      3.787792,
      0.962570,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      31.299134,
      NULL,
      4,
      0.692124,
      2.651846,
      '42402',
      '',
      '',
      0,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


