set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9501630';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-3-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0404001',
      NULL,
      0.625636,
      1,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      ' 2-19-1997',
      12.492687,
      NULL,
      NULL,
      0.847264,
      NULL,
      ' 2-16-1979',
      38,
      2,
      60,
      NULL,
      1,
      ' 1-27-1985',
      ' 6-26-1985',
      NULL,
      0.276500,
      3.949266,
      1.454168,
      0.769428,
      NULL,
      1,
      1.477145,
      0,
      NULL,
      NULL,
      NULL,
      6.952828,
      5,
      15,
      16.459259,
      5.050731,
      4.660824,
      NULL,
      7,
      NULL,
      NULL,
      2,
      0,
      1,
      1.043079,
      0.958420,
      0,
      1,
      1,
      0,
      1.463507,
      3.304866,
      4,
      4,
      NULL,
      1,
      NULL,
      0.014055,
      1,
      1,
      1.680621,
      0,
      1.287081,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.293382,
      0,
      1.025637,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.499799,
      0.468494,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.021613,
      0,
      0,
      1,
      0.272576,
      1.438835,
      NULL,
      1,
      1.450710,
      1.565321,
      0,
      NULL,
      1,
      NULL,
      0.198056,
      0,
      1,
      1.673161,
      NULL,
      0,
      NULL,
      0.761548,
      NULL,
      0.615766,
      1,
      1.425860,
      1.285413,
      1,
      1,
      1,
      0.326125,
      0,
      0.340455,
      1.230522,
      1,
      11.348477,
      1.411628,
      6,
      3.770266,
      5.361090,
      0.413636,
      NULL,
      3,
      1,
      NULL,
      0.108867,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.757875,
      1.844297,
      1.842132,
      4.815274,
      1.085102,
      1.633523,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      1,
      0,
      NULL,
      NULL,
      NULL,
      4,
      3.291158,
      NULL,
      5.413993,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.279702,
      1,
      1,
      0.322980,
      0,
      1,
      2,
      10,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1.248374,
      NULL,
      0.336707,
      0.782904,
      1.638829,
      NULL,
      3.151318,
      NULL,
      2,
      NULL,
      0.907622,
      NULL,
      0,
      0.134331,
      3.598359,
      2.393217,
      1,
      NULL,
      0.468483,
      0.333089,
      NULL,
      1,
      1,
      1.230675,
      0.943643,
      1.203625,
      0.034276,
      1.489376,
      1.004218,
      0.061922,
      0,
      9.256007,
      NULL,
      NULL,
      6.096079,
      9.319861,
      2.818081,
      NULL,
      3.496602,
      3,
      2.006196,
      0.364068,
      2,
      62,
      1.895568,
      1.047941,
      NULL,
      26.563931,
      29.387403,
      58,
      3.007935,
      5,
      0.030768,
      '44132',
      '43341',
      NULL,
      1.533410,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.029692,
      16.672395,
      13,
      36.051656,
      NULL,
      20.294371,
      6,
      3.523930,
      2.304883,
      2,
      2.325778,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.109012,
      3.972411,
      1.945476,
      3,
      0.343768,
      3.317121,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      NULL,
      NULL,
      0.138833,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      4.058509,
      1.659649,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.839317,
      1.294552,
      1.077142,
      NULL,
      0,
      3,
      NULL,
      0,
      0.360235,
      2.354040,
      1.001410,
      1.786207,
      1.841781,
      NULL,
      NULL,
      3,
      NULL,
      3.471029,
      NULL,
      2,
      1.910753,
      1.026161,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1,
      1,
      1.469890,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.699444,
      NULL,
      NULL,
      2.980796,
      3,
      NULL,
      1.908135,
      NULL,
      0.913819,
      0,
      NULL,
      NULL,
      4,
      0.654371,
      NULL,
      NULL,
      NULL,
      NULL,
      1.417768,
      NULL,
      NULL,
      0.480966,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.336915,
      NULL,
      NULL,
      0.743244,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.005719,
      NULL,
      NULL,
      1.438141,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.277440,
      NULL,
      NULL,
      NULL,
      1.438409,
      0.076488,
      NULL,
      3.585695,
      NULL,
      NULL,
      0.585501,
      NULL,
      3,
      NULL,
      2.871761,
      3,
      0,
      1,
      0,
      3.884419,
      NULL,
      NULL,
      2,
      3.539742,
      1.088293,
      1.866236,
      3.547969,
      NULL,
      7,
      7.078687,
      0,
      7.989815,
      3.090190,
      2.094013,
      4.740471,
      4.288350,
      NULL,
      0.727825,
      1.090438,
      NULL,
      NULL,
      1.124875,
      NULL,
      NULL,
      2.394181,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.348839,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.197141,
      NULL,
      NULL,
      1.770724,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.889993,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.057878,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.586643,
      0,
      0.982490,
      0.740920,
      1,
      0.662659,
      NULL,
      NULL,
      NULL,
      0.486134,
      2,
      NULL,
      NULL,
      NULL,
      13.219065,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.654888,
      3.005625,
      NULL,
      NULL,
      NULL,
      1.268003,
      NULL,
      NULL,
      1.117200,
      0.832326,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      0.264904,
      0,
      NULL,
      NULL,
      1.510466,
      1.831239,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.204182,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      7,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.442454,
      0,
      5,
      NULL,
      0,
      0.232245,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      5.561517,
      4,
      3,
      1,
      NULL,
      1.414359,
      NULL,
      0.606427,
      NULL,
      8.921647,
      1.409642,
      0.978600,
      NULL,
      0.039722,
      0.343791,
      0,
      0,
      NULL,
      0,
      NULL,
      0,
      3.229526,
      0,
      0.744048,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.120468,
      NULL,
      1,
      NULL,
      1.186464,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.364216,
      1.707978,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.098491,
      0.198695,
      NULL,
      2.436264,
      NULL,
      2,
      NULL,
      77,
      NULL,
      NULL,
      NULL,
      2.371979,
      NULL,
      1,
      NULL,
      1,
      1,
      1.005511,
      NULL,
      2,
      NULL,
      3.633938,
      NULL,
      214,
      NULL,
      2,
      NULL,
      2,
      NULL,
      0.749376,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.743832,
      NULL,
      NULL,
      NULL,
      0.886158,
      NULL,
      1.879650,
      NULL,
      0.183701,
      1.917148,
      2,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.198873,
      1.305741,
      2.349301,
      4,
      0.603527,
      1.165060,
      0,
      1,
      0.164469,
      NULL,
      0,
      3,
      0.876814,
      NULL,
      0.730081,
      0.597870,
      3,
      0.589227,
      1,
      3.823147,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.967345,
      1.445170,
      1.397919,
      NULL,
      0,
      1.373923,
      NULL,
      NULL,
      0.269621,
      NULL,
      0,
      1,
      0,
      2,
      0,
      0.167115,
      2,
      2,
      1.960289,
      3,
      0.507660,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.203567,
      0.279405,
      0.416529,
      1,
      NULL,
      0.001929,
      NULL,
      3.244936,
      1,
      NULL,
      NULL,
      11.298471,
      70.683341,
      5.184493,
      3.384400,
      5.453020,
      NULL,
      '11140',
      NULL,
      NULL,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '');
commit;
end;
/


