set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9501630';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-7-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '42',
      '11',
      2,
      15.612743,
      NULL,
      2,
      1,
      3,
      NULL,
      '3244',
      NULL,
      1,
      NULL,
      NULL,
      ' 9-16-1975',
      16.977221,
      18.473107,
      NULL,
      0.291160,
      0.688632,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 6-15-1988',
      ' 5-22-1998',
      ' 3- 7-1986',
      NULL,
      NULL,
      1.327051,
      1.689102,
      0.428399,
      1.476019,
      2.808119,
      1.619625,
      0.661169,
      6,
      2,
      NULL,
      1.763634,
      NULL,
      NULL,
      NULL,
      NULL,
      7.311571,
      5.718236,
      NULL,
      0,
      3.661704,
      1,
      1.190314,
      NULL,
      1,
      NULL,
      0,
      1.779222,
      0.097208,
      1,
      0.546743,
      1.310644,
      3.232778,
      1,
      NULL,
      0,
      0.123211,
      4.859544,
      NULL,
      1,
      7,
      NULL,
      9.471086,
      5.098769,
      NULL,
      0,
      6.774236,
      NULL,
      2,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.064412,
      1.147885,
      0,
      0.090763,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2.647352,
      0,
      3,
      1,
      1.405538,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.270380,
      1,
      0.726710,
      1.211409,
      1,
      0.599323,
      1.826401,
      0,
      NULL,
      1.833594,
      1.063058,
      0.790747,
      NULL,
      1,
      NULL,
      NULL,
      0.929778,
      0.444135,
      NULL,
      NULL,
      0,
      1.003616,
      0,
      0.296025,
      0,
      NULL,
      0,
      0.102855,
      4.150279,
      NULL,
      NULL,
      1,
      1.198917,
      1.650463,
      7,
      9.160152,
      11,
      1,
      4,
      4,
      7.892255,
      6.461668,
      NULL,
      0.044562,
      5.647078,
      0,
      NULL,
      '11-19-1997',
      NULL,
      ' 6-29-1998',
      NULL,
      1,
      0,
      1.780078,
      0.796774,
      0.677836,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      5.734674,
      NULL,
      NULL,
      0.081574,
      0.291043,
      9,
      NULL,
      2,
      0.905698,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.111228,
      3,
      3.474414,
      3.875687,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      2.087663,
      NULL,
      1,
      1,
      7.414815,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.037984,
      1.993547,
      0.449864,
      NULL,
      NULL,
      1,
      2.761671,
      3,
      3.491563,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      3.621432,
      1.446990,
      1.894327,
      0.797459,
      2,
      0,
      NULL,
      1,
      2.726188,
      1.406711,
      NULL,
      2.224072,
      NULL,
      3.788163,
      1.789613,
      1,
      1.307337,
      1.167631,
      0.052815,
      0.841083,
      0.721072,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      1.505942,
      1,
      NULL,
      0.071989,
      NULL,
      0.512354,
      8.725787,
      0,
      0.438259,
      NULL,
      4,
      1,
      NULL,
      0,
      56.865064,
      NULL,
      1,
      5.381200,
      NULL,
      56,
      54.607777,
      NULL,
      2.804427,
      NULL,
      '30004',
      '',
      '',
      1.122483,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      34,
      40.987984,
      6,
      0.768959,
      49.688327,
      17.263335,
      6,
      0,
      2,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.236979,
      NULL,
      NULL,
      3.767554,
      2.587975,
      2.710427,
      NULL,
      1,
      NULL,
      1.914761,
      NULL,
      NULL,
      3,
      NULL,
      1.786323,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.305456,
      0,
      NULL,
      NULL,
      9.208066,
      4,
      5,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.397220,
      1.782064,
      0.955638,
      NULL,
      1.538798,
      NULL,
      NULL,
      0.121655,
      0,
      1.668068,
      3.218756,
      1,
      0,
      1,
      2.016383,
      2.363609,
      1.564525,
      1,
      1,
      0,
      2.060060,
      NULL,
      0.826017,
      2,
      1.389008,
      NULL,
      0.054584,
      1,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.998208,
      4.840226,
      NULL,
      1.157688,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.345043,
      0,
      1.713422,
      NULL,
      NULL,
      2,
      0.816024,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.037964,
      NULL,
      NULL,
      0.213161,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.885929,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.441502,
      1,
      1.760490,
      NULL,
      NULL,
      NULL,
      3.896080,
      NULL,
      NULL,
      2,
      1,
      0.478791,
      0,
      NULL,
      NULL,
      1,
      0,
      1,
      2,
      3.441115,
      3.868013,
      NULL,
      2.962067,
      2,
      5,
      4,
      NULL,
      1.299081,
      1,
      3.217213,
      NULL,
      1.901655,
      2,
      NULL,
      2,
      1.766117,
      1,
      NULL,
      3,
      3.332320,
      8,
      6,
      2.033831,
      3.236989,
      3,
      3.935228,
      5.068710,
      4.554898,
      NULL,
      NULL,
      0,
      1,
      0.087376,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      10.117502,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.976079,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.322815,
      NULL,
      2.055885,
      NULL,
      1.377599,
      NULL,
      0,
      NULL,
      11,
      4.548490,
      NULL,
      NULL,
      1,
      4,
      1.682426,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2.815720,
      2,
      3,
      NULL,
      3,
      1.476627,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.083776,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.100979,
      NULL,
      NULL,
      1.867226,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.426172,
      NULL,
      0.519521,
      0,
      2.175239,
      NULL,
      0,
      0.357580,
      1.338212,
      NULL,
      1,
      1.514131,
      NULL,
      NULL,
      0,
      3.017703,
      2.170538,
      NULL,
      1.551809,
      1,
      0.954519,
      NULL,
      0.171854,
      0.422248,
      2.585153,
      NULL,
      0,
      1,
      3.013617,
      NULL,
      NULL,
      0.923076,
      0,
      NULL,
      15.084785,
      8,
      NULL,
      NULL,
      7.945566,
      NULL,
      2,
      8,
      1.686321,
      2,
      NULL,
      7,
      0,
      17,
      0,
      1.826335,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.815543,
      NULL,
      NULL,
      3.047358,
      2,
      1.066923,
      0,
      NULL,
      1.673756,
      271.643093,
      NULL,
      1,
      1.804671,
      NULL,
      1.115377,
      1.698288,
      0.538183,
      0.784381,
      3.423881,
      0,
      NULL,
      1,
      3.125405,
      NULL,
      0,
      0,
      1,
      1.868503,
      0,
      NULL,
      NULL,
      NULL,
      1.043710,
      NULL,
      1.536222,
      NULL,
      0.344545,
      NULL,
      1,
      NULL,
      134,
      NULL,
      1,
      31,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      0.125591,
      NULL,
      1.429684,
      NULL,
      3.288569,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.032377,
      NULL,
      0.407042,
      NULL,
      0,
      NULL,
      1.148650,
      NULL,
      0.671684,
      NULL,
      0,
      2,
      0.841337,
      0.654603,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.432036,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.444377,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      192,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.497779,
      NULL,
      NULL,
      0.223489,
      NULL,
      NULL,
      NULL,
      NULL,
      3.239998,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.703592,
      NULL,
      1.072074,
      NULL,
      0.693108,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      3.671078,
      NULL,
      0.579234,
      NULL,
      NULL,
      NULL,
      0.520686,
      NULL,
      1,
      NULL,
      0.862085,
      0,
      1.987634,
      33.072814,
      45,
      1.789491,
      NULL,
      NULL,
      NULL,
      1.209712,
      0.905530,
      2.489645,
      0,
      NULL,
      NULL,
      1,
      0.205987,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.325202,
      1,
      0.358841,
      2,
      3.042127,
      1,
      1,
      3.491326,
      0.117809,
      1.556079,
      NULL,
      0,
      1,
      0,
      0.450454,
      1,
      NULL,
      0,
      0,
      3,
      1.542501,
      0.351866,
      1,
      NULL,
      2,
      1,
      NULL,
      3.060191,
      1.577906,
      1,
      0.696149,
      2,
      0.347539,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.804942,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.294345,
      0.572014,
      0.205613,
      1.217164,
      0,
      0,
      7.632121,
      2.391757,
      7.303124,
      1.704493,
      NULL,
      NULL,
      5,
      80,
      2,
      3.175056,
      5,
      NULL,
      '13303',
      NULL,
      1,
      '',
      '',
      '',
      1.438224,
      '',
      '',
      NULL);
commit;
end;
/


