set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8010848';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-12-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      NULL,
      NULL,
      1.383626,
      2,
      1,
      '4000',
      3,
      3,
      NULL,
      34,
      ' 5- 7-1984',
      NULL,
      NULL,
      4.450512,
      2,
      0.180450,
      NULL,
      79,
      1.891034,
      114,
      72,
      NULL,
      NULL,
      NULL,
      NULL,
      3.022115,
      0.137715,
      NULL,
      0.737448,
      0,
      1,
      2,
      0.039277,
      0,
      NULL,
      NULL,
      11,
      3.659511,
      19,
      26,
      NULL,
      17.886649,
      4,
      3.568261,
      NULL,
      1.027493,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.695939,
      NULL,
      5,
      3.501829,
      3.809989,
      1.692097,
      1,
      1,
      0.277838,
      1.337079,
      1,
      NULL,
      1,
      0,
      0,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.138467,
      1.268496,
      1.382805,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.112486,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.701081,
      1,
      4.688960,
      0,
      4,
      1,
      1,
      1,
      0,
      0,
      0.984615,
      NULL,
      0,
      0.518049,
      0.271478,
      0,
      0,
      0.928765,
      1,
      NULL,
      1.359855,
      2.372595,
      1.774443,
      NULL,
      0,
      0,
      1,
      1,
      0,
      2,
      NULL,
      1.408620,
      NULL,
      4.115587,
      0,
      1,
      3.504784,
      2.853690,
      8,
      7,
      7.256024,
      1.632844,
      1,
      6.548984,
      1,
      0.473256,
      0,
      1.755062,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.369333,
      1.197241,
      1.994251,
      1.042129,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.531106,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.465181,
      1.528112,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.697469,
      0,
      NULL,
      0,
      1,
      1.752447,
      NULL,
      0,
      NULL,
      3.838545,
      1,
      NULL,
      NULL,
      NULL,
      2.983153,
      0.120994,
      1.367961,
      2.284772,
      3,
      1,
      1.802134,
      NULL,
      0.632306,
      3,
      2.893720,
      NULL,
      2.751561,
      3,
      1,
      NULL,
      NULL,
      NULL,
      0,
      3.430691,
      1.571169,
      1,
      0.238918,
      1.880626,
      0.575016,
      1.096486,
      1.959498,
      0,
      1,
      0.665183,
      1.542386,
      1,
      0.479054,
      NULL,
      2,
      1.783755,
      8,
      0.995548,
      2.480367,
      0.062457,
      0.828984,
      1,
      2,
      NULL,
      NULL,
      2.095600,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      3.540161,
      '01123',
      NULL,
      '43231',
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      3,
      30.588692,
      10.643833,
      NULL,
      0,
      24,
      50.983659,
      27.414973,
      5,
      NULL,
      0.373419,
      3.160966,
      1,
      NULL,
      NULL,
      NULL,
      5,
      0.922984,
      NULL,
      1,
      0,
      3.711172,
      2.411054,
      1.093463,
      0,
      NULL,
      NULL,
      1.241442,
      0.613015,
      1,
      0,
      NULL,
      NULL,
      1.800278,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.602216,
      0.508643,
      1,
      1,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0.598768,
      0.101340,
      NULL,
      NULL,
      NULL,
      0.774289,
      NULL,
      NULL,
      NULL,
      3.395695,
      0,
      1,
      0.554540,
      0.655522,
      1.481051,
      0.830484,
      NULL,
      NULL,
      1.407527,
      NULL,
      0,
      2,
      1.063311,
      0,
      0,
      0,
      0.824973,
      1.340897,
      3.856477,
      NULL,
      1.825524,
      1,
      0,
      1.641806,
      3.888194,
      0,
      0.871735,
      0,
      NULL,
      NULL,
      0,
      3,
      0,
      NULL,
      5,
      NULL,
      5.918996,
      NULL,
      NULL,
      NULL,
      NULL,
      1.311993,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1.908794,
      NULL,
      NULL,
      2,
      NULL,
      1.843193,
      NULL,
      NULL,
      6.973035,
      2,
      5.568253,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1,
      1.295257,
      1,
      1.602535,
      0.017805,
      0.507756,
      15.521423,
      1,
      0.125112,
      1,
      0.923293,
      6,
      NULL,
      0,
      3.692794,
      0,
      1.137789,
      1.018425,
      NULL,
      NULL,
      0,
      4.421372,
      4.704842,
      6.609075,
      NULL,
      7.378531,
      1.652443,
      7.664083,
      1,
      NULL,
      0.848635,
      0.836206,
      0.117452,
      3.357167,
      2.489241,
      3,
      0.265325,
      0.722318,
      2,
      8,
      5.613345,
      0.966440,
      3,
      2.822541,
      1.584174,
      0,
      0.197773,
      0.528848,
      NULL,
      NULL,
      NULL,
      0.903992,
      3.910988,
      5,
      6.706838,
      8.968879,
      5.637470,
      1,
      0,
      1,
      2.623980,
      4,
      1.235615,
      1.745506,
      0.097027,
      1,
      0.333482,
      1.261645,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.172558,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      15,
      NULL,
      NULL,
      0.636685,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1.312665,
      0.591118,
      1,
      NULL,
      NULL,
      4.076314,
      1.973616,
      NULL,
      NULL,
      1998.057662,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.258468,
      1.676271,
      NULL,
      NULL,
      0.450080,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.969523,
      NULL,
      NULL,
      17.240523,
      2.855624,
      NULL,
      NULL,
      10,
      11,
      NULL,
      NULL,
      1.696403,
      2,
      NULL,
      NULL,
      0,
      8.747862,
      NULL,
      NULL,
      7.090147,
      16,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      3.141752,
      18.889776,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      3,
      17.143756,
      81,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.668497,
      NULL,
      NULL,
      1.470519,
      4,
      6.918042,
      1,
      NULL,
      NULL,
      0,
      8,
      1.945979,
      663,
      NULL,
      NULL,
      1,
      1.130712,
      NULL,
      0,
      0,
      0.932303,
      2.989571,
      NULL,
      1.467277,
      1,
      NULL,
      1.773206,
      2,
      0.017584,
      1,
      1.011050,
      NULL,
      NULL,
      1.815997,
      NULL,
      1.772969,
      NULL,
      1.889954,
      NULL,
      1,
      NULL,
      0.974958,
      NULL,
      98.914896,
      NULL,
      2,
      23.491785,
      NULL,
      1,
      0.531694,
      NULL,
      NULL,
      1.883127,
      NULL,
      0,
      NULL,
      0.261713,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.713659,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.518382,
      NULL,
      0,
      NULL,
      0.125231,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.327785,
      0.552364,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.080432,
      NULL,
      1,
      NULL,
      1.890392,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.768359,
      NULL,
      0.921191,
      NULL,
      0,
      0,
      2,
      NULL,
      1,
      NULL,
      1.052234,
      NULL,
      NULL,
      NULL,
      1.896419,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.152563,
      3.183764,
      NULL,
      0.042577,
      NULL,
      1.107798,
      NULL,
      NULL,
      NULL,
      1.174980,
      1.993972,
      3.760466,
      NULL,
      0.254484,
      NULL,
      3.336960,
      NULL,
      490,
      NULL,
      1,
      NULL,
      2,
      NULL,
      0.121590,
      NULL,
      2,
      21,
      27,
      1.921882,
      2,
      NULL,
      0.774622,
      0,
      1,
      1,
      1.438921,
      0,
      NULL,
      0,
      NULL,
      3,
      3.814277,
      NULL,
      0,
      1.042143,
      1.259003,
      NULL,
      1,
      0.796133,
      1,
      0.513149,
      0.973517,
      NULL,
      0,
      1.176991,
      0.353099,
      1.314902,
      2.602498,
      1.565232,
      0.933790,
      NULL,
      0,
      NULL,
      0.560143,
      NULL,
      0,
      1.345466,
      1,
      1.454811,
      NULL,
      NULL,
      1.449401,
      1.613687,
      NULL,
      NULL,
      NULL,
      NULL,
      2.929683,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0.570649,
      NULL,
      1.627048,
      NULL,
      1.519990,
      NULL,
      NULL,
      NULL,
      0.962900,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.331005,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.749311,
      19.106424,
      NULL,
      NULL,
      0,
      1.780265,
      0,
      1.217258,
      0.405296,
      0.235732,
      0.807835,
      1,
      NULL,
      NULL,
      0,
      2.259783,
      50,
      61.437321,
      7,
      0,
      1,
      '10133',
      '43412',
      '34030',
      NULL,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


