set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6805689';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-6-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '0',
      NULL,
      NULL,
      NULL,
      3,
      0.897280,
      1,
      3,
      '4311',
      NULL,
      0.269550,
      NULL,
      NULL,
      ' 1-26-1989',
      7,
      NULL,
      NULL,
      2.839891,
      0.752695,
      NULL,
      24,
      0,
      148,
      167.933789,
      0,
      ' 0- 6-1988',
      '10-24-1998',
      ' 6-28-1990',
      NULL,
      NULL,
      2.480694,
      2.280803,
      1,
      NULL,
      NULL,
      0,
      1,
      6,
      9.334654,
      3,
      6.351800,
      25.293521,
      1.375375,
      NULL,
      NULL,
      5.182509,
      NULL,
      8,
      3.630812,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      6,
      NULL,
      1,
      0.826302,
      0,
      NULL,
      0.963547,
      NULL,
      0.550850,
      2,
      5.048152,
      4.738499,
      NULL,
      0.877872,
      3,
      0.515724,
      0.048819,
      0.344128,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      4,
      1,
      NULL,
      1,
      2,
      1.878065,
      0.828896,
      3.296116,
      3,
      1,
      2,
      2,
      NULL,
      1,
      1.614500,
      NULL,
      0.732495,
      NULL,
      0.017533,
      0,
      2.996864,
      6.301897,
      1.084999,
      0,
      1.495202,
      0,
      NULL,
      NULL,
      0.661393,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      0.774798,
      0,
      0,
      3,
      3.571352,
      0.334940,
      1,
      2.690335,
      0.670056,
      0.098516,
      1.770489,
      NULL,
      1.408277,
      NULL,
      1,
      NULL,
      0.920624,
      NULL,
      0,
      NULL,
      NULL,
      7,
      5,
      NULL,
      1,
      1,
      0.153589,
      NULL,
      1,
      NULL,
      1,
      1.711560,
      3,
      5,
      2,
      3,
      NULL,
      5.101090,
      1.288676,
      NULL,
      1.002418,
      0.656913,
      NULL,
      57,
      ' 3-22-1993',
      53.614559,
      0.367108,
      3,
      1,
      2.911475,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.157477,
      1,
      0,
      2,
      0,
      NULL,
      1.037305,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.779757,
      3,
      NULL,
      0,
      1.142469,
      3.781324,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.695569,
      NULL,
      2.776835,
      2.192520,
      0.267081,
      1,
      0.291122,
      4,
      NULL,
      0,
      NULL,
      0.117051,
      0.849542,
      NULL,
      NULL,
      NULL,
      1,
      1.005953,
      1.877595,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.263524,
      0.460765,
      1.257416,
      0,
      1,
      0,
      3.399702,
      NULL,
      0,
      1.109939,
      NULL,
      NULL,
      NULL,
      0.917819,
      1.558335,
      2,
      NULL,
      1.742766,
      6.323052,
      3.365629,
      0.052466,
      2.487696,
      1.308311,
      2.089698,
      NULL,
      NULL,
      1.635145,
      3,
      NULL,
      6.573237,
      1.804577,
      1,
      1.505948,
      0.369906,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.062987,
      1,
      1,
      0,
      0,
      NULL,
      1,
      6,
      7,
      NULL,
      4.227873,
      2.979597,
      1,
      NULL,
      1.118391,
      2,
      0.116568,
      NULL,
      1.272561,
      0,
      NULL,
      10,
      NULL,
      NULL,
      3,
      1.251013,
      6.792781,
      '04040',
      '20220',
      '01044',
      0.806660,
      '',
      '',
      '',
      0.903124,
      NULL,
      '',
      '',
      0,
      81,
      39.544169,
      19.601337,
      3.004579,
      68,
      0,
      0,
      4.178269,
      0.777144,
      0,
      2.247219,
      NULL,
      NULL,
      NULL,
      0,
      1.262842,
      0,
      1.268626,
      NULL,
      NULL,
      0.451173,
      2.822000,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      NULL,
      2.306858,
      NULL,
      0,
      1.127681,
      NULL,
      3,
      1.702674,
      0.857393,
      7.815039,
      5,
      0.027170,
      0.888064,
      NULL,
      NULL,
      NULL,
      1.504696,
      NULL,
      NULL,
      NULL,
      2,
      2,
      2,
      3,
      0.878175,
      3,
      0.299411,
      1,
      0,
      0,
      NULL,
      0.845184,
      3.879131,
      2,
      0.225414,
      2.384393,
      0.513070,
      NULL,
      3.396949,
      2.560955,
      0.363173,
      0,
      3.327963,
      NULL,
      NULL,
      3.674531,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.606067,
      5,
      5,
      6.107841,
      0.868248,
      0.884588,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.574388,
      NULL,
      NULL,
      2.785858,
      1.612877,
      1.576922,
      NULL,
      NULL,
      NULL,
      3.048615,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.157743,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.142710,
      NULL,
      NULL,
      1.035343,
      NULL,
      NULL,
      0.355122,
      NULL,
      NULL,
      1.742274,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      1.319901,
      1.355968,
      NULL,
      NULL,
      2.700290,
      NULL,
      NULL,
      7,
      5.437694,
      4,
      1,
      NULL,
      NULL,
      0.153352,
      2,
      NULL,
      1,
      NULL,
      NULL,
      3.844503,
      NULL,
      3.403987,
      0,
      4,
      4,
      1.029173,
      3.247774,
      3,
      0,
      NULL,
      NULL,
      0.667092,
      1,
      3,
      3,
      1,
      NULL,
      NULL,
      0,
      3,
      0.331381,
      NULL,
      NULL,
      2,
      3.465751,
      5.191291,
      0,
      0.320526,
      1.162409,
      NULL,
      0,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.092438,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.735115,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.093887,
      NULL,
      1,
      0.840424,
      2,
      0.556277,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.372842,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.010585,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.966844,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.780679,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.295776,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.773112,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.624927,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.430215,
      4,
      0.105857,
      1,
      NULL,
      NULL,
      0.191785,
      NULL,
      NULL,
      NULL,
      5,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12.032575,
      18,
      0,
      0.111229,
      NULL,
      2,
      1,
      2,
      1,
      3.751000,
      NULL,
      2.682067,
      1.151794,
      0.798861,
      1.808761,
      3,
      1.168947,
      0.155140,
      1.819283,
      3,
      NULL,
      2,
      NULL,
      3,
      NULL,
      1.160020,
      NULL,
      3.979383,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      149.028411,
      NULL,
      25,
      1,
      1.486782,
      5,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.923472,
      NULL,
      NULL,
      NULL,
      0.953738,
      NULL,
      0.837372,
      NULL,
      3,
      NULL,
      3,
      NULL,
      3.811850,
      NULL,
      NULL,
      NULL,
      0.448698,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.573421,
      NULL,
      0.472961,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.049569,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.509959,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2.249153,
      NULL,
      3.005231,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.512783,
      NULL,
      1,
      NULL,
      0,
      0.435736,
      3.529131,
      NULL,
      1.268165,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2.910641,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.377894,
      1.095293,
      NULL,
      NULL,
      NULL,
      1.392229,
      NULL,
      NULL,
      NULL,
      1.519171,
      0.731326,
      0.349437,
      NULL,
      NULL,
      NULL,
      1.632579,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.184051,
      1,
      1.366900,
      23.836163,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.425303,
      0,
      6.200972,
      1,
      0.844979,
      1,
      0,
      1.491225,
      0,
      0,
      NULL,
      1.921280,
      1.389222,
      NULL,
      1,
      1,
      NULL,
      1,
      0.899133,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      1,
      1.286475,
      NULL,
      3,
      2,
      NULL,
      NULL,
      0.856972,
      NULL,
      1.769968,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1.236533,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.596360,
      NULL,
      1.535312,
      NULL,
      0.022616,
      NULL,
      1.410145,
      NULL,
      3.275750,
      NULL,
      1,
      NULL,
      1.519605,
      NULL,
      2.595747,
      NULL,
      0,
      NULL,
      0.672149,
      NULL,
      1.525984,
      NULL,
      0.286854,
      NULL,
      1.716506,
      NULL,
      79,
      1.240375,
      NULL,
      1.055426,
      NULL,
      2,
      NULL,
      1.094003,
      NULL,
      4.246743,
      4.935627,
      NULL,
      NULL,
      NULL,
      NULL,
      19,
      NULL,
      3.926931,
      1,
      3.055956,
      NULL,
      '12243',
      '33410',
      1.933434,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


