set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8807779';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-5-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '4',
      NULL,
      NULL,
      NULL,
      3.014450,
      1.384467,
      2,
      3,
      '0130',
      3.840356,
      1,
      NULL,
      NULL,
      ' 0- 6-1978',
      14,
      NULL,
      2.140351,
      NULL,
      1,
      NULL,
      43,
      4,
      81.619618,
      58,
      0,
      NULL,
      ' 3-28-1998',
      ' 0-22-1997',
      NULL,
      NULL,
      0.776620,
      1.713432,
      0.420661,
      2.500869,
      1.747741,
      0,
      1.196883,
      118,
      NULL,
      7,
      4.664563,
      117,
      94.489514,
      1,
      7.717286,
      10.957288,
      14,
      0.617010,
      0,
      5,
      0,
      0,
      1.846322,
      0.768844,
      1.372955,
      1.541058,
      1,
      NULL,
      NULL,
      0.129115,
      16.488288,
      19,
      2.571834,
      7.020922,
      1,
      NULL,
      0,
      2.188911,
      1.531251,
      NULL,
      0.020030,
      NULL,
      NULL,
      0.810848,
      1.199181,
      8.151023,
      NULL,
      2.518700,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.802746,
      NULL,
      1,
      0.946217,
      1.164507,
      0.923180,
      1.480533,
      NULL,
      1.998425,
      1,
      0,
      1.720472,
      0,
      1,
      1,
      1,
      1.598744,
      0,
      0.464747,
      0,
      0,
      1,
      4.673517,
      3.072606,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.424915,
      NULL,
      NULL,
      5.420616,
      7,
      NULL,
      0.784389,
      6.571631,
      0.479075,
      NULL,
      1,
      0.925217,
      0,
      1.583058,
      1,
      0.659102,
      1,
      2.309516,
      NULL,
      4,
      0.164828,
      0.131410,
      NULL,
      4,
      NULL,
      0.463203,
      NULL,
      6.232673,
      1,
      8,
      NULL,
      5.919710,
      9.966027,
      1,
      7,
      6.505723,
      11,
      0,
      6,
      3,
      4,
      0,
      10,
      NULL,
      NULL,
      7,
      9,
      2,
      NULL,
      4,
      1,
      ' 9- 6-1978',
      1000.452286,
      ' 8-14-2000',
      1314,
      0.499969,
      1,
      NULL,
      2.344191,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5.520907,
      4.500449,
      0,
      0.317237,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.022063,
      0,
      0.496536,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.962796,
      0.760764,
      0.444935,
      0,
      0.397698,
      NULL,
      0.932383,
      0,
      56.622466,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      17,
      NULL,
      18,
      4.122465,
      0.657399,
      3,
      '21010',
      '',
      NULL,
      1,
      '',
      '',
      '',
      1.850021,
      '',
      '',
      '',
      0,
      24,
      795.267899,
      NULL,
      1.027528,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      9,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3.069167,
      NULL,
      NULL,
      18,
      NULL,
      NULL,
      13,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      15.051274,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      12.598217,
      NULL,
      NULL,
      16.079409,
      NULL,
      NULL,
      4,
      4.492780,
      9,
      NULL,
      1.819977,
      NULL,
      NULL,
      NULL,
      0.030996,
      NULL,
      NULL,
      NULL,
      NULL,
      18.171121,
      NULL,
      NULL,
      9.176464,
      11.704008,
      0.948105,
      13.611286,
      5.619875,
      2,
      NULL,
      1.577476,
      0,
      0,
      0.035438,
      0.715447,
      1,
      1.385017,
      0,
      1,
      0.987899,
      0,
      0.716454,
      1,
      1.799443,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4.182599,
      2,
      1,
      1,
      1.941751,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.978346,
      11,
      3.293322,
      0,
      8.735158,
      3,
      0.011890,
      15,
      NULL,
      NULL,
      NULL,
      NULL,
      0.199482,
      0,
      0,
      0.136322,
      NULL,
      2,
      1,
      NULL,
      NULL,
      4.105886,
      3.141820,
      2.234051,
      0.828848,
      NULL,
      NULL,
      1.661318,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.883664,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.117788,
      4.928709,
      0,
      1.500657,
      NULL,
      NULL,
      5,
      0,
      1,
      7,
      2.864174,
      4.336593,
      1.568877,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.974778,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3.279505,
      18,
      14,
      NULL,
      6.860218,
      3.444751,
      1,
      NULL,
      NULL,
      0,
      2,
      NULL,
      6.103812,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4.935985,
      5.696813,
      1,
      1.799997,
      0,
      0,
      NULL,
      2.417162,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.067258,
      NULL,
      NULL,
      1.067509,
      NULL,
      NULL,
      0.089482,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      1,
      0.041134,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.141919,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.019618,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.364560,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.054409,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.999943,
      NULL,
      NULL,
      1.725934,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.990999,
      NULL,
      0,
      19128,
      1047.359548,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      0.325008,
      0,
      1.003873,
      1,
      0.735503,
      1,
      1.863391,
      0.703162,
      1.391654,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.883903,
      1.213437,
      NULL,
      11.216602,
      NULL,
      14.405226,
      18.736012,
      NULL,
      13.242598,
      NULL,
      NULL,
      NULL,
      14.541677,
      NULL,
      NULL,
      NULL,
      NULL,
      18.482255,
      NULL,
      NULL,
      5.533295,
      9,
      NULL,
      18,
      16.831565,
      NULL,
      14.838901,
      NULL,
      NULL,
      18.253447,
      16.963624,
      NULL,
      NULL,
      NULL,
      NULL,
      3.914213,
      1,
      1.313984,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.992707,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.294886,
      NULL,
      1.501428,
      2.955386,
      14,
      NULL,
      3.612521,
      NULL,
      NULL,
      NULL,
      0.013872,
      NULL,
      3.218017,
      '12240',
      '',
      '',
      0,
      '',
      NULL,
      '',
      1.852325,
      '',
      '',
      '');
commit;
end;
/


