set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7938212';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-11-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '1',
      NULL,
      NULL,
      '2130343',
      3.419786,
      0,
      0,
      3,
      '3242',
      3.395626,
      2,
      0,
      7.995841,
      '10-19-1995',
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      ' 4-20-1980',
      38,
      NULL,
      232.303877,
      17,
      1,
      ' 5- 2-2000',
      ' 2- 8-1974',
      ' 0-13-1989',
      3,
      0.276249,
      2,
      3.538015,
      NULL,
      3,
      1,
      1,
      1,
      86.537428,
      7.119725,
      2.066171,
      5.322993,
      15,
      6,
      5.482644,
      22.873468,
      0.114666,
      2.546715,
      7,
      1.045667,
      NULL,
      1.213730,
      1.202424,
      1.018502,
      0,
      NULL,
      1.766293,
      1.802627,
      1,
      NULL,
      14,
      3.378261,
      3.607835,
      0,
      5.264404,
      1,
      0,
      0.205273,
      1.149390,
      5,
      0.404959,
      0,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0,
      2,
      3.657590,
      0.138174,
      1,
      NULL,
      NULL,
      0.785335,
      NULL,
      NULL,
      0,
      NULL,
      0.758202,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.481044,
      1.343897,
      0.075037,
      0.902492,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.274706,
      1.078135,
      1.024986,
      3.125685,
      2,
      0,
      0,
      NULL,
      1.386358,
      1,
      0,
      1.422240,
      0,
      NULL,
      1,
      0,
      0,
      1.414284,
      NULL,
      1,
      3.611875,
      1,
      0.915691,
      5,
      4.701496,
      3.647551,
      3,
      3.194954,
      4.806761,
      5.835232,
      5,
      1.786052,
      2.062884,
      0.107552,
      1.140571,
      10.958646,
      5,
      10.746546,
      NULL,
      NULL,
      5.023666,
      8.238655,
      5,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      937.977651,
      ' 8-23-1976',
      209.507613,
      1,
      0.393616,
      1,
      5,
      1.908872,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.027592,
      NULL,
      0.374112,
      NULL,
      0.786724,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.416452,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.326805,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.624165,
      1.138112,
      NULL,
      0.567160,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.337829,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.302727,
      1.280807,
      1.347679,
      NULL,
      0.799826,
      0,
      2,
      245,
      NULL,
      3,
      NULL,
      1152,
      233,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      38,
      91,
      169.508588,
      175.795380,
      170,
      133,
      0,
      NULL,
      0.340877,
      NULL,
      1.683237,
      1,
      NULL,
      12.651477,
      NULL,
      1.853862,
      4,
      NULL,
      5,
      8.280114,
      3,
      1,
      NULL,
      2,
      6,
      2.613559,
      NULL,
      1,
      65,
      2,
      1.982375,
      NULL,
      47,
      2,
      NULL,
      4.888663,
      1.487632,
      0.915493,
      '30220',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      '20220',
      '',
      NULL,
      2,
      0.797866,
      118,
      12.185779,
      0,
      34,
      15,
      40,
      9,
      NULL,
      3.903071,
      NULL,
      NULL,
      2,
      1.024863,
      0.577068,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.390366,
      1,
      0,
      0,
      0.277616,
      3,
      0,
      3,
      3.999218,
      3.898519,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.432154,
      NULL,
      NULL,
      1.160869,
      NULL,
      NULL,
      0.048472,
      0,
      0,
      3,
      7,
      NULL,
      1,
      1.874541,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      2,
      0,
      3.328440,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.870088,
      1,
      1,
      2,
      NULL,
      0,
      1.083755,
      1.951233,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.098165,
      2,
      2,
      2,
      1,
      0,
      NULL,
      NULL,
      2,
      NULL,
      1,
      0.836787,
      2,
      3.883905,
      1.495482,
      NULL,
      NULL,
      5.959013,
      0.347130,
      1,
      2,
      1,
      0,
      NULL,
      1,
      0.372913,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.718624,
      3,
      0.660983,
      2,
      NULL,
      0,
      NULL,
      0.947172,
      0,
      1.743347,
      1,
      NULL,
      NULL,
      4.177149,
      9,
      NULL,
      1.162766,
      5.755249,
      7.868756,
      5,
      7,
      NULL,
      NULL,
      3.279024,
      2.312250,
      0,
      0.267462,
      1.700155,
      2,
      2.585840,
      10,
      NULL,
      6,
      2,
      1.283001,
      3,
      8.263410,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.731030,
      1.772101,
      2,
      8.451223,
      7.473112,
      1,
      6.853560,
      10,
      3.225063,
      2,
      1,
      5,
      0,
      0,
      0.762665,
      1.069437,
      NULL,
      2.276323,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.308298,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.365201,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.071283,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      1.181850,
      0.673061,
      1.435889,
      1.445574,
      3,
      3.867997,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      1.674700,
      NULL,
      NULL,
      NULL,
      3.187720,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.591024,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.534517,
      3,
      NULL,
      NULL,
      1,
      3.500902,
      NULL,
      NULL,
      0.994382,
      0,
      NULL,
      NULL,
      3,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6,
      7.865019,
      NULL,
      NULL,
      1.527658,
      NULL,
      2,
      7,
      0,
      129,
      136.520049,
      1.371323,
      3,
      1.371263,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.035143,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      139,
      1.398686,
      160,
      26.270196,
      0.672465,
      3,
      0,
      0.847505,
      1.784236,
      0.566489,
      NULL,
      NULL,
      0,
      NULL,
      1.644486,
      3.624538,
      1,
      0,
      NULL,
      0.200317,
      NULL,
      2.277357,
      NULL,
      0.774024,
      NULL,
      0,
      NULL,
      1.591729,
      NULL,
      1.617833,
      NULL,
      1,
      NULL,
      1.068486,
      NULL,
      0.384069,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.928676,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      2,
      0.753007,
      1.879372,
      1,
      3.493071,
      0,
      1,
      1.987754,
      0.807676,
      0.042818,
      3,
      1.414565,
      1.011497,
      NULL,
      0,
      0.167804,
      1,
      NULL,
      0,
      2,
      1.403305,
      0.416546,
      0.101974,
      0,
      NULL,
      2,
      0,
      0,
      0.168194,
      0,
      1.564868,
      3,
      0.024815,
      NULL,
      1.948994,
      1.347488,
      NULL,
      1.539416,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.462972,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.667888,
      1,
      NULL,
      0,
      6.467914,
      1.967650,
      NULL,
      2,
      1.978298,
      1.323805,
      NULL,
      29.235985,
      NULL,
      0.243475,
      2.402106,
      '22322',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      2,
      NULL,
      NULL,
      '');
commit;
end;
/


