set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000208';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-7-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '1',
      NULL,
      NULL,
      '1340234',
      3,
      1,
      2,
      1,
      '2441',
      0.493130,
      2.938582,
      4.057073,
      63,
      ' 7-14-2002',
      12.673323,
      NULL,
      2,
      1.651472,
      NULL,
      ' 2- 3-1997',
      39.472631,
      0.215396,
      NULL,
      11,
      4.418393,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.703867,
      NULL,
      1,
      3,
      NULL,
      0,
      0.961034,
      199.764779,
      10,
      NULL,
      5,
      21.378405,
      24,
      1.614993,
      12.904751,
      NULL,
      0,
      1,
      0.162427,
      0,
      0,
      NULL,
      1.014048,
      1.533998,
      0,
      NULL,
      1,
      1,
      0,
      0.285065,
      6.536330,
      3,
      2,
      0,
      NULL,
      1.262796,
      1,
      1,
      0,
      1.281335,
      1.052158,
      NULL,
      1.805996,
      0,
      1.972833,
      0,
      NULL,
      NULL,
      0.997701,
      NULL,
      0.187787,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.783069,
      NULL,
      0.329884,
      0.708517,
      0.325423,
      0.182346,
      NULL,
      0,
      3.573797,
      0.191623,
      0.223282,
      0.486422,
      0.926407,
      NULL,
      1,
      0.027352,
      2,
      0.966314,
      5.515739,
      0.143186,
      1,
      1,
      0,
      0.358337,
      NULL,
      1.391951,
      NULL,
      NULL,
      0.202910,
      NULL,
      NULL,
      0,
      0,
      1,
      1.251613,
      0.938638,
      0,
      3.912028,
      0.737117,
      NULL,
      0,
      0.119916,
      NULL,
      0.373429,
      3.558147,
      0.623015,
      1.059806,
      NULL,
      1,
      0,
      NULL,
      0,
      6,
      NULL,
      2,
      7,
      0.363395,
      NULL,
      NULL,
      3,
      2.031030,
      NULL,
      7,
      2,
      9,
      0.802542,
      NULL,
      6.761376,
      6.026658,
      0.734029,
      4,
      6.538447,
      NULL,
      0,
      8,
      6.454146,
      2.861810,
      2.485779,
      1.815251,
      ' 6- 5-1993',
      290.605933,
      NULL,
      NULL,
      2.014877,
      1,
      0.711435,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.779672,
      1,
      1,
      1.732397,
      0,
      0,
      0.518269,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.041329,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.912178,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.779097,
      0,
      1.680902,
      0,
      1.854331,
      0.048066,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.367352,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.730047,
      0,
      1.235889,
      0,
      0.490434,
      1.645634,
      NULL,
      2.457037,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.439603,
      1,
      1,
      3,
      2.942544,
      1,
      2,
      0,
      3,
      2.800125,
      3,
      2.470391,
      3.813372,
      2.491339,
      1,
      3.866565,
      1,
      1.886229,
      5,
      NULL,
      0,
      0.368401,
      1.573989,
      1,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      1.940793,
      6.805427,
      7.126141,
      NULL,
      2.763386,
      4,
      1.596221,
      2.282009,
      2.605139,
      NULL,
      1,
      NULL,
      42.645460,
      NULL,
      0.306470,
      43.132183,
      NULL,
      NULL,
      NULL,
      NULL,
      0.772493,
      1,
      '10114',
      NULL,
      NULL,
      1,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      2.397158,
      32.239075,
      NULL,
      40,
      1.135222,
      NULL,
      0,
      3.540140,
      1,
      2,
      2,
      2.088599,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      3,
      0.266837,
      0.352974,
      3.932262,
      0.157355,
      0.803591,
      0.592346,
      0.314981,
      3,
      NULL,
      2,
      2.259365,
      3,
      0.540481,
      0,
      NULL,
      0,
      2,
      3,
      0,
      0,
      1,
      0,
      NULL,
      3.433403,
      1,
      NULL,
      11.461317,
      3,
      3.282523,
      0.813841,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.523038,
      0.522223,
      0,
      1.274320,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      2,
      NULL,
      0.761563,
      0,
      0.454183,
      0,
      1.450683,
      3,
      1,
      0,
      2.557567,
      NULL,
      1,
      0.119377,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.456314,
      NULL,
      1.673231,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      2.666413,
      1,
      2.545773,
      3,
      0,
      NULL,
      3,
      1,
      1,
      NULL,
      NULL,
      0.193904,
      3,
      0.639682,
      1,
      NULL,
      NULL,
      0,
      2.978612,
      0,
      3.559510,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.853402,
      1.752461,
      1.550767,
      0.748830,
      NULL,
      NULL,
      4,
      5.348065,
      1.888635,
      2.276218,
      3,
      NULL,
      0.929444,
      NULL,
      NULL,
      3,
      7,
      5,
      5.574743,
      6,
      5.493397,
      NULL,
      NULL,
      NULL,
      1.228460,
      0.969746,
      0,
      NULL,
      2.718122,
      1.372131,
      NULL,
      0,
      1.339365,
      8,
      NULL,
      1.121622,
      NULL,
      2.765259,
      3.830530,
      1,
      1.390421,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      6.120746,
      NULL,
      6,
      4,
      NULL,
      0.691912,
      5.137589,
      4.437194,
      0,
      0.678749,
      NULL,
      1.598481,
      1.462633,
      1.431064,
      NULL,
      NULL,
      1.682733,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.727094,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.213752,
      NULL,
      NULL,
      10.656625,
      NULL,
      NULL,
      0.802528,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.334622,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      1.666605,
      NULL,
      NULL,
      NULL,
      3.176906,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.427457,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.358656,
      0,
      NULL,
      NULL,
      3.292731,
      1.004522,
      NULL,
      NULL,
      0.745700,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.084082,
      1.007829,
      NULL,
      NULL,
      NULL,
      0.146832,
      NULL,
      NULL,
      11.661198,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.128658,
      47.855211,
      NULL,
      NULL,
      3.340456,
      1.658409,
      1.313639,
      NULL,
      NULL,
      0.435909,
      NULL,
      NULL,
      0.957808,
      NULL,
      NULL,
      1.814497,
      NULL,
      NULL,
      0,
      NULL,
      0,
      397,
      32,
      0,
      0.305473,
      1,
      0,
      1.577497,
      0,
      0,
      1.794555,
      1,
      NULL,
      1,
      3,
      0,
      NULL,
      0.045850,
      1.167622,
      NULL,
      1.239347,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.463608,
      9.221101,
      54,
      0.894542,
      0.867693,
      0.591420,
      NULL,
      1.190390,
      NULL,
      0.007620,
      NULL,
      0.192465,
      NULL,
      0.834313,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.884317,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.918576,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.183249,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.048662,
      1.370635,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.408917,
      1.268781,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.604732,
      NULL,
      0.106629,
      NULL,
      0,
      NULL,
      1,
      0,
      1.553683,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.478427,
      3.990838,
      NULL,
      3.258787,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.448124,
      1.512530,
      3.809420,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      2,
      3,
      1.943568,
      NULL,
      1.754107,
      3.400615,
      NULL,
      788.252441,
      NULL,
      0.851569,
      1,
      NULL,
      0,
      1.342225,
      1.554427,
      0.555489,
      NULL,
      31,
      3.481617,
      0,
      0.590356,
      7.292242,
      4.957832,
      0,
      1,
      3,
      NULL,
      NULL,
      2.418779,
      4,
      0,
      1.904319,
      2,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.542672,
      NULL,
      0.661988,
      NULL,
      1.273222,
      0,
      1,
      0,
      1,
      3,
      0.215549,
      0.325122,
      2.878638,
      2,
      2,
      0,
      NULL,
      3.722623,
      1,
      0,
      0.980136,
      1,
      3.343312,
      3.200585,
      3,
      1.530728,
      1.762485,
      3,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.403780,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      3,
      NULL,
      3.976851,
      NULL,
      0,
      0.287214,
      31,
      66.539068,
      1,
      0,
      2.821508,
      NULL,
      '14434',
      '04041',
      1.532170,
      '',
      '',
      '',
      2,
      '022',
      '',
      '');
commit;
end;
/


