set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9318626';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-7-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      '0002110',
      0.972948,
      NULL,
      5,
      1,
      '4334',
      3.075192,
      0,
      NULL,
      NULL,
      ' 6-29-1997',
      59,
      NULL,
      NULL,
      0,
      1,
      ' 0-12-1984',
      22,
      0,
      76,
      100.103508,
      0.062542,
      ' 2-17-1990',
      '10-16-1977',
      ' 5- 1-2000',
      1.151280,
      NULL,
      1,
      0,
      0,
      0,
      0,
      1.763638,
      NULL,
      14.871392,
      0,
      8.395665,
      3.777552,
      12,
      19.864845,
      9,
      3.415837,
      NULL,
      2,
      NULL,
      1.130630,
      1,
      1.861184,
      1.047900,
      NULL,
      1,
      0.789596,
      1.835121,
      0.200018,
      0.915539,
      NULL,
      NULL,
      6.300185,
      3,
      0.067359,
      1.822961,
      1.008330,
      0.924405,
      0.331671,
      0,
      0.031692,
      1,
      0,
      1.605938,
      1,
      1,
      NULL,
      1.607972,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.339270,
      2,
      NULL,
      0.440836,
      0,
      0.342443,
      0,
      1.283160,
      0.083881,
      3,
      1.915348,
      0,
      1,
      NULL,
      1.583229,
      NULL,
      NULL,
      1.580109,
      0,
      1,
      1.231177,
      3.296919,
      NULL,
      4,
      0.899963,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.325916,
      1.848459,
      0.910207,
      2.958603,
      0.870335,
      NULL,
      NULL,
      0,
      1.021936,
      1,
      0.751075,
      1.867898,
      NULL,
      0.941904,
      1,
      0,
      0.470603,
      NULL,
      NULL,
      1,
      1.562031,
      1.850434,
      0.924074,
      NULL,
      0.534622,
      1.139109,
      1,
      1,
      NULL,
      NULL,
      1,
      1,
      1.975107,
      0,
      NULL,
      3,
      3,
      4.735233,
      2,
      1.332760,
      3,
      NULL,
      1,
      0.147174,
      8.989461,
      NULL,
      0.846651,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.249608,
      0,
      0.338171,
      0.151339,
      NULL,
      1.466073,
      0.715357,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      204.790076,
      0.609756,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.799987,
      1,
      1,
      2,
      0.563701,
      0,
      0.130496,
      0,
      0.391719,
      3.655153,
      3,
      1.004029,
      NULL,
      3,
      0.089787,
      2,
      0.084795,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.816268,
      1.354608,
      0.603589,
      1,
      NULL,
      0,
      0.723017,
      0,
      29.721673,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      2,
      1,
      2,
      3,
      2.063284,
      1.818975,
      3,
      3,
      3,
      NULL,
      3.171570,
      16.773344,
      2,
      NULL,
      183.881896,
      172.279152,
      159,
      186.934447,
      6.231929,
      1.822881,
      NULL,
      NULL,
      92,
      NULL,
      NULL,
      1.488610,
      0,
      11.892632,
      1,
      8.270024,
      5,
      NULL,
      NULL,
      8.343119,
      0,
      4.796521,
      0.428865,
      5.466004,
      1.100379,
      1.047064,
      1.716351,
      45.443970,
      0,
      1.410796,
      NULL,
      NULL,
      19,
      NULL,
      NULL,
      1.962939,
      3.437162,
      '32001',
      NULL,
      '',
      3,
      '23142',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      2.614597,
      4,
      81,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.615716,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.149817,
      NULL,
      NULL,
      1.067710,
      NULL,
      NULL,
      0.407938,
      NULL,
      NULL,
      1.262092,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.253605,
      NULL,
      NULL,
      0.742807,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.431036,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      0.842752,
      NULL,
      NULL,
      1.576331,
      NULL,
      NULL,
      1.782882,
      0,
      1,
      NULL,
      NULL,
      2.244557,
      2,
      1,
      3.057953,
      0,
      2,
      1,
      3,
      3.162755,
      3,
      0,
      0.237331,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.077147,
      NULL,
      NULL,
      2.517864,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.611769,
      NULL,
      NULL,
      NULL,
      2,
      1.782406,
      NULL,
      NULL,
      NULL,
      NULL,
      1.198491,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.720987,
      1,
      4.574789,
      0.414258,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.053336,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.602106,
      NULL,
      NULL,
      0.444244,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.405200,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.365242,
      NULL,
      NULL,
      1.833341,
      NULL,
      NULL,
      0.594024,
      NULL,
      NULL,
      NULL,
      3.136598,
      3,
      0,
      2.013742,
      1.320355,
      5,
      6.212456,
      4,
      2,
      2.008079,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.363679,
      NULL,
      3.298598,
      2.750371,
      1,
      2.439120,
      4.708996,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.976287,
      1.326383,
      0.732331,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.272940,
      0.231272,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.173455,
      NULL,
      NULL,
      1.063349,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.902685,
      NULL,
      NULL,
      0.138797,
      NULL,
      0,
      239,
      5.196953,
      1,
      NULL,
      0,
      1,
      0.037914,
      0,
      1,
      0.153715,
      1,
      0,
      NULL,
      1.365490,
      0.137992,
      0.990768,
      0.338282,
      0.817677,
      1.152560,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.399489,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.100043,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.111175,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.110521,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.476439,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.305548,
      0.341146,
      NULL,
      2.109894,
      NULL,
      1.008614,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.861268,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.051175,
      1,
      2,
      NULL,
      NULL,
      0,
      2.545642,
      9.295569,
      0.334626,
      1.951395,
      1,
      1,
      NULL,
      NULL,
      1.636270,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.485287,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.013806,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.453685,
      NULL,
      NULL,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.262605,
      NULL,
      NULL,
      NULL,
      2.933058,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.184789,
      NULL,
      1.953293,
      NULL,
      NULL,
      NULL,
      1.369382,
      NULL,
      2.931213,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.485332,
      1,
      1.537606,
      NULL,
      1,
      NULL,
      0.771909,
      NULL,
      2,
      NULL,
      2,
      0,
      NULL,
      NULL,
      69.406507,
      NULL,
      0,
      1,
      2.095449,
      '42134',
      '12420',
      '',
      3.035788,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


