set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6711972';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-9-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '0',
      NULL,
      NULL,
      '0410032',
      1.639115,
      1,
      NULL,
      1,
      NULL,
      2.062746,
      NULL,
      NULL,
      3.547324,
      ' 9- 5-1988',
      34.376065,
      NULL,
      NULL,
      NULL,
      0,
      '10- 5-2000',
      93.031114,
      NULL,
      284,
      194,
      10,
      NULL,
      NULL,
      ' 9- 7-1987',
      2.733998,
      1,
      0,
      NULL,
      0,
      3,
      NULL,
      NULL,
      1,
      13,
      9,
      NULL,
      7.907265,
      16.048474,
      6.489245,
      4.918208,
      2,
      3,
      3.680082,
      10,
      1,
      1.685145,
      2.215935,
      1,
      0.944495,
      0.840568,
      NULL,
      1,
      0,
      0,
      1.821855,
      3,
      2,
      0,
      0.362850,
      NULL,
      0.403206,
      0.489868,
      1,
      1.127281,
      NULL,
      2,
      0.704072,
      NULL,
      1,
      NULL,
      0,
      3.010148,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.099504,
      0,
      NULL,
      3,
      1.482964,
      0.443264,
      1,
      1.700474,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.732294,
      0.393740,
      1,
      1.270751,
      3,
      1.532625,
      NULL,
      1,
      1.308606,
      1,
      0,
      3,
      0.043399,
      NULL,
      0.602012,
      1,
      1.737006,
      1,
      1.113417,
      NULL,
      0.547231,
      4,
      2,
      5,
      3,
      NULL,
      2,
      NULL,
      NULL,
      4.715168,
      7,
      1.414451,
      3,
      1,
      2.120779,
      5.319295,
      10.931009,
      NULL,
      0,
      NULL,
      1.827526,
      NULL,
      1.888811,
      5,
      6,
      10,
      5,
      0.829162,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.834488,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.815002,
      1.255297,
      0,
      2.695500,
      7.635493,
      NULL,
      3.320703,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.789169,
      NULL,
      NULL,
      NULL,
      NULL,
      0.580469,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      0,
      NULL,
      NULL,
      0,
      10.544905,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.749004,
      0.438112,
      0,
      0,
      0.352559,
      0.359959,
      1,
      NULL,
      1,
      0.427535,
      NULL,
      NULL,
      NULL,
      1.127578,
      0,
      2,
      2,
      1,
      3,
      0,
      3.828947,
      1.205132,
      3.186874,
      0,
      1,
      0.882588,
      1.978708,
      1.549279,
      NULL,
      0,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      1.858332,
      1.443214,
      3,
      0.959055,
      2,
      1.952924,
      NULL,
      3,
      0.377554,
      0,
      5.517723,
      5.683999,
      NULL,
      0,
      NULL,
      0,
      2,
      0,
      1,
      1.390475,
      1,
      54.880223,
      1.809668,
      0.448508,
      90,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1.070058,
      '31043',
      '',
      '',
      0.761784,
      '',
      '',
      '',
      5,
      NULL,
      '1021',
      '',
      1,
      45.923955,
      34,
      23,
      0.250249,
      19.783738,
      11,
      5.881745,
      1.954789,
      2,
      1.978289,
      3,
      1.172460,
      2,
      1,
      0.384550,
      3.588751,
      1.914916,
      0,
      NULL,
      NULL,
      0.812686,
      NULL,
      NULL,
      3,
      2.506213,
      3.258045,
      2,
      NULL,
      NULL,
      0.662940,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.827271,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      6.890536,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.988200,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.967523,
      NULL,
      NULL,
      0.735063,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.194228,
      3.485470,
      0,
      0.886889,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.157515,
      0.326936,
      NULL,
      0.398202,
      2,
      0.748729,
      2,
      1.053547,
      0,
      0,
      NULL,
      NULL,
      2.906982,
      1.474287,
      3,
      2,
      1.870269,
      0,
      NULL,
      NULL,
      NULL,
      3.063659,
      NULL,
      0.907824,
      NULL,
      NULL,
      NULL,
      1.938472,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.403072,
      NULL,
      NULL,
      1.571809,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.622254,
      3,
      0.932864,
      0.537039,
      3,
      1,
      6.306664,
      0.745757,
      0.286516,
      5,
      5.969291,
      8.722166,
      0,
      1.787253,
      1.936793,
      0,
      1,
      0,
      0,
      3.193965,
      0,
      NULL,
      1.031698,
      1,
      9,
      3.518158,
      3.666395,
      0,
      2,
      NULL,
      0.247171,
      1,
      NULL,
      1.796205,
      NULL,
      NULL,
      0.281433,
      2,
      NULL,
      1,
      4.087784,
      7,
      9,
      NULL,
      6.129632,
      0,
      0,
      7,
      0,
      1.062778,
      NULL,
      0,
      1,
      2,
      NULL,
      NULL,
      0.462678,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.672179,
      NULL,
      NULL,
      1.945769,
      NULL,
      NULL,
      0.924025,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.819102,
      NULL,
      NULL,
      4.513590,
      NULL,
      NULL,
      2.910125,
      0,
      3,
      NULL,
      1.046018,
      2.652958,
      1.382727,
      NULL,
      NULL,
      0,
      3.858084,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.146288,
      NULL,
      NULL,
      NULL,
      1.811771,
      NULL,
      NULL,
      NULL,
      0.478025,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      3.361588,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.467777,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.819404,
      1.316980,
      NULL,
      NULL,
      2,
      0.611406,
      NULL,
      NULL,
      1.226818,
      2,
      NULL,
      NULL,
      3.185468,
      0.145738,
      NULL,
      NULL,
      0,
      0.638784,
      NULL,
      NULL,
      3.494838,
      1,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      0.312597,
      NULL,
      NULL,
      NULL,
      0,
      40.555759,
      NULL,
      3.207019,
      451,
      21,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.413357,
      NULL,
      NULL,
      1.147396,
      NULL,
      NULL,
      2.577483,
      23.355369,
      0,
      3565.171979,
      96,
      1.385122,
      3.561749,
      NULL,
      2.050897,
      0.800983,
      1,
      0,
      2.877520,
      0,
      NULL,
      0,
      0.634212,
      0,
      1.461370,
      0,
      0,
      1,
      0.082876,
      NULL,
      1,
      NULL,
      2,
      NULL,
      2.811687,
      NULL,
      0,
      NULL,
      1.374530,
      NULL,
      78,
      NULL,
      3.637641,
      41.017942,
      7,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.366502,
      NULL,
      0.772685,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.838197,
      NULL,
      0.724276,
      NULL,
      2,
      NULL,
      NULL,
      1.021001,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.209888,
      7.608422,
      5.168207,
      10.449754,
      5.271241,
      0.413032,
      3,
      1.438575,
      19.771727,
      NULL,
      NULL,
      NULL,
      1.668487,
      1.436883,
      1.771208,
      0.112018,
      2.284080,
      NULL,
      0.785676,
      2.462308,
      NULL,
      0.300485,
      3,
      0.062648,
      1,
      0.647937,
      NULL,
      0.358777,
      NULL,
      0.706816,
      2,
      NULL,
      NULL,
      1.159718,
      0.598545,
      2.177901,
      1,
      0,
      NULL,
      0,
      1,
      0.184084,
      1,
      NULL,
      NULL,
      0,
      3.510517,
      0.282665,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.513518,
      0,
      NULL,
      NULL,
      2,
      NULL,
      0.773352,
      NULL,
      1.696789,
      NULL,
      2,
      NULL,
      3.107586,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2,
      NULL,
      1.581981,
      NULL,
      3.863448,
      NULL,
      0.803629,
      61,
      NULL,
      NULL,
      0.519215,
      1.978172,
      0.873744,
      1.313114,
      1,
      1,
      9,
      0.144559,
      NULL,
      1.185146,
      3.395467,
      2,
      85.544629,
      NULL,
      2.058291,
      0,
      0.080857,
      '43334',
      '23043',
      '',
      1.079761,
      '',
      '',
      '',
      4,
      '24244',
      NULL,
      '');
commit;
end;
/


