set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9202285';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-5-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '3',
      NULL,
      NULL,
      NULL,
      NULL,
      1.032315,
      0,
      NULL,
      NULL,
      1.448405,
      1.814951,
      NULL,
      NULL,
      NULL,
      55.848318,
      NULL,
      NULL,
      0,
      3.974034,
      ' 2-19-1993',
      23,
      0,
      223.695445,
      55,
      0,
      ' 6-13-1980',
      ' 7- 7-1992',
      NULL,
      2,
      1,
      2.101444,
      0.615764,
      1.461505,
      1.481666,
      3.618949,
      3,
      NULL,
      NULL,
      NULL,
      11.899925,
      2,
      1.294078,
      21.848835,
      7,
      11,
      5.512707,
      NULL,
      6.767835,
      1.149278,
      0.503544,
      0,
      1.706425,
      0,
      1.633418,
      0.839234,
      NULL,
      1.580613,
      0.238180,
      0.704815,
      1.079521,
      3,
      2.723521,
      0,
      NULL,
      NULL,
      3,
      NULL,
      4.975128,
      0.839869,
      2,
      0.728624,
      4,
      0,
      NULL,
      1.722904,
      NULL,
      1.994501,
      NULL,
      1.514195,
      1.600051,
      0.910465,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6,
      4.659293,
      2.004298,
      0.169822,
      1.742707,
      2.751841,
      3.181364,
      3.865872,
      3,
      1,
      3,
      3.476236,
      NULL,
      3,
      1.694303,
      0.269340,
      0,
      2.221559,
      3.870625,
      5,
      2,
      1,
      8.087312,
      2,
      2.855789,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.480504,
      NULL,
      1,
      0.960552,
      1.508704,
      5.260700,
      NULL,
      1,
      NULL,
      1.328004,
      0.054773,
      4,
      0.192069,
      1.679675,
      1.863091,
      0.090195,
      NULL,
      0,
      0,
      NULL,
      1.577041,
      0,
      0,
      3,
      1,
      0.473127,
      3.241289,
      0,
      0.916548,
      NULL,
      2.611622,
      3.723563,
      NULL,
      6,
      2,
      6.797337,
      4.598267,
      2,
      1.620431,
      NULL,
      1,
      4.576615,
      7.843942,
      4,
      6.139511,
      5.610085,
      5.260819,
      1,
      NULL,
      NULL,
      ' 5- 0-1994',
      69,
      1.669561,
      1.442227,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.441048,
      5.003280,
      0.290024,
      NULL,
      4.359915,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.445197,
      3.962300,
      5.243054,
      NULL,
      NULL,
      NULL,
      1,
      1,
      6.396404,
      1.597675,
      3,
      2,
      1,
      1,
      1.842226,
      0,
      NULL,
      NULL,
      3,
      3,
      7,
      1,
      NULL,
      NULL,
      0.102315,
      5.650620,
      1.813227,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.549707,
      1,
      NULL,
      1.309697,
      1,
      0,
      NULL,
      21.644313,
      1.155364,
      1.701224,
      NULL,
      NULL,
      NULL,
      2,
      1.718804,
      1.721839,
      4.264818,
      0,
      3,
      3,
      3,
      2.348708,
      NULL,
      1.967312,
      NULL,
      6.604025,
      4,
      3,
      1,
      5,
      NULL,
      0.021269,
      NULL,
      NULL,
      0.450907,
      0,
      1.577702,
      0,
      0,
      0.122921,
      1,
      0.084184,
      2.139649,
      NULL,
      1.011907,
      9,
      NULL,
      4.140012,
      11.580212,
      6,
      4,
      0,
      1.066106,
      4,
      NULL,
      3.934563,
      NULL,
      34.093478,
      0,
      3,
      NULL,
      21,
      3.533167,
      95.759729,
      4,
      0,
      0.520411,
      '01033',
      NULL,
      '',
      0,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      1,
      34,
      4.235444,
      0.471210,
      6,
      1.382559,
      0,
      NULL,
      3.569023,
      0.859987,
      2.799688,
      1.061744,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.168528,
      NULL,
      NULL,
      0.309972,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.819584,
      NULL,
      2,
      1,
      NULL,
      NULL,
      3,
      1,
      0.764189,
      NULL,
      3.262351,
      1,
      0.859912,
      0,
      0.967749,
      0.732237,
      NULL,
      NULL,
      7.736462,
      6,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.785700,
      NULL,
      NULL,
      NULL,
      1,
      1.356797,
      3,
      2,
      0.555068,
      0.265614,
      2.898016,
      1.282542,
      1.303349,
      0,
      0,
      0.248342,
      NULL,
      1,
      3,
      1,
      3,
      3,
      0.869094,
      0,
      3.308158,
      1.286084,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.479292,
      8.054972,
      NULL,
      1.913002,
      1,
      NULL,
      NULL,
      NULL,
      1.077350,
      NULL,
      NULL,
      NULL,
      0.894858,
      NULL,
      NULL,
      0.121350,
      0.404456,
      1,
      2,
      3.690039,
      1.521930,
      0.231052,
      NULL,
      NULL,
      1.076467,
      3.775959,
      1.100509,
      3,
      NULL,
      NULL,
      1.591227,
      NULL,
      NULL,
      3.352494,
      5.981662,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.050692,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.882280,
      NULL,
      0,
      1,
      NULL,
      NULL,
      2.325944,
      NULL,
      0.603960,
      6.228107,
      0,
      1.134723,
      5,
      2.140002,
      1,
      1.477747,
      3,
      NULL,
      NULL,
      NULL,
      3.208605,
      2,
      1,
      0.315742,
      9.221300,
      5.050616,
      5.568789,
      1.844810,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.585747,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.856864,
      2,
      NULL,
      2,
      NULL,
      5,
      1,
      NULL,
      0,
      NULL,
      0,
      3.545892,
      NULL,
      NULL,
      1.655133,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.705189,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.885732,
      NULL,
      NULL,
      1.386755,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.816582,
      1.327850,
      1.074400,
      0.770286,
      0.191954,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      64.941752,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.693801,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.478483,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.652839,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.668787,
      NULL,
      NULL,
      NULL,
      2.609050,
      NULL,
      NULL,
      NULL,
      3.718023,
      NULL,
      NULL,
      NULL,
      6.902415,
      NULL,
      NULL,
      NULL,
      NULL,
      1.880401,
      NULL,
      6.270379,
      0.316453,
      5,
      13,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.225325,
      NULL,
      NULL,
      0.766782,
      NULL,
      NULL,
      1.642973,
      NULL,
      NULL,
      583,
      3,
      1,
      NULL,
      1,
      0,
      1.885546,
      1,
      NULL,
      0,
      1.358757,
      NULL,
      0,
      1.643386,
      1,
      0.257702,
      1.489391,
      NULL,
      1.362005,
      3,
      NULL,
      NULL,
      NULL,
      1.010473,
      NULL,
      NULL,
      NULL,
      0.375837,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.066731,
      1,
      1.041648,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      0,
      NULL,
      1.438258,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.463226,
      NULL,
      NULL,
      NULL,
      NULL,
      0.997501,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.970672,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.756421,
      NULL,
      NULL,
      NULL,
      1.273152,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.060303,
      2.121564,
      NULL,
      NULL,
      NULL,
      0.967092,
      NULL,
      NULL,
      NULL,
      1.531076,
      2,
      0,
      3,
      NULL,
      1.594724,
      NULL,
      142,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.714545,
      NULL,
      1.293793,
      NULL,
      6.058976,
      NULL,
      1.524547,
      NULL,
      NULL,
      NULL,
      3.068245,
      2,
      1.884681,
      2.161035,
      0.638440,
      3,
      NULL,
      3.253107,
      7,
      NULL,
      2.786632,
      1.189842,
      0.744058,
      1.811314,
      NULL,
      1.001204,
      2.452993,
      NULL,
      1.493705,
      0.151776,
      NULL,
      0.987675,
      1,
      NULL,
      0,
      0.584844,
      NULL,
      0.029781,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.002053,
      NULL,
      1,
      1.979887,
      NULL,
      0.451926,
      0.557724,
      NULL,
      NULL,
      1,
      NULL,
      1.451647,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.851438,
      2.185804,
      NULL,
      0.588456,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.685612,
      NULL,
      1,
      NULL,
      0.476697,
      NULL,
      0.524971,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.755372,
      NULL,
      0.165934,
      NULL,
      8,
      NULL,
      11.913924,
      1,
      NULL,
      0.522417,
      NULL,
      1.446198,
      NULL,
      3.331413,
      4.342121,
      1.301070,
      1,
      NULL,
      NULL,
      21.122489,
      125.015875,
      NULL,
      NULL,
      5,
      '32004',
      NULL,
      '',
      1,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL);
commit;
end;
/


