set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8908830';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-5-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '1',
      NULL,
      NULL,
      '3244121',
      3.807013,
      1,
      2,
      2,
      '2312',
      NULL,
      0,
      NULL,
      NULL,
      ' 8-14-1993',
      14,
      NULL,
      0.358672,
      1.605663,
      0,
      ' 0-24-1992',
      58,
      3.854596,
      111,
      31.789172,
      3,
      ' 3-22-1995',
      ' 1-11-1997',
      '11-20-1989',
      2,
      0.531890,
      2,
      1.881674,
      0,
      0,
      1.584709,
      1,
      0,
      52.340682,
      5,
      17,
      6,
      NULL,
      NULL,
      6.297645,
      3,
      NULL,
      NULL,
      4.964051,
      0,
      3,
      NULL,
      1.879526,
      1.807708,
      1,
      1.281084,
      0,
      0,
      0,
      1,
      3,
      NULL,
      0,
      3.065741,
      5.346519,
      NULL,
      1.939166,
      1,
      1,
      0.094976,
      9,
      0,
      1,
      NULL,
      1.007777,
      0,
      0.193294,
      0,
      NULL,
      1.614359,
      NULL,
      0,
      NULL,
      NULL,
      0.482726,
      NULL,
      NULL,
      NULL,
      1.617353,
      NULL,
      1.004118,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.983780,
      3,
      3,
      2.393015,
      NULL,
      1.589185,
      0.058827,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      7.950017,
      0,
      NULL,
      6.350651,
      6.675593,
      1.380943,
      0.311373,
      0.215278,
      NULL,
      1,
      0,
      2,
      1,
      1,
      1.379664,
      0,
      1,
      NULL,
      0.162680,
      5,
      1.287444,
      0,
      2,
      1,
      5.903952,
      NULL,
      2,
      2.169999,
      1.097733,
      6,
      NULL,
      2,
      3,
      7.139755,
      9,
      4.891226,
      5,
      10.812317,
      8,
      NULL,
      NULL,
      4,
      4,
      2.652948,
      6,
      0.547043,
      ' 5-17-1986',
      201.224667,
      ' 2- 5-1981',
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.768437,
      1,
      1.811170,
      0.657507,
      1.741387,
      1.952047,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      35,
      1,
      NULL,
      2,
      0.874300,
      0.401235,
      1,
      1.536931,
      1,
      1.329860,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      6.254077,
      2,
      0.137099,
      6.969728,
      0,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      3,
      7,
      6,
      0.229321,
      ' 4-13-1998',
      13,
      ' 6- 8-1990',
      52,
      0,
      0,
      0.968609,
      NULL,
      1.940900,
      NULL,
      1,
      1.379370,
      0,
      NULL,
      NULL,
      60,
      1.330674,
      1.598418,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4.449444,
      NULL,
      NULL,
      NULL,
      1.543162,
      3,
      4,
      0,
      5,
      0,
      4,
      1.182040,
      2.004262,
      NULL,
      0,
      0,
      NULL,
      0.349423,
      NULL,
      0,
      1.074268,
      1.893912,
      1.018654,
      0.589544,
      1,
      0,
      0.539700,
      0,
      0,
      NULL,
      6,
      NULL,
      11,
      0.836501,
      7.776382,
      3,
      0,
      2,
      2.163013,
      1,
      0.227975,
      60.766612,
      0,
      3.422584,
      NULL,
      26.728301,
      29,
      51.739689,
      NULL,
      0,
      1.607822,
      '31403',
      '',
      '',
      1.473609,
      '23023',
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      49.946855,
      59.705047,
      61,
      3.534787,
      41.095279,
      0.395779,
      0.515614,
      NULL,
      1,
      0,
      0.421788,
      0.409842,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.345568,
      NULL,
      NULL,
      0.906763,
      0,
      1.385960,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.139937,
      NULL,
      NULL,
      1.034289,
      NULL,
      NULL,
      1.658031,
      0,
      NULL,
      1,
      NULL,
      NULL,
      11,
      2,
      3.918014,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.278406,
      NULL,
      NULL,
      1.992492,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.525720,
      0.251729,
      1,
      1,
      2.019066,
      0.978941,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.831499,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      9,
      0,
      2.023326,
      1.480462,
      1,
      1,
      1.068355,
      NULL,
      NULL,
      1.805842,
      0.977267,
      NULL,
      1.760529,
      NULL,
      NULL,
      1.502607,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.677665,
      NULL,
      NULL,
      1.120468,
      NULL,
      NULL,
      0.369662,
      NULL,
      NULL,
      0.648976,
      2,
      0.736859,
      1.432598,
      0.486627,
      NULL,
      1.714804,
      1,
      NULL,
      4,
      NULL,
      NULL,
      6.059152,
      1,
      NULL,
      2.650375,
      1.606131,
      0.122646,
      1,
      1,
      3.198477,
      2,
      1,
      1,
      10,
      NULL,
      9,
      NULL,
      0.516743,
      NULL,
      2,
      NULL,
      1,
      3,
      0.578638,
      2,
      3,
      3,
      1,
      9.809370,
      3.158341,
      NULL,
      0,
      2.709164,
      3.163723,
      3,
      0,
      1.056295,
      0.925615,
      1,
      1.854873,
      0.548290,
      0,
      2.943560,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.342914,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.444563,
      NULL,
      NULL,
      1.262798,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.628665,
      NULL,
      NULL,
      3,
      0,
      0.735530,
      1.631520,
      1,
      2,
      1,
      NULL,
      6,
      1,
      NULL,
      NULL,
      37,
      6.048944,
      NULL,
      NULL,
      2.211129,
      3.594792,
      NULL,
      NULL,
      0.776497,
      0.896306,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.399487,
      3,
      NULL,
      NULL,
      NULL,
      0.416859,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.369186,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.045928,
      1.755971,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.368053,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      3.040675,
      6,
      NULL,
      NULL,
      0.176419,
      NULL,
      NULL,
      NULL,
      NULL,
      1.989871,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.865691,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.613767,
      NULL,
      NULL,
      73,
      0,
      NULL,
      1,
      0,
      0.631956,
      0.573097,
      0,
      0,
      1,
      NULL,
      1,
      0.255691,
      1,
      0.789471,
      0,
      1.390862,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.851434,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.060611,
      3,
      3.141502,
      0,
      0,
      1.491894,
      0,
      NULL,
      0,
      0.260885,
      0,
      NULL,
      0.435257,
      NULL,
      NULL,
      1.325344,
      NULL,
      3.746390,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0.879059,
      0,
      NULL,
      1,
      0,
      NULL,
      1.489787,
      1.081243,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.928504,
      NULL,
      1,
      NULL,
      0.373800,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.415787,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.055143,
      NULL,
      NULL,
      NULL,
      1.826680,
      NULL,
      3.618042,
      NULL,
      0,
      NULL,
      1.473418,
      NULL,
      1.059563,
      NULL,
      1.377625,
      NULL,
      NULL,
      NULL,
      1.007950,
      NULL,
      34.248167,
      3.261899,
      NULL,
      0.607683,
      NULL,
      NULL,
      NULL,
      1.543009,
      NULL,
      1.729203,
      3,
      4.284558,
      2.622960,
      1,
      1,
      NULL,
      16,
      4.653998,
      NULL,
      3,
      NULL,
      '',
      '',
      2,
      '00040',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


