set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9611385';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-5-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '0',
      NULL,
      NULL,
      '0313022',
      1.015122,
      0,
      3,
      NULL,
      '4331',
      2.215264,
      1.517341,
      NULL,
      NULL,
      ' 1-14-1976',
      56,
      NULL,
      2,
      2,
      0,
      ' 2-29-2001',
      24,
      0,
      126,
      15,
      2.331872,
      ' 8- 4-1998',
      ' 8-11-1986',
      ' 5- 6-1993',
      0.969599,
      NULL,
      1,
      1,
      0.108644,
      0,
      1,
      0,
      1.422091,
      0,
      6.164320,
      16,
      NULL,
      34,
      8,
      0,
      13,
      2.757731,
      2.152249,
      2.095099,
      2.902684,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.061936,
      1.301184,
      1,
      0.379352,
      7,
      0,
      0.833945,
      NULL,
      5,
      10.825689,
      1,
      7,
      9.877508,
      0,
      9,
      NULL,
      NULL,
      1,
      5,
      1,
      3.193723,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7,
      7,
      5.885101,
      NULL,
      2,
      3,
      3.676287,
      3.516414,
      NULL,
      0.105427,
      2,
      0,
      3.983698,
      NULL,
      1.902834,
      2.390310,
      1,
      3.940481,
      0.586828,
      6.123063,
      0.614575,
      3,
      10.515717,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      0.990814,
      NULL,
      NULL,
      0,
      NULL,
      3,
      0.641623,
      3.370040,
      1,
      4,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.225314,
      5.808055,
      0.581641,
      1,
      0,
      NULL,
      0,
      NULL,
      1.506101,
      NULL,
      NULL,
      0,
      3,
      0,
      4,
      6,
      1,
      5.376338,
      NULL,
      NULL,
      1,
      3.576526,
      7.241898,
      1,
      4.403889,
      1,
      5,
      0.187507,
      NULL,
      0.071553,
      11,
      8.153133,
      1,
      NULL,
      1.990382,
      2.457865,
      ' 6-20-1986',
      107,
      ' 5-20-1990',
      2.955947,
      1,
      0.136551,
      2.166381,
      1,
      0.178327,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.269818,
      1,
      0,
      6,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.700563,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      3.161923,
      3.658462,
      1,
      0.377796,
      5.361814,
      1.242983,
      2,
      0,
      NULL,
      4.092596,
      3.817576,
      1.269392,
      3,
      0.475970,
      NULL,
      3.721924,
      0.002297,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.877664,
      0,
      0,
      3.931515,
      1,
      1.853388,
      0,
      1.500881,
      49.892682,
      1.661256,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.163007,
      2,
      3,
      1,
      3.453581,
      0,
      3.331262,
      0,
      2,
      2,
      3,
      0,
      11,
      47.059662,
      121.042588,
      112,
      54,
      193,
      NULL,
      0,
      0,
      1.723502,
      0,
      1,
      0.437959,
      0.138382,
      16.914458,
      12,
      0,
      7.632010,
      6,
      NULL,
      8.058763,
      NULL,
      6.893845,
      NULL,
      0.239673,
      0.495189,
      2.132484,
      NULL,
      2.185938,
      37.934086,
      0,
      NULL,
      NULL,
      NULL,
      32.215719,
      69,
      4,
      3,
      0,
      '34033',
      '',
      NULL,
      0,
      NULL,
      '',
      '',
      0,
      '',
      NULL,
      NULL,
      2,
      48,
      3,
      11.023574,
      3,
      39.476334,
      1,
      1,
      2,
      0,
      1.223659,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.866332,
      NULL,
      1,
      2,
      2.905203,
      3.165446,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      1,
      0,
      3,
      3.410771,
      1,
      2.803057,
      0,
      1,
      0,
      3,
      2.432742,
      3.279799,
      0,
      3,
      0.485088,
      7.007553,
      3,
      NULL,
      0.352351,
      1.357564,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.184369,
      2.178639,
      2,
      2.218283,
      3.615277,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0.389754,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.536186,
      1.611853,
      2.146003,
      3,
      NULL,
      0.517554,
      3,
      1,
      0,
      2.783264,
      0.461380,
      3.990623,
      2.679237,
      0,
      3.650597,
      0.364091,
      NULL,
      NULL,
      9.808933,
      9,
      6.685978,
      1.710209,
      NULL,
      NULL,
      NULL,
      NULL,
      1.282899,
      NULL,
      NULL,
      NULL,
      0.495921,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.779880,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.584082,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.969548,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.014779,
      2,
      0,
      3,
      3,
      0,
      2,
      NULL,
      4,
      NULL,
      1,
      7,
      5,
      4,
      7.323221,
      1.753170,
      3,
      0.940126,
      NULL,
      NULL,
      3,
      2.147184,
      0.190615,
      2.889318,
      1.209327,
      5.530333,
      7.801913,
      1.653604,
      3,
      2,
      1.184666,
      1,
      NULL,
      2.030828,
      0,
      1,
      NULL,
      3,
      NULL,
      8.466929,
      6,
      1.086944,
      2,
      3,
      1.187440,
      NULL,
      NULL,
      NULL,
      1,
      0.545237,
      NULL,
      1.178588,
      0.999621,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.501919,
      2.305999,
      0.309644,
      1.368216,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.450582,
      1,
      5,
      6.605561,
      1,
      NULL,
      0,
      2.276389,
      12,
      2,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.996603,
      NULL,
      NULL,
      0.768880,
      NULL,
      NULL,
      0.865754,
      NULL,
      1,
      157,
      2.103541,
      1.757381,
      1,
      1.974794,
      1.966724,
      1.066496,
      NULL,
      1,
      NULL,
      1.186912,
      1.162410,
      0.824160,
      0,
      1,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.423154,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.840625,
      NULL,
      1.881920,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.323001,
      2.086090,
      NULL,
      3.075815,
      NULL,
      3.917188,
      NULL,
      12.755319,
      NULL,
      1.753845,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.161398,
      0,
      1.921378,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.218363,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.307809,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2,
      25.035645,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.099391,
      NULL,
      0,
      3,
      0.870260,
      1.392010,
      0.232133,
      3.762021,
      0,
      0,
      3.296659,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.582037,
      NULL,
      0.748589,
      NULL,
      NULL,
      NULL,
      1.484798,
      NULL,
      0,
      NULL,
      NULL,
      0.025176,
      1,
      NULL,
      1.597515,
      0.263546,
      NULL,
      1,
      0,
      NULL,
      0.064164,
      0,
      NULL,
      0.522138,
      1.199889,
      NULL,
      1,
      0,
      NULL,
      1.040575,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      27.503296,
      0,
      5.170656,
      2.619130,
      NULL,
      '02323',
      '',
      1.158973,
      NULL,
      '',
      '',
      0,
      '',
      '',
      NULL);
commit;
end;
/


