set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7941726';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-8-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3.660431,
      3,
      NULL,
      NULL,
      5,
      NULL,
      0,
      NULL,
      '320',
      '4',
      55.580822,
      NULL,
      '1313012',
      0,
      1,
      0,
      1,
      '0143',
      1.610043,
      1.051930,
      NULL,
      NULL,
      ' 1- 5-1974',
      150.696734,
      5,
      NULL,
      2.967217,
      1,
      '11-15-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      ' 3-16-1988',
      2.236310,
      0.085895,
      1,
      0.290521,
      0.410004,
      3,
      0.846669,
      NULL,
      1,
      532.099444,
      2,
      5.433890,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.769107,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.876013,
      3.702460,
      3.134549,
      2.751862,
      4,
      NULL,
      NULL,
      0,
      1.616215,
      1,
      4.440643,
      NULL,
      6.918378,
      1,
      1.064487,
      1,
      3,
      0,
      NULL,
      1.010869,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.489808,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      3,
      3,
      0.906773,
      0,
      NULL,
      2.460721,
      1,
      1,
      0,
      0.288091,
      0,
      0.988111,
      0.106774,
      6.394812,
      NULL,
      3,
      0,
      0.713463,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      1.778119,
      1,
      1.196286,
      2.184348,
      0,
      0.342584,
      1.599967,
      0,
      0,
      NULL,
      0,
      0.293821,
      0.348812,
      0.994115,
      1.041687,
      0.525181,
      1.805155,
      NULL,
      NULL,
      0,
      1.843927,
      0.384455,
      1,
      1,
      0,
      1,
      3,
      1.636110,
      1,
      NULL,
      0,
      1.366473,
      2.564861,
      0,
      NULL,
      7.828704,
      2.965066,
      8.864672,
      NULL,
      5.967537,
      6.097029,
      6.568556,
      2.017415,
      0.426768,
      1,
      0.984208,
      1,
      ' 8-14-2002',
      1266,
      ' 7-16-1985',
      1929,
      1.138617,
      1.712357,
      NULL,
      3,
      1.077202,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      0,
      1.931711,
      0.918068,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.435545,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.287926,
      0,
      1.860271,
      0.446239,
      1.358473,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.466185,
      5.528607,
      NULL,
      1.795629,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0.056695,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.452837,
      0.519994,
      0,
      0.804408,
      0.955727,
      1,
      NULL,
      1.541961,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      NULL,
      2.636274,
      3,
      2,
      0.917201,
      NULL,
      2,
      1.170966,
      0,
      2.948369,
      1.833474,
      4,
      0,
      0,
      3,
      0,
      0,
      NULL,
      0.300020,
      NULL,
      1,
      0,
      NULL,
      3,
      1.441949,
      3,
      1,
      NULL,
      9,
      1,
      2.356035,
      3,
      NULL,
      1,
      NULL,
      NULL,
      2.520649,
      2,
      NULL,
      NULL,
      0,
      1.791244,
      0.432578,
      NULL,
      NULL,
      NULL,
      0.517942,
      0.198808,
      2.104682,
      '03200',
      '',
      '',
      0,
      '',
      '',
      '',
      2,
      '03043',
      '',
      '',
      3,
      27,
      185,
      19,
      0.158184,
      41,
      16.935235,
      59,
      3,
      3.449071,
      0,
      3,
      1,
      NULL,
      NULL,
      0.005225,
      NULL,
      NULL,
      2.121903,
      NULL,
      0.594888,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      1.476192,
      2.969431,
      2.248787,
      NULL,
      1.262952,
      0,
      1,
      0,
      0.296449,
      0.971770,
      0.427389,
      1,
      1,
      1.855095,
      6.734884,
      1.193919,
      9.632529,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.678626,
      1.993422,
      NULL,
      0.006852,
      1,
      3.580162,
      NULL,
      1.578372,
      3,
      2,
      1,
      0,
      1.854353,
      0.827412,
      1.104848,
      2.203206,
      2,
      1,
      3.341391,
      0.249419,
      NULL,
      1,
      1,
      1,
      1,
      1.149565,
      NULL,
      NULL,
      0.379411,
      NULL,
      NULL,
      0,
      NULL,
      1.161520,
      5.983691,
      0,
      NULL,
      0.345315,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.271622,
      NULL,
      0.124802,
      2,
      0,
      NULL,
      1.804899,
      0.517560,
      1,
      1.069837,
      NULL,
      NULL,
      6,
      0.606738,
      NULL,
      1.122915,
      NULL,
      NULL,
      2.061025,
      1.974218,
      3,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.765120,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      5.003317,
      0,
      1,
      7,
      0,
      7,
      1,
      NULL,
      NULL,
      1.267835,
      0,
      1.339141,
      NULL,
      NULL,
      3,
      2,
      1,
      0,
      3,
      0.526026,
      NULL,
      0,
      1,
      3,
      2.657819,
      0,
      0,
      0.194771,
      1,
      0.119782,
      2.838998,
      NULL,
      3,
      0.501235,
      1.656107,
      NULL,
      NULL,
      NULL,
      NULL,
      2.257808,
      3,
      5.709992,
      1,
      NULL,
      NULL,
      1.664097,
      0.325055,
      1.192500,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.596364,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.686304,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.191794,
      NULL,
      NULL,
      1.063958,
      0,
      1.540777,
      1.963687,
      1,
      NULL,
      0.800463,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.936751,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.761491,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.725509,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.609090,
      NULL,
      NULL,
      NULL,
      1.393815,
      NULL,
      NULL,
      NULL,
      1.531050,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.255231,
      NULL,
      NULL,
      NULL,
      0.827950,
      111.018173,
      250,
      1.034984,
      23,
      1,
      0,
      NULL,
      NULL,
      0.011452,
      37,
      5,
      NULL,
      NULL,
      5.146556,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      217.837362,
      NULL,
      0.537864,
      1.737373,
      0,
      0.411364,
      1,
      NULL,
      1.549192,
      0,
      0,
      NULL,
      0.570415,
      1.325160,
      1.813266,
      1,
      1.121856,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.462184,
      NULL,
      NULL,
      1,
      NULL,
      1.440822,
      NULL,
      NULL,
      NULL,
      1.478599,
      NULL,
      0.858742,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.050278,
      NULL,
      0,
      NULL,
      0.155223,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.130817,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.408348,
      NULL,
      0,
      1.250360,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.339045,
      2,
      NULL,
      0.184999,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      1,
      1.516665,
      NULL,
      1264,
      NULL,
      3,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.598682,
      0.292348,
      0.705941,
      NULL,
      0,
      1.344459,
      0.174967,
      NULL,
      0.070224,
      0.428167,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      0.876240,
      2.056011,
      NULL,
      NULL,
      NULL,
      NULL,
      1.132557,
      1.695558,
      NULL,
      1.069035,
      NULL,
      NULL,
      0,
      0.015764,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.612185,
      NULL,
      0.636490,
      1,
      NULL,
      0.181604,
      1.828070,
      NULL,
      0.279215,
      1.287892,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.317197,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.226505,
      8.179397,
      6.158789,
      3.943991,
      NULL,
      2,
      11,
      27,
      0,
      4.747910,
      3.156106,
      '20311',
      NULL,
      NULL,
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '');
commit;
end;
/


