set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9664424';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-12-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0,
      NULL,
      3.907504,
      4,
      0,
      3,
      1.301987,
      2,
      '233',
      '23001434',
      NULL,
      18,
      NULL,
      2,
      NULL,
      NULL,
      3,
      '1022',
      4,
      0,
      NULL,
      NULL,
      NULL,
      4,
      58,
      NULL,
      1,
      5.196129,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-17-1976',
      NULL,
      NULL,
      3,
      2,
      1,
      0.357044,
      1.682453,
      0.813990,
      8.339788,
      1.215783,
      0.217954,
      44.064851,
      5,
      16.099423,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      2.598474,
      NULL,
      2.065743,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.427396,
      1,
      1.518384,
      NULL,
      0.796463,
      4.307025,
      3.861029,
      5,
      1,
      4,
      0.624234,
      0,
      0,
      3,
      1,
      5.809039,
      0.127451,
      1.211015,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1,
      3.712094,
      0,
      0,
      1.895319,
      NULL,
      0.822417,
      0.334991,
      3.541055,
      0,
      1,
      1,
      2.424709,
      0.245729,
      0.310177,
      3,
      2.245566,
      0.409886,
      NULL,
      1,
      1,
      9.151826,
      1,
      NULL,
      NULL,
      1.061291,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.071458,
      3,
      NULL,
      1,
      0,
      1.081297,
      NULL,
      0,
      1.422030,
      NULL,
      0,
      1.361295,
      1,
      1,
      0.146374,
      NULL,
      1.640017,
      NULL,
      1,
      NULL,
      NULL,
      9.914322,
      0.505077,
      0,
      1.693215,
      1.631615,
      8,
      1.564934,
      0,
      NULL,
      3,
      6.335585,
      0.471769,
      1.752791,
      NULL,
      5,
      NULL,
      4,
      NULL,
      4.571330,
      4.752961,
      0,
      3.982938,
      NULL,
      NULL,
      NULL,
      3.642769,
      0,
      ' 6- 4-2000',
      469,
      ' 9-11-1992',
      108,
      0.298665,
      0,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.229903,
      0.579307,
      0.525623,
      0.121380,
      NULL,
      4.275205,
      3.983505,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.954728,
      NULL,
      NULL,
      NULL,
      NULL,
      0.547851,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.584844,
      1.210060,
      1.260650,
      1.447436,
      NULL,
      3,
      0,
      0.860513,
      NULL,
      0,
      0,
      2.297052,
      0.556536,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.716052,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      0.870316,
      NULL,
      0,
      1,
      55,
      0.100292,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.054199,
      1.454422,
      3.428302,
      0.051117,
      0.969813,
      0,
      2,
      2,
      1.248851,
      NULL,
      1.033530,
      0,
      NULL,
      3.620793,
      NULL,
      0,
      0.634028,
      3,
      NULL,
      2,
      0.160877,
      1.325921,
      4.513987,
      0.837785,
      NULL,
      3.287356,
      3,
      2.036568,
      0.524028,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      26.792315,
      NULL,
      34.485210,
      56,
      3,
      NULL,
      NULL,
      '31203',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '',
      NULL,
      '',
      NULL,
      56,
      156.649028,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.548159,
      2.283836,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.731555,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.474462,
      3.668001,
      NULL,
      NULL,
      NULL,
      0.869302,
      NULL,
      3.405478,
      1.220533,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.188315,
      NULL,
      NULL,
      1.354574,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      3.882457,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.248009,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.128366,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.952445,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      3,
      NULL,
      1.738321,
      NULL,
      NULL,
      1.099205,
      0,
      5.653873,
      0.092356,
      NULL,
      NULL,
      1.789990,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.158955,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.827889,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.682587,
      NULL,
      NULL,
      0,
      1.935774,
      2,
      1,
      NULL,
      NULL,
      5,
      7.739001,
      8,
      0,
      NULL,
      3.704013,
      NULL,
      NULL,
      NULL,
      3,
      2.882170,
      3,
      0,
      0.135249,
      NULL,
      NULL,
      1.576453,
      2.884605,
      8,
      0,
      8,
      0,
      2,
      2,
      2,
      1.480768,
      0.607174,
      3,
      3.098277,
      NULL,
      1.846452,
      1.936009,
      1.475561,
      1,
      NULL,
      4.104468,
      2.132231,
      1.870944,
      4,
      1.510134,
      NULL,
      1,
      NULL,
      NULL,
      0.916345,
      1,
      1,
      3.511461,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.509965,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.252988,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.969776,
      NULL,
      NULL,
      1,
      NULL,
      1.379155,
      1.613643,
      0,
      3.592672,
      0.730232,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.055878,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.058482,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.503544,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.446634,
      6.131893,
      0.483627,
      2.963565,
      3,
      0.691071,
      1,
      NULL,
      NULL,
      1.536600,
      NULL,
      NULL,
      0.168504,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.230911,
      NULL,
      0.772731,
      NULL,
      7.262223,
      1.990106,
      1.689030,
      1.104691,
      1,
      0.263643,
      NULL,
      NULL,
      1.390189,
      0.960036,
      0,
      0,
      1.695224,
      1,
      1.345156,
      NULL,
      0.569380,
      0,
      0.153781,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.055860,
      1.356648,
      0,
      10,
      3,
      2.853953,
      2.589821,
      3.551637,
      3,
      3.805056,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.627783,
      NULL,
      0.839167,
      1,
      NULL,
      1.127427,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.268098,
      NULL,
      0.655543,
      NULL,
      NULL,
      1,
      3.760872,
      NULL,
      NULL,
      1.633915,
      NULL,
      0,
      NULL,
      NULL,
      3.131297,
      0.009961,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.310252,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.879672,
      NULL,
      1.126421,
      NULL,
      0.363629,
      5.853555,
      0.051865,
      NULL,
      0.535639,
      NULL,
      42.990462,
      50,
      1,
      5,
      3,
      NULL,
      '',
      '',
      0.551207,
      '',
      NULL,
      '',
      0,
      NULL,
      '',
      '');
commit;
end;
/


