set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8925188';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-9-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      '3200020',
      1.986431,
      NULL,
      1,
      2,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      ' 3-15-1991',
      34.606029,
      NULL,
      9,
      1.128318,
      0,
      '11- 2-1980',
      29.066277,
      2,
      NULL,
      69,
      1.253951,
      ' 6- 3-1979',
      '10-17-2000',
      NULL,
      1.278236,
      2.143068,
      0.888706,
      3,
      0.461342,
      1,
      2.709988,
      1.385827,
      NULL,
      NULL,
      NULL,
      2.196659,
      4.053944,
      9,
      22.802092,
      5,
      4.592315,
      NULL,
      3,
      NULL,
      0.580502,
      1.786652,
      1.238109,
      NULL,
      1.774747,
      NULL,
      0.058008,
      2.293846,
      1.377701,
      NULL,
      1.156932,
      NULL,
      4,
      3.733027,
      NULL,
      0.958671,
      0,
      0,
      NULL,
      2,
      1,
      1.082401,
      0,
      NULL,
      0,
      0.691296,
      NULL,
      3,
      NULL,
      0.741032,
      2.813665,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.743151,
      1.822870,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      1,
      1,
      4.892763,
      3,
      NULL,
      1.868105,
      0,
      1.122491,
      2,
      2.549477,
      1.799161,
      NULL,
      0.725916,
      1,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      7,
      0.313569,
      1,
      3,
      NULL,
      1,
      1,
      NULL,
      0.864011,
      NULL,
      1,
      NULL,
      2.895263,
      0,
      1,
      1,
      NULL,
      0.123137,
      1,
      0.637238,
      8.964625,
      NULL,
      7.722371,
      11,
      NULL,
      0.457098,
      '10-22-1985',
      2.799885,
      NULL,
      2,
      0.226863,
      5,
      0,
      9.980052,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      6.559076,
      0,
      1.294776,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.226298,
      NULL,
      1,
      1.648075,
      1,
      NULL,
      NULL,
      1.939373,
      NULL,
      NULL,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.192704,
      NULL,
      0,
      1.202235,
      0.480747,
      0.939216,
      0.719754,
      3.878587,
      18,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4.781815,
      0,
      0.993261,
      1.538902,
      NULL,
      4,
      4.131770,
      3,
      NULL,
      0,
      3,
      4,
      NULL,
      2,
      3,
      3,
      2.479317,
      63,
      144.359905,
      NULL,
      37,
      101.701288,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.025582,
      1,
      13.571309,
      8,
      1,
      4,
      NULL,
      1,
      NULL,
      0.568535,
      0.923756,
      4.797207,
      2.769344,
      NULL,
      NULL,
      3.584072,
      3,
      NULL,
      1,
      2.741928,
      NULL,
      4.990271,
      27.658702,
      23,
      4,
      1,
      2.609917,
      NULL,
      '',
      '',
      1.088086,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      0,
      16.955352,
      27,
      7.250588,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.118722,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.412762,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.113540,
      NULL,
      NULL,
      1.608324,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.903670,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.580822,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.609464,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.426359,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.461937,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.197538,
      NULL,
      NULL,
      1,
      0.072967,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      4,
      1.517159,
      0,
      2,
      0,
      1,
      NULL,
      NULL,
      7,
      5.408662,
      2.725977,
      NULL,
      NULL,
      NULL,
      1.805435,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.203437,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.660941,
      NULL,
      NULL,
      2,
      NULL,
      2.210524,
      1,
      NULL,
      NULL,
      1.019190,
      NULL,
      NULL,
      NULL,
      0,
      1.049792,
      1.325851,
      NULL,
      NULL,
      2,
      0.668660,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.926676,
      2,
      NULL,
      1.405542,
      3,
      0.124941,
      NULL,
      2.881487,
      2,
      2,
      3.150402,
      0.572369,
      NULL,
      1.843507,
      NULL,
      1.145861,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.950448,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.779238,
      NULL,
      NULL,
      0,
      0.772072,
      NULL,
      0,
      1,
      2,
      NULL,
      NULL,
      NULL,
      0.402359,
      0.580079,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.114899,
      NULL,
      NULL,
      NULL,
      1.326981,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      0.931138,
      1.613135,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.103293,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.245791,
      1,
      0,
      1.846910,
      1.032540,
      0.047555,
      1.448768,
      1.144171,
      0,
      1,
      1.154295,
      1.182115,
      1,
      1,
      1.408339,
      0.324745,
      0.472767,
      0,
      1.552297,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.160227,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      4.378706,
      4.948182,
      0.166362,
      3.024354,
      NULL,
      5.636976,
      1,
      2.522940,
      0,
      0.167420,
      0,
      1,
      1.627043,
      NULL,
      NULL,
      NULL,
      0.263903,
      0.637246,
      1.236791,
      1.816066,
      0,
      2.762061,
      3,
      3,
      3.926766,
      2,
      3,
      NULL,
      3,
      0.450178,
      NULL,
      2.247440,
      0,
      1,
      1,
      0.058825,
      0.305078,
      3.512196,
      1.643717,
      1.652002,
      1,
      1.930714,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.006723,
      0,
      0.035365,
      1,
      1,
      0,
      0.631180,
      6,
      7,
      1.215301,
      NULL,
      NULL,
      118,
      123,
      NULL,
      NULL,
      0,
      '04123',
      '40032',
      NULL,
      2.917336,
      '01034',
      '23000',
      NULL,
      0.415307,
      '',
      '',
      '');
commit;
end;
/


