set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9649566';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-2-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '31',
      '13',
      11.379965,
      10,
      '3102333',
      0.466107,
      1,
      5,
      1,
      '0233',
      NULL,
      0.212467,
      NULL,
      NULL,
      ' 4-12-1996',
      28,
      120,
      NULL,
      0,
      9,
      ' 3- 4-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      2.975902,
      NULL,
      ' 2-28-1980',
      ' 5-29-1996',
      2.479848,
      NULL,
      3.285860,
      3,
      NULL,
      3,
      3.034175,
      3.235348,
      NULL,
      NULL,
      NULL,
      1.109363,
      5.470672,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      0.572824,
      NULL,
      0,
      NULL,
      0,
      3.373199,
      1,
      0,
      0,
      1.742607,
      NULL,
      0.522521,
      3.304569,
      NULL,
      0.983258,
      4.116148,
      0,
      1,
      1.000534,
      2.167437,
      1.888393,
      3,
      2.144566,
      NULL,
      0,
      NULL,
      0.269729,
      5.694696,
      1,
      1,
      NULL,
      NULL,
      0.884763,
      NULL,
      NULL,
      0.292228,
      NULL,
      NULL,
      5.123697,
      1,
      0.857804,
      1.823456,
      NULL,
      NULL,
      0.088705,
      0,
      3.579381,
      0,
      1.221222,
      0.718525,
      NULL,
      0.098395,
      0.777134,
      0.756510,
      NULL,
      0,
      2.392669,
      10,
      3.962819,
      1,
      7.350856,
      NULL,
      2,
      1,
      0.719066,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.706270,
      1,
      1.049837,
      0,
      1,
      1,
      1,
      1.200964,
      1,
      1.647487,
      1,
      0.635949,
      1,
      0.306717,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      1,
      0.838604,
      1.378929,
      0.828816,
      1,
      0,
      0,
      NULL,
      NULL,
      1.070579,
      0,
      0.748927,
      NULL,
      4,
      0,
      0.891520,
      1,
      1,
      0,
      5.158593,
      2,
      1,
      NULL,
      2,
      1.304702,
      4.848314,
      0,
      3.654807,
      '11-24-1993',
      8.878970,
      ' 9-11-1982',
      5,
      0.090090,
      NULL,
      1.441157,
      2.916442,
      0.778303,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.001381,
      NULL,
      0.035714,
      0.661876,
      1.639985,
      NULL,
      0,
      3.583258,
      1,
      0.833926,
      0.308664,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.749760,
      1,
      1.328737,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.292792,
      1,
      5.782072,
      3,
      0,
      0.114378,
      0.567150,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.219853,
      1.823116,
      1.614166,
      0.191909,
      1,
      2,
      NULL,
      0,
      0.827288,
      NULL,
      NULL,
      NULL,
      NULL,
      1.591062,
      3.427587,
      2,
      1.766119,
      2.114606,
      1.306916,
      1,
      2.997723,
      NULL,
      0.537109,
      3,
      NULL,
      2.430026,
      0.774166,
      0,
      1,
      2.925774,
      1.571978,
      1,
      1.826817,
      NULL,
      1.143092,
      0,
      0,
      0.546753,
      0.474518,
      1,
      NULL,
      0,
      6,
      1.682563,
      9.511437,
      9,
      2.722168,
      9,
      5,
      2.451503,
      NULL,
      2,
      1.290000,
      1.818500,
      NULL,
      2,
      55,
      0.209560,
      NULL,
      25.269162,
      NULL,
      54.084510,
      30,
      NULL,
      1.134882,
      1,
      '03001',
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      3,
      53,
      20.058022,
      NULL,
      0.937334,
      NULL,
      NULL,
      NULL,
      NULL,
      1.910841,
      NULL,
      1.471661,
      1.781133,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      1,
      0.236942,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.082895,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.090082,
      NULL,
      NULL,
      5.650577,
      1,
      0.810545,
      1,
      1.245040,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.477713,
      NULL,
      NULL,
      1.249051,
      NULL,
      NULL,
      1.938169,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.832383,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.384219,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.783651,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.466978,
      NULL,
      NULL,
      1.840697,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.170305,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.622777,
      NULL,
      NULL,
      0.868062,
      NULL,
      NULL,
      1.343141,
      NULL,
      NULL,
      1.332761,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.072899,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.998930,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.739809,
      NULL,
      NULL,
      0.416450,
      NULL,
      1.343018,
      0,
      1.906345,
      3,
      0,
      NULL,
      NULL,
      0.665265,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.162889,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.818609,
      0.155641,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0,
      14,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.494038,
      NULL,
      NULL,
      1.390000,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1294,
      1,
      0.835803,
      0,
      1,
      NULL,
      0,
      NULL,
      0.799168,
      1.949120,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.366218,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.129423,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.095405,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.777850,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.286046,
      3,
      NULL,
      0,
      NULL,
      1.909916,
      NULL,
      NULL,
      NULL,
      1.359505,
      NULL,
      1,
      NULL,
      NULL,
      0.174113,
      1.882745,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      2,
      2,
      3,
      NULL,
      NULL,
      NULL,
      1.037745,
      1.211473,
      1.757988,
      1,
      NULL,
      0,
      0,
      NULL,
      3.944033,
      NULL,
      NULL,
      0.588701,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.168047,
      NULL,
      1,
      0.964421,
      NULL,
      1,
      1.696616,
      NULL,
      1.757536,
      NULL,
      NULL,
      NULL,
      0.413900,
      NULL,
      0,
      0,
      1.954830,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.729323,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.249269,
      NULL,
      NULL,
      NULL,
      0.878257,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6.096766,
      58.421138,
      4,
      1.163405,
      2,
      '32213',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


