set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9649566';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-5-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      6,
      2.022477,
      2.007776,
      3.480391,
      NULL,
      1.611558,
      2.281236,
      0,
      '121',
      '24132103',
      37,
      43,
      NULL,
      5,
      0.397101,
      NULL,
      1,
      '4034',
      3,
      0,
      NULL,
      NULL,
      NULL,
      67.438497,
      NULL,
      NULL,
      3.037660,
      1.311816,
      ' 8-13-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 6-13-1999',
      NULL,
      ' 5- 9-1992',
      0,
      0,
      0.167981,
      1.107337,
      0,
      0,
      4.121421,
      1.898105,
      NULL,
      NULL,
      NULL,
      7,
      2.212268,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      3,
      NULL,
      1.700307,
      1.574012,
      1,
      0,
      0,
      NULL,
      0,
      1,
      0,
      0,
      0.730898,
      0,
      1.902109,
      2,
      3.465108,
      2,
      0.080549,
      3,
      0,
      1.051590,
      0.292446,
      2,
      0,
      0,
      0,
      0.234453,
      1,
      2.491891,
      NULL,
      0,
      0,
      1,
      0.842719,
      NULL,
      NULL,
      2,
      0.261033,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.878372,
      1.771912,
      0,
      NULL,
      1,
      3,
      1.126923,
      1,
      NULL,
      NULL,
      1.535314,
      1.876871,
      1,
      NULL,
      0.511597,
      0,
      0,
      0,
      1.794319,
      0,
      NULL,
      NULL,
      0,
      0.728035,
      0,
      0,
      1,
      0,
      0,
      1,
      1.424398,
      1.978253,
      NULL,
      0,
      NULL,
      NULL,
      1.165168,
      0,
      NULL,
      NULL,
      11.960999,
      0.746123,
      0.851637,
      2.337256,
      2.994282,
      1,
      4.774050,
      1,
      6.043851,
      1.593000,
      3,
      10,
      0,
      11,
      4.562045,
      NULL,
      8,
      0.760860,
      NULL,
      NULL,
      NULL,
      ' 3-15-1991',
      26.554007,
      NULL,
      NULL,
      1,
      5,
      NULL,
      0.614366,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.990411,
      NULL,
      1.664472,
      1.750652,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      4.668380,
      1.299205,
      0.055150,
      1.245156,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.258311,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      7.781011,
      3,
      0,
      0.428137,
      NULL,
      NULL,
      NULL,
      3.211202,
      3.413369,
      3.474773,
      NULL,
      4,
      0,
      1,
      ' 9-26-1992',
      4,
      NULL,
      4.458459,
      0.183059,
      1,
      1,
      3,
      1,
      0.837696,
      0.170058,
      0.586051,
      NULL,
      1.107968,
      2,
      30.306006,
      NULL,
      3.685264,
      38,
      4,
      NULL,
      1,
      0.869367,
      2.876226,
      1,
      3,
      0.567406,
      1.989720,
      0.727061,
      NULL,
      2.518288,
      1,
      0.001301,
      3,
      2.441339,
      0.047801,
      NULL,
      1,
      2.122366,
      0,
      NULL,
      1.124856,
      1.285878,
      1,
      NULL,
      0,
      1.017982,
      0,
      0,
      0.795142,
      2,
      4.742557,
      0.195377,
      NULL,
      3.674599,
      7.439254,
      5,
      NULL,
      2,
      0,
      1,
      NULL,
      2.101590,
      1,
      1,
      55,
      1.988500,
      1.119911,
      NULL,
      NULL,
      26,
      67.018222,
      2.533716,
      5,
      3.987999,
      '12012',
      '',
      '',
      1.065641,
      '',
      '',
      '',
      1.151206,
      '',
      '',
      '',
      3,
      14,
      13,
      33,
      1.137902,
      50.253563,
      1,
      0.509775,
      1,
      2,
      NULL,
      1.553436,
      1,
      NULL,
      NULL,
      1.003182,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.440990,
      NULL,
      NULL,
      1.699532,
      NULL,
      NULL,
      0,
      0.644712,
      1.896864,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.329567,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3.016221,
      1,
      0,
      0,
      NULL,
      0.443355,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.126300,
      1.876614,
      1,
      1.699078,
      0.912698,
      0,
      0,
      NULL,
      0,
      2,
      NULL,
      1.487639,
      0.929304,
      3,
      0,
      1,
      0,
      1,
      0.573276,
      NULL,
      1.934978,
      NULL,
      NULL,
      NULL,
      NULL,
      7.277932,
      1,
      NULL,
      1,
      1.882652,
      NULL,
      NULL,
      NULL,
      3,
      1.481359,
      1.575455,
      2.733882,
      0.678794,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.121145,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.715442,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.066778,
      NULL,
      NULL,
      1.261836,
      NULL,
      NULL,
      0.000105,
      NULL,
      NULL,
      1.260741,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.254698,
      0.823361,
      0,
      NULL,
      NULL,
      4,
      1.932344,
      1.244535,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.439386,
      NULL,
      0.440291,
      3,
      NULL,
      2.673203,
      2.709585,
      NULL,
      NULL,
      1.615935,
      1.562842,
      NULL,
      1,
      0.432902,
      NULL,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.366322,
      3.918355,
      2,
      5.017658,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      3.505059,
      4,
      0.166726,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      0.778551,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.726024,
      NULL,
      NULL,
      0.285714,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.142986,
      NULL,
      NULL,
      3.251017,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.095574,
      NULL,
      NULL,
      1.282863,
      0,
      NULL,
      0.500272,
      3.551368,
      3,
      0.077588,
      NULL,
      0,
      NULL,
      0,
      NULL,
      13.820804,
      NULL,
      NULL,
      NULL,
      1.002047,
      NULL,
      NULL,
      NULL,
      3.476270,
      NULL,
      NULL,
      NULL,
      1.857947,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.986460,
      NULL,
      NULL,
      NULL,
      1.105110,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.606846,
      1.623423,
      0,
      NULL,
      1.290786,
      1.325671,
      1.679810,
      NULL,
      0,
      1.233822,
      3,
      NULL,
      3,
      3.807202,
      0.862939,
      NULL,
      2.900813,
      NULL,
      1,
      NULL,
      0,
      2,
      3,
      NULL,
      0.574220,
      NULL,
      0,
      NULL,
      9,
      6,
      NULL,
      NULL,
      2.683489,
      NULL,
      NULL,
      NULL,
      NULL,
      1.619017,
      20,
      5,
      0.062697,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.778557,
      NULL,
      0,
      77,
      NULL,
      1.760413,
      NULL,
      NULL,
      1,
      1.598445,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      1,
      1.201796,
      NULL,
      0.159538,
      0.826735,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.520615,
      0.048002,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.801998,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.408689,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.064410,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.463771,
      1.892256,
      NULL,
      1.628481,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.820715,
      NULL,
      0.507808,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.192712,
      0,
      2.243965,
      NULL,
      2,
      1,
      3.104614,
      NULL,
      3,
      2.251231,
      1.701559,
      NULL,
      0,
      0.828904,
      NULL,
      2.748944,
      0.891016,
      NULL,
      1.989037,
      1,
      3,
      0,
      1,
      1.367460,
      1,
      NULL,
      0,
      1.652445,
      0.256166,
      NULL,
      0,
      0,
      0,
      1,
      0.555306,
      1.005364,
      1,
      0.653687,
      NULL,
      0,
      1.925805,
      3.113153,
      1,
      1.913712,
      3.189463,
      0,
      3,
      1.651065,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.311648,
      0.048651,
      NULL,
      0.678246,
      1.443116,
      1.150276,
      3,
      7,
      7,
      0,
      0,
      3.458147,
      18.245877,
      108.565044,
      NULL,
      0.744904,
      0,
      '32140',
      '',
      NULL,
      0.690350,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


