set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9621028';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-7-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '1',
      NULL,
      NULL,
      '0310041',
      3,
      0.891097,
      NULL,
      3,
      '4413',
      3.581708,
      0.631996,
      NULL,
      NULL,
      '11- 0-1977',
      27.731622,
      NULL,
      0,
      2.845376,
      3.807273,
      ' 6-27-1989',
      10,
      3,
      257,
      133.801886,
      3.542952,
      ' 7-20-1990',
      ' 1-24-1977',
      NULL,
      2.931476,
      1.947404,
      0.143048,
      3.324860,
      0.151888,
      0.150826,
      1,
      1.614272,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      10,
      NULL,
      3.733283,
      0,
      NULL,
      1,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.240009,
      3.297530,
      NULL,
      3,
      2.942986,
      1.149230,
      1,
      5.330082,
      0.347971,
      0.815495,
      4.972000,
      1.141540,
      3,
      1.840147,
      1,
      0.769476,
      NULL,
      NULL,
      3.333463,
      0.446890,
      NULL,
      1.595831,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      1,
      0.756501,
      2,
      NULL,
      1,
      3,
      3.259245,
      2.032180,
      1.860379,
      3,
      NULL,
      1.707451,
      0,
      0,
      1,
      1,
      1,
      2,
      NULL,
      1.258540,
      3,
      NULL,
      NULL,
      1,
      3.372494,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.377731,
      0,
      0.460516,
      NULL,
      3.087405,
      0.866962,
      0,
      1,
      NULL,
      1.025328,
      0,
      0.331603,
      NULL,
      5.177595,
      0,
      0,
      1,
      NULL,
      0.701511,
      NULL,
      1,
      2,
      NULL,
      1.071339,
      NULL,
      1.176983,
      7,
      6.598676,
      0.278187,
      0.764488,
      4.966720,
      0,
      1,
      2.447819,
      3.100838,
      0.212240,
      NULL,
      2,
      NULL,
      2.390041,
      6,
      3.497997,
      1.739078,
      NULL,
      NULL,
      0,
      5.549117,
      NULL,
      ' 1-29-1993',
      94,
      ' 8-25-1986',
      NULL,
      2.509214,
      0.632925,
      1.127851,
      6.894412,
      0.785425,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.167219,
      NULL,
      0.017350,
      NULL,
      NULL,
      1,
      0.194442,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.532862,
      NULL,
      NULL,
      NULL,
      NULL,
      0.206469,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.990271,
      1,
      4,
      0.107466,
      0,
      NULL,
      0.944884,
      NULL,
      NULL,
      NULL,
      1.151742,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.256391,
      NULL,
      0.238043,
      NULL,
      1.246661,
      1,
      6.749380,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.682167,
      1.989376,
      3.298380,
      0.647693,
      NULL,
      2.763953,
      1,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      2,
      0.188986,
      1,
      0.343959,
      3,
      NULL,
      0,
      0.965653,
      0,
      1.970794,
      0,
      1.647868,
      0.752942,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      6.956370,
      0.829663,
      11.960566,
      9.322634,
      NULL,
      3.487098,
      0,
      5.061868,
      NULL,
      2.311558,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      37.435721,
      NULL,
      4,
      NULL,
      3.377202,
      '40202',
      '',
      '',
      0,
      NULL,
      '',
      NULL,
      0.252844,
      '',
      '',
      '',
      1,
      6,
      NULL,
      12.084439,
      1,
      16,
      7.416121,
      0.683745,
      0,
      NULL,
      0.955241,
      3,
      1.591941,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.170871,
      NULL,
      0.635577,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.358683,
      NULL,
      NULL,
      5,
      0,
      4.532050,
      0.980872,
      0.840773,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      2.179461,
      2,
      0,
      NULL,
      NULL,
      1.799122,
      NULL,
      NULL,
      0.067942,
      1,
      1,
      1.442714,
      0,
      2,
      2,
      1.827727,
      1.673913,
      NULL,
      2.243478,
      0.581738,
      1,
      3.702702,
      0,
      2,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.111631,
      NULL,
      NULL,
      9,
      5,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.349509,
      1,
      3.133788,
      NULL,
      NULL,
      0.952144,
      NULL,
      NULL,
      5,
      3,
      0.103576,
      3.399795,
      0,
      NULL,
      1.800612,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.774870,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.379872,
      NULL,
      NULL,
      1.053661,
      NULL,
      NULL,
      1,
      0,
      2,
      3.010726,
      NULL,
      1.627550,
      2.404144,
      5.679955,
      2.892651,
      7,
      NULL,
      0.513940,
      7.039387,
      5.529966,
      3,
      1.503914,
      3,
      2,
      2,
      0.687303,
      1,
      0,
      0.409873,
      0,
      7,
      2.628269,
      NULL,
      3.574620,
      0,
      2,
      0,
      2,
      0.927569,
      2.568337,
      0.321759,
      1.439932,
      2,
      1.579406,
      3.304079,
      0.153028,
      NULL,
      2,
      3.022564,
      2,
      4,
      NULL,
      0.395759,
      NULL,
      1,
      1.315733,
      1.448084,
      1.162356,
      1.533039,
      2.991154,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.026815,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.384294,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.901695,
      1.386392,
      1.131239,
      3.112729,
      0.080011,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.022257,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.683872,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.736260,
      NULL,
      NULL,
      NULL,
      0.240107,
      NULL,
      NULL,
      NULL,
      0.825655,
      NULL,
      NULL,
      NULL,
      2.390042,
      NULL,
      NULL,
      NULL,
      2.700395,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.390870,
      NULL,
      NULL,
      NULL,
      0.902866,
      NULL,
      NULL,
      NULL,
      4.138359,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.783263,
      55.761881,
      11,
      1.311821,
      NULL,
      NULL,
      0.079953,
      NULL,
      NULL,
      0.519385,
      NULL,
      NULL,
      0.968550,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.327886,
      37.283559,
      1.077902,
      0,
      0,
      1.012476,
      NULL,
      0,
      NULL,
      1,
      0.134180,
      1.280815,
      1.417878,
      0,
      0,
      1,
      0.086050,
      NULL,
      0.513099,
      1.122937,
      0.020482,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.271530,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.977083,
      0.964369,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.358248,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.344785,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.550153,
      3,
      NULL,
      1,
      NULL,
      0.014414,
      NULL,
      NULL,
      NULL,
      0.238955,
      NULL,
      NULL,
      NULL,
      0.207711,
      1.272851,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      1,
      0,
      3.685603,
      NULL,
      3,
      3,
      1,
      0,
      1.266615,
      NULL,
      0.469359,
      2,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3.547582,
      NULL,
      1,
      0.541272,
      NULL,
      0.542091,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.379428,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.236982,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      7,
      NULL,
      0.411115,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      3,
      '34404',
      NULL,
      '',
      0,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL);
commit;
end;
/


