set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9699006';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-7-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '31',
      10,
      NULL,
      '4204202',
      0.899234,
      1.852981,
      NULL,
      NULL,
      '3432',
      4,
      NULL,
      NULL,
      NULL,
      ' 2-18-2003',
      NULL,
      NULL,
      NULL,
      1.351086,
      3.363950,
      ' 4-27-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1- 7-2001',
      NULL,
      NULL,
      2,
      0.482786,
      2,
      2,
      0.029076,
      3,
      2,
      1,
      NULL,
      5,
      6.518190,
      11,
      1.228589,
      NULL,
      NULL,
      NULL,
      NULL,
      1.051057,
      0.120802,
      NULL,
      1,
      1,
      1.314173,
      1.645739,
      NULL,
      0.850298,
      0.002444,
      1,
      NULL,
      0,
      1.781852,
      2,
      3,
      2.063772,
      1.859056,
      11.358816,
      1,
      NULL,
      0,
      0,
      7.456563,
      2,
      NULL,
      10,
      6.345596,
      5,
      0,
      6.378644,
      0,
      NULL,
      3,
      NULL,
      1.770827,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.242028,
      7.840872,
      3.487857,
      3.099454,
      1,
      0.748463,
      0.523040,
      3,
      1,
      2,
      3,
      1.395240,
      NULL,
      2,
      NULL,
      0.271435,
      NULL,
      0.279262,
      1,
      1.660502,
      0.279702,
      1.547716,
      NULL,
      NULL,
      2,
      0.342347,
      0,
      NULL,
      NULL,
      0.890437,
      NULL,
      NULL,
      1.457014,
      1,
      2,
      NULL,
      NULL,
      3,
      1.930021,
      0,
      5,
      5,
      1.239310,
      0.529843,
      0,
      4.826129,
      1,
      0,
      0.027245,
      1.809308,
      1,
      NULL,
      0,
      0,
      1.550380,
      0,
      NULL,
      1.795465,
      0.969969,
      NULL,
      1.972758,
      NULL,
      1,
      0,
      1,
      1,
      1,
      1.906354,
      NULL,
      4.023388,
      11.943581,
      NULL,
      4,
      3,
      9.956627,
      0,
      0.539654,
      NULL,
      3,
      NULL,
      ' 6-10-1982',
      3.480200,
      ' 1-24-2003',
      14.918798,
      3.121273,
      1,
      0,
      NULL,
      1.556009,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.169583,
      1.217846,
      5.891157,
      0.807665,
      1.123263,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.395853,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.073292,
      3.174510,
      2.122100,
      3.662932,
      NULL,
      NULL,
      1,
      0,
      0.007449,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.309026,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.175295,
      0.555325,
      1.499453,
      1.940740,
      1.107481,
      NULL,
      2,
      4.260827,
      1,
      0.121959,
      NULL,
      NULL,
      NULL,
      2.072609,
      0,
      3.687774,
      2,
      NULL,
      2,
      3.188675,
      1,
      3,
      2.651542,
      1.690260,
      3.334894,
      NULL,
      1,
      NULL,
      0,
      0,
      0.639474,
      1.825836,
      3,
      0.150340,
      0,
      NULL,
      0.877717,
      0.801747,
      NULL,
      1,
      NULL,
      0.107911,
      1,
      2,
      NULL,
      9,
      9.221471,
      5.317513,
      NULL,
      2,
      7.261327,
      0,
      NULL,
      NULL,
      3.939555,
      2,
      2,
      62.884478,
      NULL,
      NULL,
      1.779735,
      NULL,
      31,
      NULL,
      5,
      NULL,
      2.244710,
      '44444',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.507388,
      '',
      '',
      '',
      NULL,
      20,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      1.784025,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.822043,
      NULL,
      NULL,
      1.025179,
      NULL,
      NULL,
      0.282415,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.558550,
      1.743772,
      NULL,
      NULL,
      1,
      0.147488,
      NULL,
      1.897406,
      0,
      0,
      NULL,
      0.257972,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.215538,
      NULL,
      1.819347,
      2,
      0,
      2,
      0.261658,
      0,
      5,
      1.915729,
      1.260890,
      1,
      1,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.527717,
      0.618749,
      NULL,
      2,
      1,
      NULL,
      0.879001,
      NULL,
      NULL,
      0.098565,
      0.972286,
      NULL,
      1,
      0.306808,
      NULL,
      1.954343,
      1,
      NULL,
      0.175444,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.976063,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.127366,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.247537,
      NULL,
      0,
      NULL,
      0.395902,
      NULL,
      0,
      2,
      4,
      1.736931,
      NULL,
      NULL,
      2.954000,
      45.944928,
      NULL,
      NULL,
      3.709403,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.286188,
      '',
      '',
      NULL);
commit;
end;
/


