set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9699006';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-10-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '3', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      5,
      NULL,
      3,
      3,
      1,
      NULL,
      1,
      2,
      '433',
      '40231310',
      4.217065,
      NULL,
      NULL,
      3,
      NULL,
      6,
      2,
      '0403',
      1,
      NULL,
      NULL,
      NULL,
      '11-12-1974',
      NULL,
      235.599355,
      NULL,
      1,
      NULL,
      '10-19-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      ' 3- 1-2003',
      2,
      0,
      1.562168,
      1,
      0.415071,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2.964474,
      2.424354,
      NULL,
      NULL,
      1.735604,
      0,
      0.363640,
      1.183471,
      0.389255,
      1.210846,
      1.122134,
      0.744282,
      0.372888,
      0.705387,
      1.566866,
      3,
      NULL,
      3.957715,
      3,
      1.729637,
      1.463396,
      1,
      NULL,
      1,
      NULL,
      0,
      4,
      2,
      3.451816,
      NULL,
      1,
      0,
      NULL,
      2,
      1.240137,
      1.497164,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.776624,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.835153,
      1,
      0,
      4,
      0.561021,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.606522,
      NULL,
      NULL,
      0.720566,
      0,
      NULL,
      0.686832,
      NULL,
      NULL,
      0.097591,
      0,
      0.483207,
      NULL,
      4.955094,
      NULL,
      1.497355,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      0,
      0.802014,
      5.793727,
      3,
      1.473085,
      0,
      NULL,
      0,
      NULL,
      1,
      0.391829,
      1.042985,
      0.247306,
      NULL,
      1,
      1.059397,
      0.375628,
      NULL,
      5,
      1,
      1,
      0,
      6.645617,
      2.574070,
      1.852528,
      NULL,
      0.035836,
      NULL,
      NULL,
      128,
      NULL,
      361.802540,
      3,
      1,
      0.205137,
      NULL,
      1.614584,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.470888,
      4,
      5.111598,
      1,
      1.053105,
      0.506352,
      0.761897,
      1.271176,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.279396,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3.208473,
      0,
      NULL,
      1.736862,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      1.040906,
      5,
      1.201070,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.813913,
      1,
      0,
      0.599647,
      1.515450,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.801335,
      1.269534,
      3,
      0.567894,
      NULL,
      3.337132,
      0,
      3,
      3,
      1,
      2.257065,
      2,
      3,
      2,
      3.812281,
      0,
      1,
      1.415976,
      1.122508,
      0.462527,
      0.285387,
      0.172070,
      NULL,
      NULL,
      0,
      0,
      0.849953,
      0.879438,
      0,
      NULL,
      NULL,
      1,
      1,
      4,
      4,
      6.469370,
      NULL,
      2,
      NULL,
      NULL,
      7,
      0.208880,
      1,
      1.167816,
      7.667870,
      3.702447,
      1.835197,
      NULL,
      NULL,
      NULL,
      NULL,
      3.662335,
      1.766844,
      0.777410,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      1.313468,
      24.927715,
      60.527201,
      12,
      1,
      2,
      NULL,
      0,
      NULL,
      0,
      1.892905,
      1.736590,
      1.936586,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.226411,
      NULL,
      0.773314,
      NULL,
      2.185252,
      NULL,
      1,
      NULL,
      0.952418,
      3,
      2,
      2.946702,
      0,
      3,
      3.965128,
      NULL,
      0.862740,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.961665,
      NULL,
      NULL,
      NULL,
      9,
      7.010050,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.092460,
      3,
      NULL,
      0,
      NULL,
      1,
      0.699736,
      3,
      NULL,
      0,
      NULL,
      1,
      2,
      NULL,
      2.307204,
      NULL,
      NULL,
      0.088266,
      2.988444,
      NULL,
      1,
      0.697203,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.923436,
      1.791929,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.642566,
      NULL,
      3,
      NULL,
      3,
      1.288828,
      0.225393,
      NULL,
      NULL,
      2.307904,
      5.421432,
      2,
      3.519970,
      0,
      3.889294,
      0.338630,
      1,
      3,
      1.172942,
      4.427352,
      5,
      1,
      NULL,
      NULL,
      1.370952,
      NULL,
      NULL,
      1.050362,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.381430,
      NULL,
      NULL,
      1,
      0.332627,
      3,
      1,
      0,
      7,
      0.595806,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.955525,
      NULL,
      NULL,
      2,
      1.842179,
      NULL,
      2,
      NULL,
      2.262796,
      5,
      7,
      NULL,
      3.531969,
      1.804082,
      0,
      2.780323,
      1,
      NULL,
      NULL,
      2,
      1,
      0.642140,
      3.852654,
      3,
      2,
      8.483421,
      6.979407,
      NULL,
      4.014137,
      3,
      1,
      3,
      5.405129,
      0,
      1,
      0.085279,
      0.414792,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.521722,
      NULL,
      NULL,
      1.366328,
      NULL,
      NULL,
      2.687458,
      NULL,
      NULL,
      2.716011,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.128809,
      0,
      1.882615,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.247495,
      NULL,
      NULL,
      NULL,
      0.971030,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.541018,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.756953,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.608607,
      NULL,
      1.428234,
      0.693615,
      NULL,
      NULL,
      1.612689,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.108383,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      320.092990,
      0,
      1,
      0.674171,
      0,
      1,
      1,
      1,
      0.447041,
      NULL,
      NULL,
      0.119984,
      1.908110,
      1,
      0.815042,
      0.517646,
      NULL,
      0,
      1.790009,
      0.767585,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.440806,
      5,
      3.770291,
      1.733943,
      NULL,
      1,
      1.856852,
      NULL,
      1.677613,
      2,
      2.185682,
      1,
      NULL,
      0,
      NULL,
      0.427198,
      NULL,
      NULL,
      0.650988,
      1.243876,
      NULL,
      1,
      0,
      NULL,
      1.608777,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.036075,
      1.055089,
      NULL,
      1,
      1.491489,
      NULL,
      0.008809,
      0.858769,
      NULL,
      NULL,
      0.162838,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.191616,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.644179,
      NULL,
      NULL,
      1.136083,
      NULL,
      NULL,
      56.562298,
      NULL,
      4,
      4,
      NULL,
      '14303',
      NULL,
      '',
      0,
      '',
      '',
      '',
      0.223589,
      '',
      '',
      '');
commit;
end;
/


