set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9699006';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-8-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1.340813,
      1.983199,
      1.229823,
      0,
      NULL,
      2.479577,
      2.466528,
      0.880752,
      '043',
      '03442003',
      51,
      30.042194,
      '4220004',
      0.718257,
      0.082450,
      NULL,
      3,
      '0202',
      5.305224,
      0.265171,
      NULL,
      NULL,
      '10- 4-2003',
      85,
      110.567973,
      NULL,
      3,
      1.220470,
      ' 2- 1-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      1.863771,
      ' 6- 7-1993',
      ' 5- 3-1978',
      '10-29-1996',
      1,
      1,
      2,
      1.133399,
      0.345205,
      NULL,
      NULL,
      1.585323,
      1.821489,
      3.074821,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.753871,
      NULL,
      0,
      NULL,
      0.352648,
      1.043421,
      0.850899,
      1.940754,
      0.075477,
      0.999424,
      NULL,
      0.303072,
      0.263681,
      NULL,
      1,
      3,
      NULL,
      7.975325,
      1.647626,
      1,
      0,
      1.774168,
      0.834477,
      4,
      1.678676,
      2.831567,
      1.424073,
      0,
      NULL,
      0.649167,
      0,
      0,
      0.651515,
      0,
      1.710737,
      NULL,
      NULL,
      0.526033,
      NULL,
      NULL,
      2.625146,
      1.456346,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.373394,
      NULL,
      2,
      1.301635,
      NULL,
      1,
      0.817549,
      1,
      NULL,
      NULL,
      1.884283,
      NULL,
      NULL,
      NULL,
      5,
      1,
      0.885296,
      3,
      6.689708,
      3.547682,
      NULL,
      1.338455,
      1.582073,
      1.720686,
      0.211652,
      0.224608,
      0.811274,
      1.436666,
      1.493930,
      0,
      1,
      1.305699,
      NULL,
      0,
      NULL,
      2,
      3,
      1.558697,
      1,
      7,
      1,
      NULL,
      1.770605,
      NULL,
      0.094880,
      1,
      NULL,
      0.976697,
      0,
      6,
      2.923875,
      5.609414,
      3.782738,
      7.088051,
      1.132145,
      NULL,
      3.007249,
      4.829334,
      4.158009,
      0.231047,
      2,
      ' 1-21-1992',
      93.735985,
      ' 7- 1-1998',
      244,
      0.250948,
      0.195605,
      0,
      NULL,
      0.413286,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.690706,
      1,
      0,
      0.271563,
      0.207877,
      NULL,
      1.532179,
      0.362697,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.716644,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.781366,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.941218,
      0.256930,
      1.806708,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.616961,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      0.358008,
      2,
      NULL,
      1,
      1.475319,
      NULL,
      NULL,
      NULL,
      0.620153,
      1,
      0.002688,
      NULL,
      2.710692,
      NULL,
      3,
      1.987677,
      0,
      0.857011,
      2,
      2,
      3,
      2,
      NULL,
      1,
      0,
      0,
      0,
      0.730035,
      0.835699,
      0.628603,
      NULL,
      1.167161,
      1,
      0,
      0.607921,
      0,
      0.501666,
      1,
      0,
      1.514122,
      1.526348,
      2.787112,
      2.742908,
      NULL,
      5,
      4,
      0,
      2,
      7.734808,
      3.256170,
      3,
      NULL,
      NULL,
      1.397872,
      3.629359,
      NULL,
      NULL,
      42,
      41,
      0,
      3,
      1.359036,
      '34034',
      NULL,
      NULL,
      1.891854,
      '',
      '',
      '',
      0.365912,
      '',
      '',
      '',
      2.358869,
      47,
      35.958228,
      29,
      0,
      3,
      3.815206,
      1.473491,
      1,
      3,
      1.805654,
      0.252114,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.129484,
      0.065432,
      0.609659,
      NULL,
      0.893454,
      1.142439,
      2.375755,
      1,
      1,
      0.661780,
      2.070718,
      3,
      2,
      3.721865,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      2,
      1.777470,
      NULL,
      NULL,
      1.601200,
      NULL,
      7,
      0.139045,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.366810,
      1.310688,
      0,
      1.392619,
      1.839998,
      1,
      1,
      2,
      0,
      0,
      1.302001,
      0.524421,
      2,
      2.462327,
      NULL,
      1,
      NULL,
      3,
      NULL,
      2,
      0,
      0,
      1.626098,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.755440,
      1,
      0.545014,
      0,
      6,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.557037,
      NULL,
      NULL,
      NULL,
      1.444745,
      NULL,
      NULL,
      NULL,
      2.670661,
      1,
      2,
      3,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.283234,
      NULL,
      3.859285,
      NULL,
      NULL,
      NULL,
      3,
      4,
      NULL,
      1.958623,
      NULL,
      NULL,
      1.729627,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.999131,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.208945,
      NULL,
      NULL,
      0.728634,
      1.296787,
      NULL,
      NULL,
      3,
      0.115858,
      0.649556,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0.321732,
      1.485991,
      3.807697,
      4,
      1.131062,
      3.971775,
      0,
      NULL,
      1,
      3,
      3,
      0,
      3,
      1.545055,
      3,
      0,
      3,
      3.640302,
      1.610263,
      5.532956,
      6.875915,
      1,
      0,
      3,
      2,
      NULL,
      6,
      1,
      0,
      NULL,
      0,
      1,
      2.702397,
      NULL,
      NULL,
      1.811614,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.893233,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.940539,
      NULL,
      NULL,
      2.328822,
      NULL,
      NULL,
      1.982814,
      NULL,
      NULL,
      0,
      0.816960,
      0.277846,
      1.853147,
      1,
      1.594131,
      0,
      NULL,
      NULL,
      0.058581,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.168196,
      NULL,
      NULL,
      NULL,
      2.078123,
      NULL,
      NULL,
      NULL,
      1.595761,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.138520,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.950105,
      NULL,
      NULL,
      NULL,
      3.357781,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      1.415136,
      NULL,
      NULL,
      NULL,
      1,
      6.351321,
      5,
      0.074178,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      181,
      NULL,
      0.226830,
      0,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      1.416673,
      0,
      1.361325,
      1.550601,
      1.386638,
      NULL,
      0.838087,
      1.272482,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.994966,
      NULL,
      NULL,
      1.329001,
      1,
      NULL,
      2.070411,
      6.890826,
      2.626067,
      0.199035,
      1.101819,
      NULL,
      0,
      NULL,
      0.371037,
      0.716637,
      NULL,
      NULL,
      1.523353,
      NULL,
      0,
      0.346416,
      NULL,
      1.715616,
      0.508607,
      NULL,
      0,
      1,
      NULL,
      3,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.520205,
      0.753066,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      3,
      0.181402,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.059460,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.001800,
      NULL,
      0,
      NULL,
      0,
      3.946725,
      2,
      1,
      NULL,
      NULL,
      8.054107,
      106.966543,
      NULL,
      2.482389,
      NULL,
      NULL,
      '',
      NULL,
      0.384256,
      '',
      NULL,
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


