set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9026888';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-10-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '3',
      NULL,
      NULL,
      '1402211',
      NULL,
      0.068409,
      NULL,
      1,
      '3441',
      3,
      1.877148,
      NULL,
      NULL,
      ' 4-26-1974',
      13,
      NULL,
      4.340356,
      3,
      1,
      NULL,
      8,
      3,
      296,
      16.577732,
      0,
      ' 4-25-2000',
      '10- 2-1982',
      ' 9-15-2003',
      3,
      2,
      0.574995,
      1,
      NULL,
      3,
      7,
      0,
      0,
      2,
      6.676429,
      6.701223,
      10.482209,
      NULL,
      13,
      NULL,
      24.643958,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.803956,
      3,
      5.738052,
      1.977392,
      NULL,
      NULL,
      1.617507,
      1,
      2.411900,
      3.851544,
      NULL,
      2,
      2.189326,
      NULL,
      NULL,
      0,
      2,
      NULL,
      4,
      0.221308,
      2,
      0.560639,
      NULL,
      NULL,
      1.543134,
      NULL,
      NULL,
      NULL,
      6,
      8,
      3,
      1,
      0,
      2,
      3,
      1,
      NULL,
      0.592963,
      0,
      NULL,
      0.032783,
      NULL,
      1,
      0.743749,
      NULL,
      2.645418,
      4.771345,
      NULL,
      0,
      2.414659,
      NULL,
      NULL,
      2.694269,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.225539,
      0.768109,
      NULL,
      0.724417,
      NULL,
      0.084479,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.705080,
      NULL,
      5,
      0,
      0,
      0.626308,
      0.510749,
      0.577531,
      NULL,
      1.584562,
      0.877307,
      3.547207,
      0,
      0,
      0,
      5.260581,
      1.832823,
      1,
      0.939828,
      0.904402,
      4,
      5,
      3,
      1.918940,
      5.786021,
      4.817658,
      7.283901,
      3,
      11,
      NULL,
      7,
      1.117565,
      4.659195,
      2.601163,
      NULL,
      4,
      1.517864,
      NULL,
      367.382448,
      ' 6-17-1994',
      122,
      2.212792,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.467556,
      0,
      1.110818,
      0.862760,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.870868,
      1,
      2.501029,
      4.264536,
      NULL,
      1,
      NULL,
      0.061514,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.633689,
      4.492358,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.792332,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.666297,
      NULL,
      3.463785,
      0.259671,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      3.570270,
      NULL,
      0.061710,
      0.963396,
      1,
      1,
      2.222279,
      0.098770,
      0.681804,
      0.414220,
      NULL,
      0.594389,
      0,
      10.568326,
      1,
      1,
      6.530223,
      0,
      0.505461,
      0,
      0.766509,
      0,
      3,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      3.623602,
      2,
      4.787681,
      11,
      3.160195,
      5,
      1,
      2.663869,
      3.087401,
      3,
      NULL,
      0,
      47.845995,
      0,
      1,
      NULL,
      33.768569,
      46.588747,
      9,
      3,
      0.813921,
      NULL,
      '44420',
      '',
      '',
      1.872256,
      '',
      '',
      '',
      0.931542,
      '',
      '',
      '',
      3,
      34,
      157.189247,
      29,
      2.891251,
      10,
      0.967983,
      0,
      4,
      0.677124,
      2,
      2,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      3.172967,
      1.796247,
      NULL,
      NULL,
      2,
      0,
      0.853190,
      NULL,
      NULL,
      NULL,
      1.233219,
      3.319702,
      1,
      0.186963,
      NULL,
      NULL,
      NULL,
      3.805933,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.673080,
      NULL,
      NULL,
      NULL,
      0.429470,
      1,
      NULL,
      2,
      NULL,
      NULL,
      0.215882,
      1.505834,
      1,
      1,
      0.564498,
      NULL,
      1.531033,
      1.201001,
      NULL,
      0,
      1,
      NULL,
      1,
      0.310448,
      NULL,
      1,
      3,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      3,
      1.693189,
      7.311939,
      1,
      6,
      0,
      0.035156,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.525207,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.357666,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.547358,
      0.177457,
      0.814679,
      NULL,
      NULL,
      NULL,
      1.238157,
      1,
      NULL,
      0.031184,
      NULL,
      NULL,
      0.723342,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.613541,
      NULL,
      NULL,
      0.063480,
      NULL,
      NULL,
      NULL,
      NULL,
      0.661986,
      2,
      NULL,
      1.515471,
      1,
      1.425688,
      1.306122,
      NULL,
      NULL,
      1,
      0.911026,
      NULL,
      NULL,
      NULL,
      1.059115,
      NULL,
      0,
      0,
      NULL,
      2,
      1.987018,
      2,
      3.950070,
      1.156471,
      5,
      2,
      0.997238,
      3,
      NULL,
      NULL,
      2.638116,
      1.220713,
      0.857498,
      2.165507,
      2,
      0.829570,
      0.830414,
      9,
      0,
      NULL,
      NULL,
      1,
      0.108728,
      2,
      2,
      NULL,
      NULL,
      1.962739,
      0.009800,
      1.173353,
      0,
      2.920106,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.879288,
      NULL,
      NULL,
      1.786075,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.887162,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.252916,
      0.577221,
      0.438918,
      3.968378,
      1.772010,
      NULL,
      NULL,
      0.639905,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.161893,
      NULL,
      NULL,
      NULL,
      1.091350,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.848355,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.125929,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.221526,
      NULL,
      NULL,
      NULL,
      NULL,
      106,
      50.883874,
      NULL,
      NULL,
      NULL,
      0.338945,
      NULL,
      NULL,
      0.648624,
      1,
      1.291112,
      1.005759,
      NULL,
      NULL,
      1.921947,
      NULL,
      NULL,
      0,
      NULL,
      0.437810,
      201,
      13.635339,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      0.380442,
      1.354864,
      0.937344,
      0.600578,
      0,
      1,
      1,
      1.221328,
      NULL,
      1.441385,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.419297,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.737687,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.284958,
      1,
      NULL,
      NULL,
      NULL,
      1.929570,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.947506,
      NULL,
      1.502232,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.951549,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.744170,
      2.392734,
      0,
      0,
      3,
      1,
      0.432447,
      NULL,
      NULL,
      0,
      0.205724,
      0,
      1,
      NULL,
      NULL,
      0.026896,
      0.131349,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      1.577083,
      2.515732,
      NULL,
      7,
      1.895066,
      3,
      1.718079,
      1,
      1.441504,
      NULL,
      1,
      0.347845,
      NULL,
      2,
      0.355675,
      NULL,
      0.309162,
      0.309569,
      NULL,
      NULL,
      0.964596,
      NULL,
      0.417273,
      0,
      NULL,
      0.923099,
      1.297936,
      NULL,
      0,
      0.890851,
      NULL,
      0.998384,
      1.548573,
      NULL,
      0,
      1,
      NULL,
      1.924120,
      0.931373,
      NULL,
      2.053321,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.185714,
      NULL,
      NULL,
      NULL,
      7,
      2.164838,
      1,
      NULL,
      1.185736,
      3.559855,
      47.096535,
      22,
      NULL,
      NULL,
      1.647115,
      '32111',
      NULL,
      '',
      1,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


