set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8726488';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1987-9-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      '4123441',
      0,
      0.148929,
      0,
      3,
      '1310',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1- 3-1980',
      39,
      NULL,
      NULL,
      0,
      1.477264,
      '11-26-1979',
      4.215761,
      1.457325,
      274,
      NULL,
      NULL,
      ' 6-17-1996',
      ' 8-23-1978',
      NULL,
      NULL,
      NULL,
      3,
      2,
      1.067390,
      0,
      3.053849,
      0.344085,
      NULL,
      6.257267,
      10.079865,
      19,
      3.038867,
      26.077477,
      2.785139,
      2.912815,
      23,
      3.649025,
      1.961909,
      3,
      1,
      0.012471,
      0,
      NULL,
      1,
      1.019902,
      0,
      NULL,
      0,
      1.078090,
      1.907126,
      1,
      5,
      3.919309,
      2,
      5.619155,
      NULL,
      0,
      0.151870,
      NULL,
      2,
      1,
      1,
      NULL,
      7,
      5.013936,
      0.192100,
      7.665613,
      0,
      NULL,
      3,
      3.157274,
      1.580277,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      3.349633,
      0,
      1,
      1,
      3.041466,
      2.210408,
      1.965672,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.801642,
      NULL,
      NULL,
      NULL,
      3.747439,
      1.649244,
      0,
      0.926759,
      NULL,
      0,
      3,
      1.404036,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.348256,
      3.010205,
      2.664014,
      1.017617,
      1.560724,
      0,
      NULL,
      NULL,
      1.510685,
      1,
      1,
      NULL,
      0.442096,
      1.163321,
      0,
      0.020634,
      1.957799,
      NULL,
      NULL,
      0,
      4,
      0,
      1.204415,
      3.715025,
      NULL,
      NULL,
      3,
      1.855147,
      2,
      6,
      1.016600,
      NULL,
      2.796377,
      0,
      0,
      2.361669,
      4,
      2.338278,
      3.828929,
      0,
      1.735041,
      7,
      8,
      2.769245,
      NULL,
      0,
      0,
      '10- 7-1995',
      25.995550,
      ' 1- 6-1993',
      77.084787,
      1,
      3,
      0.022519,
      NULL,
      1.252130,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.017104,
      0.368831,
      0,
      1.927412,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.309805,
      NULL,
      24,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.219972,
      1.280312,
      0.638943,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      3,
      3,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.808206,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.412756,
      1.364349,
      1,
      1,
      0.384262,
      1,
      1.903960,
      3.782864,
      22.529602,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0,
      2,
      2.529731,
      1.353827,
      1.697553,
      2.214725,
      3.213856,
      NULL,
      3.442419,
      2,
      1,
      NULL,
      3,
      1,
      3,
      1.477415,
      1,
      NULL,
      0.817998,
      3,
      1,
      0.872073,
      NULL,
      0,
      0,
      1,
      0,
      1.514647,
      0,
      2.784044,
      0,
      2.377905,
      8.422493,
      5,
      8.208905,
      9,
      NULL,
      5,
      NULL,
      NULL,
      1,
      3.388819,
      3.574575,
      23,
      2.655656,
      NULL,
      NULL,
      28.573715,
      23.778196,
      42.548956,
      NULL,
      0.903346,
      2.634433,
      NULL,
      '',
      '',
      1.434371,
      '',
      '',
      '',
      3.897719,
      NULL,
      NULL,
      NULL,
      1.472891,
      32.577143,
      2.055997,
      NULL,
      3,
      25,
      1.846768,
      2.860101,
      0.283263,
      0,
      0.380508,
      0.699872,
      0,
      NULL,
      NULL,
      0.048986,
      2.641625,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.854268,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.022872,
      NULL,
      2,
      3.900189,
      3.328901,
      3.110774,
      1,
      3,
      0,
      NULL,
      NULL,
      1,
      7.347200,
      9.619334,
      1,
      0.526724,
      NULL,
      NULL,
      NULL,
      2.576049,
      1.788064,
      3.205321,
      3.116312,
      1,
      2,
      3,
      NULL,
      2.417315,
      NULL,
      2,
      0,
      2,
      0.795256,
      NULL,
      0,
      0.311203,
      2,
      2,
      0.674949,
      1,
      NULL,
      0,
      3,
      0,
      NULL,
      3,
      2.092018,
      0.056465,
      1.298290,
      NULL,
      NULL,
      1.458542,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6.049308,
      2.162258,
      5,
      0.636498,
      0,
      NULL,
      NULL,
      NULL,
      2.613426,
      1.978472,
      0,
      3.922905,
      NULL,
      NULL,
      NULL,
      0.550911,
      NULL,
      NULL,
      0.970508,
      0,
      0.959350,
      0.522693,
      NULL,
      NULL,
      7.941441,
      7.478068,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.518681,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      3.608095,
      0,
      1,
      3,
      1.520546,
      NULL,
      NULL,
      1,
      0.925643,
      1,
      0,
      NULL,
      NULL,
      2.716497,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.973935,
      NULL,
      NULL,
      NULL,
      2.888791,
      0,
      0,
      3,
      0,
      6,
      4.768824,
      3,
      3.645734,
      NULL,
      NULL,
      NULL,
      0,
      6.055344,
      0,
      1,
      1.358259,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.794076,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.085307,
      NULL,
      NULL,
      0.707818,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.835620,
      0.384960,
      1,
      0,
      0,
      2.972813,
      0,
      NULL,
      6.563649,
      1,
      NULL,
      NULL,
      1.416316,
      NULL,
      NULL,
      NULL,
      0.136434,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.736195,
      0.525586,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.721529,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.778530,
      NULL,
      NULL,
      1,
      1.190990,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.497624,
      NULL,
      NULL,
      NULL,
      2,
      1.738254,
      NULL,
      NULL,
      2.175553,
      1.905402,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      0.533774,
      NULL,
      NULL,
      8.669624,
      1.120684,
      3,
      12.621570,
      11.848835,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      1.321930,
      NULL,
      NULL,
      0.811215,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.202652,
      NULL,
      1.892726,
      8403.737832,
      1833.835882,
      0.577958,
      0,
      0,
      1,
      0,
      1,
      0,
      1.900465,
      1.899160,
      0.241296,
      0.781854,
      1,
      NULL,
      NULL,
      0,
      1.107547,
      0.226456,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      1.547045,
      2,
      NULL,
      2,
      0.048754,
      0.916523,
      0,
      2.983297,
      1.333920,
      2.437137,
      0.153924,
      NULL,
      NULL,
      0,
      NULL,
      0.373116,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.753107,
      3,
      NULL,
      1.424614,
      0,
      NULL,
      NULL,
      0.729079,
      NULL,
      0.256851,
      0,
      NULL,
      0,
      0,
      NULL,
      1.482583,
      NULL,
      NULL,
      NULL,
      0.544077,
      NULL,
      0,
      1.840442,
      3,
      2.087287,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.893836,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.586433,
      NULL,
      0,
      NULL,
      2.974415,
      NULL,
      1.031063,
      NULL,
      NULL,
      NULL,
      62,
      0,
      NULL,
      1.288229,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      6,
      1.336257,
      2,
      NULL,
      NULL,
      NULL,
      26,
      NULL,
      2,
      NULL,
      2.336168,
      NULL,
      '',
      '',
      0.442008,
      '',
      '',
      '',
      NULL,
      NULL,
      '21203',
      '');
commit;
end;
/


