set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9409102';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-4-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      '4332221',
      2,
      0,
      3,
      2,
      '1431',
      1,
      1,
      NULL,
      NULL,
      ' 8- 5-1975',
      30.147864,
      NULL,
      0,
      0.677426,
      3,
      ' 8-29-1988',
      NULL,
      0.126511,
      NULL,
      94,
      NULL,
      ' 2-10-1997',
      ' 0-19-1978',
      ' 0- 3-1996',
      2,
      3,
      3.137415,
      NULL,
      1,
      1.883713,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2.525362,
      21.769389,
      4,
      NULL,
      22.757499,
      NULL,
      NULL,
      1.822535,
      1.347068,
      1.076363,
      0.361086,
      NULL,
      NULL,
      NULL,
      0.641856,
      1.176590,
      1,
      2,
      0.873087,
      5.865591,
      NULL,
      12,
      NULL,
      6,
      0,
      3,
      NULL,
      5,
      5.343343,
      5,
      2.171998,
      7.302309,
      0,
      6.855537,
      NULL,
      8.641532,
      1,
      NULL,
      3.857180,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7.121680,
      NULL,
      NULL,
      2.845822,
      NULL,
      0,
      2.520431,
      NULL,
      3,
      NULL,
      1,
      NULL,
      0,
      0,
      1.450182,
      0.130678,
      3.244158,
      NULL,
      0,
      0.083079,
      1,
      NULL,
      3.755239,
      NULL,
      1.754887,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      NULL,
      5,
      4,
      3,
      3.929168,
      NULL,
      0,
      4,
      1.319932,
      5.290402,
      0,
      1,
      5,
      1,
      1.716435,
      0,
      NULL,
      0,
      NULL,
      0.406115,
      1.581617,
      5,
      1.205621,
      1,
      NULL,
      3.310456,
      1.709898,
      0.656733,
      1,
      1.843131,
      0,
      1.693735,
      NULL,
      1.905085,
      6.246136,
      7,
      6.791045,
      4,
      1.962736,
      1,
      3,
      6.867136,
      NULL,
      2,
      NULL,
      0.693776,
      3,
      ' 4- 4-2003',
      29,
      ' 6- 3-1976',
      9,
      NULL,
      2.442881,
      1.702620,
      2.432797,
      3.977257,
      NULL,
      7.895476,
      0,
      0,
      NULL,
      1.881904,
      4,
      NULL,
      0,
      2,
      0,
      0,
      NULL,
      0.809004,
      5.764783,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2.387082,
      NULL,
      0.842886,
      0.021930,
      NULL,
      NULL,
      4.304923,
      0.991845,
      0.625575,
      0.667201,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      6.611529,
      4.824693,
      7,
      NULL,
      0,
      NULL,
      NULL,
      0.535209,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.950530,
      NULL,
      0.074182,
      2,
      1,
      0.039055,
      0.457583,
      1.099817,
      50.404281,
      1.465559,
      0,
      NULL,
      NULL,
      NULL,
      0.829328,
      0,
      2.531342,
      1.392376,
      3,
      1.441080,
      2.330739,
      3.604745,
      3.971879,
      2.078481,
      1,
      0.612827,
      0.996349,
      3.688586,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.847247,
      1,
      NULL,
      0,
      0.019049,
      0.733460,
      1,
      0,
      1,
      0,
      1.781069,
      3.094613,
      7,
      NULL,
      6.028735,
      8,
      1.170231,
      5,
      3,
      4,
      3,
      1.675616,
      0,
      17.344185,
      2.754948,
      2.916353,
      NULL,
      25,
      39.742784,
      61.491250,
      5,
      1,
      3,
      '42201',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.909168,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.735823,
      3,
      0,
      0,
      NULL,
      NULL,
      0.750760,
      NULL,
      NULL,
      2.253957,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      62.850854,
      3,
      0.034555,
      1.859472,
      0,
      NULL,
      NULL,
      0.630792,
      1.101127,
      0,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      0.576445,
      1.138112,
      1.267634,
      0.122202,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.461771,
      1.156079,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.698481,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.912753,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.508848,
      0.013758,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      1.454790,
      1.883432,
      NULL,
      NULL,
      0.283780,
      1.318393,
      1,
      NULL,
      NULL,
      1.546942,
      1,
      1.320005,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.393718,
      1,
      0,
      0,
      NULL,
      0,
      0,
      1,
      0,
      1.538417,
      1,
      1.963066,
      0.166450,
      NULL,
      NULL,
      1.230962,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.044410,
      NULL,
      1,
      0.728535,
      NULL,
      NULL,
      1,
      NULL,
      0.679831,
      1.947211,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.230861,
      0,
      NULL,
      1.978566,
      0.704424,
      NULL,
      1.026456,
      1.863927,
      0.017933,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.846324,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.328079,
      NULL,
      NULL,
      NULL,
      0.459354,
      0,
      3,
      1,
      NULL,
      NULL,
      61.724658,
      NULL,
      2.035984,
      1.177067,
      1.613055,
      '10013',
      '',
      '',
      1.686936,
      '',
      '',
      NULL,
      1,
      NULL,
      '',
      '');
commit;
end;
/


