set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6502559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-2-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '0',
      NULL,
      NULL,
      '2010121',
      0.590576,
      1.382547,
      5,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      ' 6-15-1994',
      NULL,
      NULL,
      0.502185,
      3.535403,
      0,
      ' 9- 9-2000',
      32.590252,
      3.893096,
      124.921752,
      NULL,
      2.058158,
      ' 1- 1-1980',
      NULL,
      ' 9-15-1991',
      3,
      0,
      1,
      NULL,
      0,
      NULL,
      3,
      NULL,
      NULL,
      1,
      0,
      16,
      4.823582,
      17.666642,
      27,
      0,
      NULL,
      3,
      1,
      0,
      0,
      5,
      0.097815,
      1,
      0.074336,
      NULL,
      1.843152,
      2,
      NULL,
      0,
      NULL,
      NULL,
      4.388816,
      1.668366,
      NULL,
      5.009946,
      1.400557,
      3,
      0.186878,
      1,
      NULL,
      2.683806,
      5.623761,
      0.732684,
      0,
      5.995452,
      0.544247,
      4,
      0,
      5,
      1.300923,
      3,
      0,
      NULL,
      NULL,
      0,
      1,
      4,
      NULL,
      8,
      9,
      2.078599,
      1.093300,
      1,
      1.626510,
      0.237417,
      1.378966,
      0,
      1,
      1,
      0,
      3,
      NULL,
      2.637197,
      1.698144,
      1,
      1.581263,
      NULL,
      NULL,
      3.774762,
      11.253411,
      1.461486,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      1.720476,
      2.130494,
      0.475588,
      9,
      1,
      NULL,
      1,
      2,
      NULL,
      5.718072,
      1,
      0,
      2,
      0,
      NULL,
      NULL,
      3.507983,
      0,
      NULL,
      2.112830,
      1.125819,
      0,
      0.947599,
      0,
      NULL,
      3,
      NULL,
      4,
      7,
      1,
      0,
      NULL,
      7,
      0,
      8.795453,
      0,
      6,
      NULL,
      NULL,
      NULL,
      8.878291,
      2.304675,
      7,
      11,
      9.582860,
      0,
      0.609793,
      NULL,
      713,
      NULL,
      67,
      2,
      0,
      NULL,
      4.464512,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.843010,
      1,
      5.052014,
      3.611785,
      0,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      41,
      0,
      NULL,
      2.584358,
      2,
      3,
      0.298252,
      0.517327,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.818689,
      0,
      4.681275,
      1.400671,
      7,
      5.658329,
      5,
      NULL,
      4,
      1,
      NULL,
      NULL,
      0.134686,
      NULL,
      0.526129,
      1,
      8.343437,
      NULL,
      2,
      ' 3-12-1995',
      19,
      ' 2-11-1985',
      31,
      0,
      0.280879,
      1.047885,
      3.557184,
      3,
      0,
      1.184605,
      NULL,
      NULL,
      1.768879,
      NULL,
      60,
      2,
      1.854896,
      NULL,
      NULL,
      NULL,
      0,
      0.596102,
      1,
      NULL,
      2,
      0,
      2,
      0.862712,
      3.656443,
      0,
      1,
      3,
      NULL,
      3,
      0.844286,
      0,
      1.131729,
      0,
      0.052455,
      3,
      1,
      1.917989,
      0,
      0,
      0,
      1.406594,
      1,
      0.797153,
      0,
      NULL,
      1.005546,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      16,
      40,
      NULL,
      0,
      3,
      '11243',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      0,
      3,
      59,
      47.465276,
      0.952344,
      29,
      1,
      3.236309,
      3,
      1,
      3,
      0,
      1,
      NULL,
      NULL,
      3.201779,
      3,
      3.494061,
      NULL,
      0.544988,
      NULL,
      3.483762,
      2.802828,
      0,
      1.744629,
      2.289470,
      1.996206,
      1.216122,
      3.702365,
      0,
      NULL,
      3,
      3,
      2.584509,
      2.620819,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      2,
      1,
      NULL,
      NULL,
      8,
      2.219799,
      2.336681,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.786288,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0.250952,
      NULL,
      NULL,
      0.497595,
      0.763970,
      0.813685,
      3.062718,
      3.535687,
      NULL,
      1.464083,
      NULL,
      0.801817,
      0.633999,
      1,
      1,
      0,
      1,
      2.905492,
      NULL,
      0.663738,
      0,
      NULL,
      NULL,
      1,
      1.147369,
      1,
      2.003604,
      NULL,
      5,
      0.236947,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.559711,
      NULL,
      NULL,
      2,
      2.528677,
      1,
      0.169808,
      1.675120,
      3.505086,
      NULL,
      NULL,
      NULL,
      9.189086,
      0.613291,
      NULL,
      0,
      3,
      1.599772,
      2.689135,
      1.159100,
      1.968454,
      4,
      5,
      1.564222,
      1,
      NULL,
      NULL,
      1.708548,
      NULL,
      NULL,
      1.635613,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.161652,
      NULL,
      NULL,
      0.605983,
      NULL,
      NULL,
      2.734759,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      3.992929,
      6.518086,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.755532,
      0,
      NULL,
      NULL,
      0.928713,
      1.988366,
      2,
      3,
      2,
      1.197459,
      0.203055,
      1.655281,
      0.749650,
      1.870304,
      2.841015,
      NULL,
      0,
      1.322805,
      2,
      1.626280,
      4,
      0.643400,
      NULL,
      11,
      6.251631,
      6.894797,
      1,
      2.247565,
      NULL,
      1.066274,
      NULL,
      1.732129,
      NULL,
      1.057838,
      1.305049,
      NULL,
      NULL,
      0.054337,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.452936,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.842449,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.205659,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.980746,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      0.358623,
      0,
      0.934916,
      0.180698,
      1.391210,
      NULL,
      0,
      NULL,
      NULL,
      6.363148,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.824933,
      NULL,
      NULL,
      NULL,
      0.304140,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.241315,
      NULL,
      NULL,
      NULL,
      0.230311,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.884542,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      1.039813,
      NULL,
      NULL,
      NULL,
      2.252034,
      10.792950,
      20,
      0.341370,
      9,
      NULL,
      3.524506,
      NULL,
      441,
      3,
      17.600879,
      NULL,
      3.487052,
      1902.553562,
      314,
      NULL,
      NULL,
      NULL,
      2,
      17.599912,
      0.203937,
      13190.161391,
      NULL,
      0.105581,
      1,
      NULL,
      0.697353,
      0,
      NULL,
      0.240056,
      1,
      NULL,
      1.059172,
      0,
      1.606392,
      0,
      0,
      0,
      0,
      NULL,
      0.638776,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.442082,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.970650,
      0.478493,
      1.062234,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.298037,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.948213,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.599476,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.617611,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.508741,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.925701,
      0,
      0.740679,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.678047,
      0,
      0.720334,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      0,
      4,
      0.295056,
      0.203448,
      0,
      NULL,
      0,
      2,
      NULL,
      1,
      1,
      NULL,
      3,
      2,
      NULL,
      1.099170,
      1.468611,
      NULL,
      NULL,
      1.680416,
      NULL,
      0.588911,
      1,
      NULL,
      0,
      NULL,
      NULL,
      2.667408,
      1,
      NULL,
      NULL,
      1.330605,
      NULL,
      0,
      1.882754,
      NULL,
      NULL,
      NULL,
      NULL,
      1.444835,
      1,
      NULL,
      NULL,
      1,
      2.832913,
      2.827748,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.434397,
      NULL,
      0.463315,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.888817,
      NULL,
      0.392584,
      NULL,
      125.976243,
      0,
      NULL,
      3.072713,
      2.623009,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.082141,
      NULL,
      1,
      NULL,
      2,
      NULL,
      0.968111,
      NULL,
      0.167566,
      NULL,
      2.420860,
      NULL,
      0.769859,
      NULL,
      0.556377,
      NULL,
      1.001986,
      NULL,
      110,
      1.913799,
      NULL,
      1.528641,
      NULL,
      NULL,
      NULL,
      1.682371,
      NULL,
      7.404700,
      6.785957,
      3.651431,
      1,
      NULL,
      NULL,
      45,
      55.951437,
      2.074702,
      0.078527,
      NULL,
      '42303',
      NULL,
      '',
      3.047214,
      '20010',
      '',
      '',
      0,
      '',
      '',
      NULL);
commit;
end;
/


