set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6502559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-5-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      4.095688,
      1,
      NULL,
      NULL,
      '1302',
      1,
      0.165460,
      NULL,
      NULL,
      NULL,
      53,
      NULL,
      4,
      3.409626,
      1,
      ' 0- 0-1986',
      4,
      2,
      313,
      52.235823,
      0.796020,
      ' 5-22-1993',
      ' 3-25-1978',
      ' 0-18-1996',
      0.489043,
      3,
      3.742434,
      0.798202,
      0,
      NULL,
      3.581807,
      1.650644,
      0,
      11.967430,
      7.172420,
      1.209286,
      1,
      23.057904,
      NULL,
      1,
      4.588543,
      NULL,
      4,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      5,
      2.393722,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      4.992134,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      4.595258,
      2.541446,
      1.613016,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.019281,
      NULL,
      3,
      2,
      1.813951,
      3.220516,
      NULL,
      1,
      2,
      1.262338,
      3.886853,
      0,
      0.995155,
      2,
      0,
      1.572538,
      NULL,
      9.123068,
      1.491977,
      NULL,
      NULL,
      1.756984,
      4,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.799742,
      1.681084,
      0,
      0.199892,
      1.431060,
      1,
      1,
      1.983688,
      1,
      NULL,
      NULL,
      0,
      1.290967,
      0,
      1.645522,
      1,
      NULL,
      1,
      0.274704,
      NULL,
      1,
      1.149657,
      1.769676,
      0.922634,
      0.887595,
      1.866257,
      NULL,
      1.951048,
      NULL,
      0.272008,
      NULL,
      0.992914,
      0,
      4.071074,
      NULL,
      NULL,
      6,
      8.005182,
      1.049318,
      9,
      7.739647,
      1,
      5,
      NULL,
      NULL,
      1.477444,
      NULL,
      0.106024,
      NULL,
      1,
      ' 1-28-1992',
      3.044070,
      0.206693,
      1,
      1.609479,
      3.096578,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.826169,
      0.175165,
      5,
      6.029867,
      1.323968,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      2,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.712074,
      3,
      3,
      3.613279,
      NULL,
      NULL,
      1.741492,
      NULL,
      5.631583,
      4.620490,
      3,
      0,
      NULL,
      NULL,
      NULL,
      0,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.006551,
      NULL,
      1,
      3,
      0.110659,
      1.167287,
      1.110240,
      NULL,
      33,
      2,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      2.599651,
      0.351504,
      0,
      1,
      2,
      NULL,
      1,
      3.363129,
      1.555467,
      NULL,
      3.736179,
      NULL,
      0.622384,
      2.820637,
      0.187045,
      0.514415,
      1,
      0,
      0.721527,
      1,
      0,
      0.242916,
      0,
      1.816636,
      0,
      NULL,
      3,
      0,
      0.073857,
      NULL,
      NULL,
      1,
      9.807947,
      NULL,
      3.283357,
      NULL,
      0,
      0.837019,
      2.258991,
      3.369873,
      3.913942,
      NULL,
      1,
      2.256841,
      NULL,
      NULL,
      3.696001,
      31,
      5,
      4.863627,
      0.260534,
      NULL,
      '33234',
      '',
      1.742525,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      2.018014,
      43,
      62.078217,
      12,
      NULL,
      47.176240,
      16,
      8,
      NULL,
      3,
      NULL,
      0.610048,
      NULL,
      NULL,
      NULL,
      1,
      1.617329,
      3.678823,
      0,
      1.570745,
      3.975215,
      1,
      3.117535,
      NULL,
      NULL,
      NULL,
      3,
      2.806932,
      3.626941,
      2,
      1,
      2,
      3,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      3,
      2.507248,
      1.929505,
      1,
      NULL,
      NULL,
      5,
      NULL,
      4.481747,
      0.665734,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.664046,
      NULL,
      3,
      3,
      0,
      0.495969,
      2.527002,
      0,
      NULL,
      1,
      1.191090,
      0.469130,
      3.741658,
      0,
      3,
      0.502572,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      0,
      NULL,
      NULL,
      2.263107,
      1.627853,
      0.277322,
      9,
      8.117389,
      2.222085,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.861814,
      3.158924,
      NULL,
      0.317517,
      0.129834,
      0,
      NULL,
      NULL,
      NULL,
      4.188146,
      0.447489,
      NULL,
      NULL,
      1.585847,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      1.623190,
      0.589025,
      NULL,
      NULL,
      1.339567,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.460913,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      5.896470,
      3,
      6,
      2,
      3,
      4,
      4.551026,
      3,
      1,
      1.388080,
      0,
      1.273740,
      2.323497,
      1,
      2,
      3.904687,
      1.945266,
      NULL,
      1,
      4,
      3.346093,
      1.700311,
      3.952877,
      0.322638,
      1,
      1.354146,
      0,
      3.063473,
      NULL,
      NULL,
      3.508684,
      0.588407,
      2,
      2,
      7,
      7.551124,
      7.454836,
      2,
      2,
      2,
      0.358838,
      4,
      0,
      3.308755,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      25,
      NULL,
      NULL,
      0.327863,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.480096,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.445435,
      NULL,
      NULL,
      2.561441,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.776448,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      3,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.420129,
      NULL,
      NULL,
      1,
      3.601686,
      NULL,
      2,
      3.176076,
      NULL,
      NULL,
      3,
      NULL,
      2.085707,
      NULL,
      NULL,
      0,
      1.644005,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.430407,
      3,
      NULL,
      1.568167,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      2,
      3.651636,
      NULL,
      1.404161,
      1,
      1,
      NULL,
      2,
      3,
      2,
      NULL,
      1.973690,
      0,
      1.542562,
      NULL,
      0,
      2.649092,
      1,
      NULL,
      3,
      1.079114,
      1.545551,
      NULL,
      NULL,
      0.449844,
      0.539346,
      NULL,
      1,
      2,
      0.056418,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      7.749684,
      0.981039,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      7.535829,
      24,
      3,
      4,
      NULL,
      3,
      0,
      1286,
      0.713970,
      13.389141,
      8,
      2.385034,
      23,
      7,
      1,
      82,
      13.156836,
      2.281484,
      50.847047,
      1,
      562,
      0.083279,
      3,
      NULL,
      1,
      1.204275,
      NULL,
      NULL,
      0.177078,
      1.214308,
      1,
      0.617911,
      NULL,
      NULL,
      1,
      1.943410,
      1.237934,
      1.379077,
      3,
      1.404321,
      0.194355,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.684333,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      44,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.922359,
      NULL,
      1,
      NULL,
      1.232009,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.648460,
      NULL,
      1,
      NULL,
      0.207966,
      NULL,
      1.136854,
      NULL,
      1,
      NULL,
      2,
      1.555299,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.980824,
      1.321567,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.931844,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.689895,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.013079,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.462996,
      0,
      0.873885,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.950373,
      NULL,
      0.910707,
      NULL,
      0,
      1.806274,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.548459,
      3,
      1.948248,
      0,
      2.932236,
      0.548503,
      NULL,
      0,
      2,
      NULL,
      2,
      NULL,
      0.120759,
      1.033275,
      0.995085,
      1.836079,
      2.838692,
      1,
      2,
      1.132687,
      0,
      3.370757,
      2.095163,
      0,
      1.790514,
      2.030769,
      NULL,
      1,
      2.550402,
      0,
      NULL,
      2,
      NULL,
      1,
      3,
      0,
      1,
      0.041491,
      0.264992,
      0,
      1,
      0,
      1,
      NULL,
      0.474804,
      3,
      0.670152,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      1.165378,
      1,
      2.107844,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1.068460,
      1,
      0.005473,
      0,
      0,
      NULL,
      0,
      0.429103,
      0,
      0.148861,
      0.513775,
      1,
      1,
      17.036506,
      1,
      NULL,
      2,
      1,
      NULL,
      0.507439,
      NULL,
      0,
      0.297363,
      NULL,
      2,
      0.557353,
      1.815438,
      0,
      0,
      3,
      0,
      1,
      NULL,
      NULL,
      0.391107,
      2.308558,
      3,
      1.360648,
      2.862816,
      0.930361,
      NULL,
      0.365287,
      0.403794,
      197,
      1.534218,
      NULL,
      0.203348,
      1.715232,
      0.299048,
      0,
      NULL,
      1,
      6,
      9.485595,
      NULL,
      3,
      NULL,
      3.391682,
      35.506297,
      62.118337,
      5.309102,
      4.675319,
      1.809536,
      '20004',
      '44341',
      NULL,
      1,
      '',
      '',
      NULL,
      1,
      '',
      NULL,
      '');
commit;
end;
/


