set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9800889';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-9-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      5,
      1.470756,
      0.224998,
      1.498428,
      0,
      NULL,
      '341',
      '00421041',
      40,
      NULL,
      '0431420',
      1,
      0.948283,
      0,
      2,
      NULL,
      1.145596,
      0.316170,
      NULL,
      NULL,
      ' 9- 4-1983',
      131.159030,
      36.663388,
      NULL,
      0.159596,
      2.339580,
      ' 3-27-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-25-1977',
      ' 3- 9-1994',
      3.885092,
      2.171956,
      2.362964,
      2,
      0.585529,
      1,
      5,
      1.340889,
      NULL,
      NULL,
      NULL,
      11,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0,
      NULL,
      2.107687,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.493799,
      NULL,
      2.312120,
      2.592978,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      9.198744,
      8,
      0,
      NULL,
      2.833201,
      1,
      0,
      4.252325,
      0.444411,
      2.620681,
      0,
      1,
      1.674868,
      NULL,
      NULL,
      1.474351,
      NULL,
      NULL,
      5,
      2,
      1.799954,
      1,
      1.121993,
      NULL,
      2,
      0.619417,
      1.327818,
      1,
      2.193556,
      1,
      0.542670,
      2,
      2.959429,
      0.337438,
      NULL,
      NULL,
      NULL,
      5.743777,
      1,
      9.793449,
      NULL,
      0.681529,
      1.167733,
      1,
      1.405909,
      NULL,
      NULL,
      1.146379,
      NULL,
      NULL,
      0,
      0,
      4.082424,
      NULL,
      5,
      0.580910,
      1.483707,
      0.374178,
      0.568361,
      1.336739,
      0.912298,
      5,
      0,
      0.280819,
      0,
      0,
      0,
      1,
      0.934480,
      NULL,
      0,
      NULL,
      5,
      1,
      0.514470,
      2,
      11.837521,
      3.339281,
      0,
      0,
      NULL,
      1,
      0.268730,
      2.337144,
      1.978057,
      6.872918,
      2,
      5,
      2.393766,
      NULL,
      5,
      3.974375,
      2,
      4.215952,
      2.156513,
      1,
      1.516126,
      0.434707,
      NULL,
      833.746473,
      ' 9- 6-1991',
      479,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.608015,
      0,
      0.202286,
      NULL,
      NULL,
      4.159918,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.442856,
      1,
      3.405476,
      1,
      1,
      1,
      5.373283,
      1.214076,
      2.465345,
      1,
      1,
      3,
      3.727348,
      0,
      NULL,
      NULL,
      0,
      3,
      1.185486,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      1.873331,
      0,
      1,
      0.170616,
      48,
      0,
      1,
      NULL,
      NULL,
      NULL,
      5,
      1.917584,
      1,
      4,
      NULL,
      0,
      4,
      5,
      NULL,
      1,
      3,
      3,
      4.465527,
      0,
      0.424054,
      2,
      2,
      1.739580,
      0.425871,
      4.687250,
      0,
      0.562139,
      3.163115,
      1,
      1,
      0,
      NULL,
      0,
      0,
      2.538835,
      NULL,
      1,
      6.048101,
      NULL,
      1,
      NULL,
      10,
      2,
      2.420418,
      0.108353,
      7,
      3,
      3.907005,
      2,
      NULL,
      3.501350,
      3.884160,
      5,
      NULL,
      44.620817,
      35.029262,
      2.742101,
      5,
      2,
      '32224',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.875636,
      '',
      NULL,
      NULL,
      2,
      5,
      94,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.577334,
      0.644148,
      3,
      0,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.699751,
      NULL,
      3,
      0,
      0.480275,
      0.634736,
      1,
      NULL,
      NULL,
      0.464499,
      NULL,
      NULL,
      NULL,
      2.275913,
      0.075424,
      3,
      NULL,
      2.286636,
      NULL,
      NULL,
      NULL,
      6,
      3.408063,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.501426,
      NULL,
      NULL,
      NULL,
      2,
      2.925289,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0,
      0.937010,
      1.363553,
      NULL,
      0,
      2,
      0,
      1.731468,
      1.288310,
      3.488011,
      2.133284,
      NULL,
      3.899912,
      1,
      NULL,
      0.479747,
      3.518652,
      3.525788,
      1.768397,
      NULL,
      NULL,
      3.025772,
      1,
      3,
      9.126195,
      NULL,
      NULL,
      NULL,
      0.669190,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.340548,
      NULL,
      NULL,
      1,
      1.763388,
      0.616121,
      1,
      NULL,
      NULL,
      3,
      1,
      1,
      3.325072,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4.040716,
      0,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.047943,
      NULL,
      NULL,
      0.332692,
      NULL,
      NULL,
      1.486232,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0.774023,
      10,
      NULL,
      6.882465,
      1.538095,
      3,
      1,
      5,
      0,
      5.027500,
      2,
      0.770551,
      0,
      3.667058,
      1,
      3,
      0.578157,
      1,
      1.046387,
      4.532804,
      0.680598,
      0.850034,
      1.531527,
      NULL,
      3.782735,
      2.813570,
      2.478632,
      2.809428,
      1,
      1,
      NULL,
      1,
      1,
      0.183215,
      2.460108,
      1,
      0,
      3,
      2.250203,
      NULL,
      3.483187,
      3,
      NULL,
      0,
      NULL,
      0.519828,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.179283,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.878256,
      NULL,
      NULL,
      0.688263,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.210201,
      NULL,
      NULL,
      2.534654,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      3.399663,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.310523,
      1,
      NULL,
      1.411368,
      0,
      1,
      0.741105,
      NULL,
      NULL,
      0.629378,
      NULL,
      NULL,
      0.610229,
      NULL,
      NULL,
      0.521407,
      NULL,
      NULL,
      0.891887,
      NULL,
      0,
      192,
      1,
      1.055016,
      NULL,
      0.130285,
      1,
      1.699439,
      1.988178,
      1.950356,
      1.488830,
      1.024690,
      1.283166,
      NULL,
      NULL,
      1,
      0,
      1,
      1.514423,
      1.864160,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.489376,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.125458,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.369166,
      3.112025,
      NULL,
      1.832135,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.293872,
      NULL,
      1,
      NULL,
      1,
      0,
      0.090037,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.417116,
      0.847671,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.611638,
      1,
      NULL,
      2.560968,
      NULL,
      1.298699,
      NULL,
      NULL,
      NULL,
      0.217289,
      NULL,
      1,
      NULL,
      1.244384,
      0.879238,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.804559,
      2,
      1.771973,
      NULL,
      3.803413,
      7,
      3,
      NULL,
      6,
      2.117680,
      3,
      1,
      0.545710,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      1.942826,
      1,
      NULL,
      1.869029,
      3.001794,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.814043,
      NULL,
      1,
      2,
      NULL,
      NULL,
      3.766928,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      1.794430,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.709579,
      NULL,
      2.730595,
      9,
      11,
      NULL,
      NULL,
      3.952903,
      55.353978,
      37,
      NULL,
      NULL,
      0,
      '31402',
      NULL,
      '',
      0,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      NULL);
commit;
end;
/


